// Author:  Bruce Allen
// Created: 2/25/2013
//
// The software provided here is released by the Naval Postgraduate
// School, an agency of the U.S. Department of Navy.  The software
// bears no warranty, either expressed or implied. NPS does not assume
// legal liability nor responsibility for a User's use of the software
// or the results of such use.
//
// Please note that within the United States, copyright protection,
// under Section 105 of the United States Code, Title 17, is not
// available for any work of the United States Government and/or for
// any works created by United States Government employees. User
// acknowledges that this software contains work which was created by
// NPS government employees and is therefore in the public domain and
// not subject to copyright.
//
// Released into the public domain on February 25, 2013 by Bruce Allen.

/**
 * \file
 * Calculate entropy from data.
 *
 * Adapted from bulk_extractor/scan_hashdb.cpp and bulk_extractor sbuf.
 */

#ifndef CALCULATE_BLOCK_LABEL_HPP
#define CALCULATE_BLOCK_LABEL_HPP

#include <cstring>
#include <cstdlib>
#include <stdint.h>
#include <assert.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <iostream>
#include <unistd.h>
#include <cctype> // isspace
#include <map> // isspace

namespace hasher {

  /**
   * safely calculate block label by padding with zeros on overflow.
   */
  std::string calculate_block_label(const uint8_t* const buffer,
                                    const size_t buffer_size,
                                    const size_t offset,
                                    const size_t count);

} // end namespace hasher

#endif
