/*
 * Decompiled with CFR 0.152.
 */
package halcyon.ide;

public class ScriptBuilder {
    String scriptName;
    String scriptDesc;
    String scriptAuthor;
    String scriptService;
    String scriptCateg;
    String port;
    String protocol;
    String service = null;

    public void setTemplate(String name, String desc, String author, String service, Object[] categ) {
        this.scriptName = name;
        this.scriptDesc = desc;
        this.scriptAuthor = author;
        String t = "{";
        int i = 0;
        for (Object c : categ) {
            t = t + "\"" + c + "\"";
            if (i < categ.length - 1) {
                t = t + ", ";
            }
            ++i;
        }
        this.scriptCateg = t = t + "}";
        this.scriptService = service;
        this.setServiceVars(this.scriptService);
    }

    public void setServiceVars(String s) {
        if (s.contains("/")) {
            String[] split1 = s.split(" ");
            String[] split2 = split1[0].split("/");
            this.port = split2[0];
            this.protocol = split2[1];
            this.service = split1[1];
        }
    }

    public StringBuilder createTemplate() {
        StringBuilder template = new StringBuilder("local shortport = require \"shortport\"");
        template.append("\r\n\r\n");
        template.append("description = [[");
        template.append(this.scriptDesc);
        template.append("]]");
        template.append("\r\n\r\n");
        template.append("author = \"" + this.scriptAuthor + "\"\r\n");
        template.append("license = \"Same as Nmap--See http://nmap.org/book/man-legal.html\"");
        template.append("\r\n");
        template.append("categories = " + this.scriptCateg + "\r\n");
        template.append("\r\n\r\n");
        template.append(this.getPortrule());
        template.append("\r\n\r\n");
        template.append("action = function(host, port)");
        template.append("\r\n\r\n");
        template.append("\r\n\r\n");
        template.append("end");
        template.append("\r\n\r\n");
        return template;
    }

    public String getPortrule() {
        String rule = null;
        rule = this.scriptService.equals("Default Port Rule") ? "portrule = function( host, port )\n\treturn true\nend\n" : (this.port.equals("80") || this.service.equals("HTTP") ? "portrule = shortport.http" : (this.port.equals("21") || this.service.equals("FTP") ? "portrule = shortport.service(\"ftp\")" : "portrule = shortport.port_or_service(" + this.port + ", '" + this.service.toLowerCase() + "', '" + this.protocol + "')"));
        return rule;
    }
}

