/*
 * Decompiled with CFR 0.152.
 */
package halcyon.ide;

import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FileSystemModel
implements TreeModel {
    private File root;
    private Vector listeners = new Vector();

    public FileSystemModel(File rootDirectory) {
        this.root = rootDirectory;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        File directory = (File)parent;
        String[] children = directory.list();
        return new TreeFile(directory, children[index]);
    }

    @Override
    public int getChildCount(Object parent) {
        String[] fileList;
        File file = (File)parent;
        if (file.isDirectory() && (fileList = file.list()) != null) {
            return file.list().length;
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        File file = (File)node;
        return file.isFile();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        File directory = (File)parent;
        File file = (File)child;
        String[] children = directory.list();
        for (int i = 0; i < children.length; ++i) {
            if (!file.getName().equals(children[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object value) {
        File oldFile = (File)path.getLastPathComponent();
        String fileParentPath = oldFile.getParent();
        String newFileName = (String)value;
        File targetFile = new File(fileParentPath, newFileName);
        oldFile.renameTo(targetFile);
        File parent = new File(fileParentPath);
        int[] changedChildrenIndices = new int[]{this.getIndexOfChild(parent, targetFile)};
        Object[] changedChildren = new Object[]{targetFile};
        this.fireTreeNodesChanged(path.getParentPath(), changedChildrenIndices, changedChildren);
    }

    private void fireTreeNodesChanged(TreePath parentPath, int[] indices, Object[] children) {
        TreeModelEvent event = new TreeModelEvent((Object)this, parentPath, indices, children);
        Iterator iterator = this.listeners.iterator();
        TreeModelListener listener = null;
        while (iterator.hasNext()) {
            listener = (TreeModelListener)iterator.next();
            listener.treeNodesChanged(event);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }

    private class TreeFile
    extends File {
        public TreeFile(File parent, String child) {
            super(parent, child);
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

