/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(value="Autoescape the tag's contents", hidden=true, snippets={@JinjavaSnippet(code="{% autoescape %}\n<div>Code to escape</div>\n{% endautoescape %}")})
public class AutoEscapeTag
implements Tag {
    private static final long serialVersionUID = 786006577642541285L;

    @Override
    public String getName() {
        return "autoescape";
    }

    @Override
    public String getEndTagName() {
        return "endautoescape";
    }

    @Override
    public boolean isRenderedInValidationMode() {
        return true;
    }

    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        try (JinjavaInterpreter.InterpreterScopeClosable c = interpreter.enterScope();){
            String boolFlagStr = StringUtils.trim((String)tagNode.getHelpers());
            boolean escapeFlag = BooleanUtils.toBoolean((String)(StringUtils.isNotBlank((CharSequence)boolFlagStr) ? boolFlagStr : "true"));
            interpreter.getContext().setAutoEscape(escapeFlag);
            LengthLimitingStringBuilder result = new LengthLimitingStringBuilder(interpreter.getConfig().getMaxOutputSize());
            for (Node child : tagNode.getChildren()) {
                result.append(child.render(interpreter));
            }
            String string = result.toString();
            return string;
        }
    }
}

