/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.math.BigDecimal;
import java.math.BigInteger;

@JinjavaDoc(value="Multiplies the current object with the given multiplier", params={@JinjavaParam(value="value", type="number", desc="Base number to be multiplied"), @JinjavaParam(value="multiplier", type="number", desc="The multiplier")}, snippets={@JinjavaSnippet(code="{% set n = 20 %}\n{{ n|multiply(3) }}")})
public class MultiplyFilter
implements Filter {
    @Override
    public Object filter(Object object, JinjavaInterpreter interpreter, String ... arg) {
        if (arg.length != 1) {
            throw new InterpretException("filter multiply expects 1 arg >>> " + arg.length);
        }
        String toMul = arg[0];
        BigDecimal num = new BigDecimal(toMul);
        if (object instanceof Integer) {
            return ((Number)num).intValue() * (Integer)object;
        }
        if (object instanceof Float) {
            return 0.0 + (double)(((Number)num).floatValue() * ((Float)object).floatValue());
        }
        if (object instanceof Long) {
            return ((Number)num).longValue() * (Long)object;
        }
        if (object instanceof Short) {
            return 0 + num.shortValue() * (Short)object;
        }
        if (object instanceof Double) {
            return ((Number)num).doubleValue() * (Double)object;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).multiply(BigDecimal.valueOf(((Number)num).doubleValue()));
        }
        if (object instanceof BigInteger) {
            return ((BigInteger)object).multiply(BigInteger.valueOf(((Number)num).longValue()));
        }
        if (object instanceof Byte) {
            return num.byteValue() * (Byte)object;
        }
        if (object instanceof String) {
            try {
                return ((Number)num).doubleValue() * Double.parseDouble((String)object);
            }
            catch (Exception e) {
                throw new InterpretException(object + " can't be dealed with multiply filter", e);
            }
        }
        return object;
    }

    @Override
    public String getName() {
        return "multiply";
    }
}

