/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.AdvancedFilter;
import com.hubspot.jinjava.lib.filter.BaseDateFilter;
import com.hubspot.jinjava.lib.fn.Functions;
import com.hubspot.jinjava.objects.date.PyishDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;

@JinjavaDoc(value="Calculates the time between two datetime objects", params={@JinjavaParam(value="begin", desc="Datetime object or timestamp at the beginning of the period"), @JinjavaParam(value="end", desc="Datetime object or timestamp at the end of the period"), @JinjavaParam(value="unit", desc="Which temporal unit to use")}, snippets={@JinjavaSnippet(code="{% begin|between_times(end, 'hours') %}")})
public class BetweenTimesFilter
implements AdvancedFilter {
    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, Object[] args, Map<String, Object> kwargs) {
        if (args.length < 2) {
            throw new InterpretException(String.format("%s filter requires a datetime and a string parameter", this.getName()));
        }
        ZonedDateTime start = this.getZonedDateTime(var);
        ZonedDateTime end = this.getZonedDateTime(args[0]);
        Object args1 = args[1];
        if (!(args1 instanceof String)) {
            throw new InterpretException(String.format("%s filter requires a string as the second parameter", this.getName()));
        }
        ChronoUnit temporalUnit = BaseDateFilter.getTemporalUnit((String)args[1]);
        return temporalUnit.between(start, end);
    }

    private ZonedDateTime getZonedDateTime(Object var) {
        if (var instanceof ZonedDateTime) {
            return (ZonedDateTime)var;
        }
        if (var instanceof PyishDate) {
            return ((PyishDate)var).toDateTime();
        }
        return Functions.getDateTimeArg(var, ZoneOffset.UTC);
    }

    @Override
    public String getName() {
        return "between_times";
    }
}

