/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector.javaserial;

import gadgetinspector.SerializableDecider;
import gadgetinspector.data.ClassReference;
import gadgetinspector.data.InheritanceMap;
import java.util.HashMap;
import java.util.Map;

public class SimpleSerializableDecider
implements SerializableDecider {
    private final Map<ClassReference.Handle, Boolean> cache = new HashMap<ClassReference.Handle, Boolean>();
    private final InheritanceMap inheritanceMap;

    public SimpleSerializableDecider(InheritanceMap inheritanceMap) {
        this.inheritanceMap = inheritanceMap;
    }

    @Override
    public Boolean apply(ClassReference.Handle handle) {
        Boolean cached = this.cache.get(handle);
        if (cached != null) {
            return cached;
        }
        Boolean result = this.applyNoCache(handle);
        this.cache.put(handle, result);
        return result;
    }

    private Boolean applyNoCache(ClassReference.Handle handle) {
        if (SimpleSerializableDecider.isBlacklistedClass(handle)) {
            return false;
        }
        if (this.inheritanceMap.isSubclassOf(handle, new ClassReference.Handle("java/io/Serializable"))) {
            return true;
        }
        return false;
    }

    private static boolean isBlacklistedClass(ClassReference.Handle clazz) {
        if (clazz.getName().startsWith("com/google/common/collect/")) {
            return true;
        }
        return clazz.getName().equals("clojure/core/proxy$clojure/lang/APersistentMap$ff19274a") || clazz.getName().equals("clojure/inspector/proxy$javax/swing/table/AbstractTableModel$ff19274a");
    }
}

