/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector.javaserial;

import gadgetinspector.ImplementationFinder;
import gadgetinspector.SerializableDecider;
import gadgetinspector.data.MethodReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SimpleImplementationFinder
implements ImplementationFinder {
    private final SerializableDecider serializableDecider;
    private final Map<MethodReference.Handle, Set<MethodReference.Handle>> methodImplMap;

    public SimpleImplementationFinder(SerializableDecider serializableDecider, Map<MethodReference.Handle, Set<MethodReference.Handle>> methodImplMap) {
        this.serializableDecider = serializableDecider;
        this.methodImplMap = methodImplMap;
    }

    @Override
    public Set<MethodReference.Handle> getImplementations(MethodReference.Handle target) {
        HashSet<MethodReference.Handle> allImpls = new HashSet<MethodReference.Handle>();
        allImpls.add(target);
        Set<MethodReference.Handle> subClassImpls = this.methodImplMap.get(target);
        if (subClassImpls != null) {
            for (MethodReference.Handle subClassImpl : subClassImpls) {
                if (!Boolean.TRUE.equals(this.serializableDecider.apply(subClassImpl.getClassReference()))) continue;
                allImpls.add(subClassImpl);
            }
        }
        return allImpls;
    }
}

