/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector.data;

import gadgetinspector.data.ClassReference;
import gadgetinspector.data.DataFactory;
import gadgetinspector.data.DataLoader;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InheritanceMap {
    private final Map<ClassReference.Handle, Set<ClassReference.Handle>> inheritanceMap;
    private final Map<ClassReference.Handle, Set<ClassReference.Handle>> subClassMap;

    public InheritanceMap(Map<ClassReference.Handle, Set<ClassReference.Handle>> inheritanceMap) {
        this.inheritanceMap = inheritanceMap;
        this.subClassMap = new HashMap<ClassReference.Handle, Set<ClassReference.Handle>>();
        for (Map.Entry<ClassReference.Handle, Set<ClassReference.Handle>> entry : inheritanceMap.entrySet()) {
            ClassReference.Handle child = entry.getKey();
            for (ClassReference.Handle parent : entry.getValue()) {
                this.subClassMap.computeIfAbsent(parent, k -> new HashSet()).add(child);
            }
        }
    }

    public Set<Map.Entry<ClassReference.Handle, Set<ClassReference.Handle>>> entrySet() {
        return this.inheritanceMap.entrySet();
    }

    public Set<ClassReference.Handle> getSuperClasses(ClassReference.Handle clazz) {
        Set<ClassReference.Handle> parents = this.inheritanceMap.get(clazz);
        if (parents == null) {
            return null;
        }
        return Collections.unmodifiableSet(parents);
    }

    public boolean isSubclassOf(ClassReference.Handle clazz, ClassReference.Handle superClass) {
        Set<ClassReference.Handle> parents = this.inheritanceMap.get(clazz);
        if (parents == null) {
            return false;
        }
        return parents.contains(superClass);
    }

    public Set<ClassReference.Handle> getSubClasses(ClassReference.Handle clazz) {
        Set<ClassReference.Handle> subClasses = this.subClassMap.get(clazz);
        if (subClasses == null) {
            return null;
        }
        return Collections.unmodifiableSet(subClasses);
    }

    public void save() throws IOException {
        DataLoader.saveData(Paths.get("inheritanceMap.dat", new String[0]), new InheritanceMapFactory(), this.inheritanceMap.entrySet());
    }

    public static InheritanceMap load() throws IOException {
        HashMap<ClassReference.Handle, Set<ClassReference.Handle>> inheritanceMap = new HashMap<ClassReference.Handle, Set<ClassReference.Handle>>();
        for (Map.Entry<ClassReference.Handle, Set<ClassReference.Handle>> entry : DataLoader.loadData(Paths.get("inheritanceMap.dat", new String[0]), new InheritanceMapFactory())) {
            inheritanceMap.put(entry.getKey(), entry.getValue());
        }
        return new InheritanceMap(inheritanceMap);
    }

    private static class InheritanceMapFactory
    implements DataFactory<Map.Entry<ClassReference.Handle, Set<ClassReference.Handle>>> {
        private InheritanceMapFactory() {
        }

        @Override
        public Map.Entry<ClassReference.Handle, Set<ClassReference.Handle>> parse(String[] fields) {
            ClassReference.Handle clazz = new ClassReference.Handle(fields[0]);
            HashSet<ClassReference.Handle> superClasses = new HashSet<ClassReference.Handle>();
            for (int i = 1; i < fields.length; ++i) {
                superClasses.add(new ClassReference.Handle(fields[i]));
            }
            return new AbstractMap.SimpleEntry<ClassReference.Handle, Set<ClassReference.Handle>>(clazz, superClasses);
        }

        @Override
        public String[] serialize(Map.Entry<ClassReference.Handle, Set<ClassReference.Handle>> obj) {
            String[] fields = new String[obj.getValue().size() + 1];
            fields[0] = obj.getKey().getName();
            int i = 1;
            for (ClassReference.Handle handle : obj.getValue()) {
                fields[i++] = handle.getName();
            }
            return fields;
        }
    }
}

