/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector.data;

import gadgetinspector.data.ClassReference;
import gadgetinspector.data.InheritanceMap;
import gadgetinspector.data.MethodReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InheritanceDeriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(InheritanceDeriver.class);

    public static InheritanceMap derive(Map<ClassReference.Handle, ClassReference> classMap) {
        LOGGER.debug("Calculating inheritance for " + classMap.size() + " classes...");
        HashMap<ClassReference.Handle, Set<ClassReference.Handle>> implicitInheritance = new HashMap<ClassReference.Handle, Set<ClassReference.Handle>>();
        for (ClassReference classReference : classMap.values()) {
            if (implicitInheritance.containsKey(classReference.getHandle())) {
                throw new IllegalStateException("Already derived implicit classes for " + classReference.getName());
            }
            HashSet<ClassReference.Handle> allParents = new HashSet<ClassReference.Handle>();
            InheritanceDeriver.getAllParents(classReference, classMap, allParents);
            implicitInheritance.put(classReference.getHandle(), allParents);
        }
        return new InheritanceMap(implicitInheritance);
    }

    private static void getAllParents(ClassReference classReference, Map<ClassReference.Handle, ClassReference> classMap, Set<ClassReference.Handle> allParents) {
        HashSet<ClassReference.Handle> parents = new HashSet<ClassReference.Handle>();
        if (classReference.getSuperClass() != null) {
            parents.add(new ClassReference.Handle(classReference.getSuperClass()));
        }
        for (String iface : classReference.getInterfaces()) {
            parents.add(new ClassReference.Handle(iface));
        }
        for (ClassReference.Handle immediateParent : parents) {
            ClassReference parentClassReference = classMap.get(immediateParent);
            if (parentClassReference == null) {
                LOGGER.debug("No class id for " + immediateParent.getName());
                continue;
            }
            allParents.add(parentClassReference.getHandle());
            InheritanceDeriver.getAllParents(parentClassReference, classMap, allParents);
        }
    }

    public static Map<MethodReference.Handle, Set<MethodReference.Handle>> getAllMethodImplementations(InheritanceMap inheritanceMap, Map<MethodReference.Handle, MethodReference> methodMap) {
        Set subClasses;
        HashMap<ClassReference.Handle, Object> methodsByClass = new HashMap<ClassReference.Handle, Object>();
        for (MethodReference.Handle handle : methodMap.keySet()) {
            ClassReference.Handle handle2 = handle.getClassReference();
            if (!methodsByClass.containsKey(handle2)) {
                HashSet<MethodReference.Handle> methods = new HashSet<MethodReference.Handle>();
                methods.add(handle);
                methodsByClass.put(handle2, methods);
                continue;
            }
            ((Set)methodsByClass.get(handle2)).add(handle);
        }
        HashMap subClassMap = new HashMap();
        for (Map.Entry<ClassReference.Handle, Set<ClassReference.Handle>> entry : inheritanceMap.entrySet()) {
            for (ClassReference.Handle parent : entry.getValue()) {
                if (!subClassMap.containsKey(parent)) {
                    subClasses = new HashSet<ClassReference.Handle>();
                    subClasses.add(entry.getKey());
                    subClassMap.put(parent, subClasses);
                    continue;
                }
                ((Set)subClassMap.get(parent)).add(entry.getKey());
            }
        }
        HashMap<MethodReference.Handle, Set<MethodReference.Handle>> hashMap = new HashMap<MethodReference.Handle, Set<MethodReference.Handle>>();
        for (MethodReference method : methodMap.values()) {
            if (method.isStatic()) continue;
            HashSet<MethodReference.Handle> overridingMethods = new HashSet<MethodReference.Handle>();
            subClasses = (Set)subClassMap.get(method.getClassReference());
            if (subClasses != null) {
                for (ClassReference.Handle subClass : subClasses) {
                    Set subClassMethods = (Set)methodsByClass.get(subClass);
                    if (subClassMethods == null) continue;
                    for (MethodReference.Handle subClassMethod : subClassMethods) {
                        if (!subClassMethod.getName().equals(method.getName()) || !subClassMethod.getDesc().equals(method.getDesc())) continue;
                        overridingMethods.add(subClassMethod);
                    }
                }
            }
            if (overridingMethods.size() <= 0) continue;
            hashMap.put(method.getHandle(), overridingMethods);
        }
        return hashMap;
    }
}

