/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector;

import gadgetinspector.SerializableDecider;
import gadgetinspector.data.ClassReference;
import gadgetinspector.data.InheritanceMap;
import gadgetinspector.data.MethodReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.commons.AnalyzerAdapter;

public class TaintTrackingMethodVisitor<T>
extends MethodVisitor {
    private static final Object[][] PASSTHROUGH_DATAFLOW = new Object[][]{{"java/lang/Object", "toString", "()Ljava/lang/String;", 0}, {"java/io/ObjectInputStream", "readObject", "()Ljava/lang/Object;", 0}, {"java/io/ObjectInputStream", "readFields", "()Ljava/io/ObjectInputStream$GetField;", 0}, {"java/io/ObjectInputStream$GetField", "get", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", 0}, {"java/lang/Object", "getClass", "()Ljava/lang/Class;", 0}, {"java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", 0}, {"java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", 0, 1}, {"java/lang/Class", "getMethods", "()[Ljava/lang/reflect/Method;", 0}, {"java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", 0, 1}, {"java/lang/StringBuilder", "<init>", "(Ljava/lang/CharSequence;)V", 0, 1}, {"java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;", 0, 1}, {"java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", 0, 1}, {"java/lang/StringBuilder", "append", "(Ljava/lang/StringBuffer;)Ljava/lang/StringBuilder;", 0, 1}, {"java/lang/StringBuilder", "append", "(Ljava/lang/CharSequence;)Ljava/lang/StringBuilder;", 0, 1}, {"java/lang/StringBuilder", "append", "(Ljava/lang/CharSequence;II)Ljava/lang/StringBuilder;", 0, 1}, {"java/lang/StringBuilder", "toString", "()Ljava/lang/String;", 0}, {"java/io/ByteArrayInputStream", "<init>", "([B)V", 1}, {"java/io/ByteArrayInputStream", "<init>", "([BII)V", 1}, {"java/io/ObjectInputStream", "<init>", "(Ljava/io/InputStream;)V", 1}, {"java/io/File", "<init>", "(Ljava/lang/String;I)V", 1}, {"java/io/File", "<init>", "(Ljava/lang/String;Ljava/io/File;)V", 1}, {"java/io/File", "<init>", "(Ljava/lang/String;)V", 1}, {"java/io/File", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", 1}, {"java/nio/paths/Paths", "get", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", 0}, {"java/net/URL", "<init>", "(Ljava/lang/String;)V", 1}};
    private final InheritanceMap inheritanceMap;
    private final Map<MethodReference.Handle, Set<Integer>> passthroughDataflow;
    private final AnalyzerAdapter analyzerAdapter;
    private final int access;
    private final String name;
    private final String desc;
    private final String signature;
    private final String[] exceptions;
    private SavedVariableState<T> savedVariableState = new SavedVariableState();
    private Map<Label, SavedVariableState<T>> gotoStates = new HashMap<Label, SavedVariableState<T>>();
    private Set<Label> exceptionHandlerLabels = new HashSet<Label>();

    public TaintTrackingMethodVisitor(InheritanceMap inheritanceMap, Map<MethodReference.Handle, Set<Integer>> passthroughDataflow, int api, MethodVisitor mv, String owner, int access, String name, String desc, String signature, String[] exceptions) {
        super(api, new AnalyzerAdapter(owner, access, name, desc, mv));
        this.inheritanceMap = inheritanceMap;
        this.passthroughDataflow = passthroughDataflow;
        this.analyzerAdapter = (AnalyzerAdapter)this.mv;
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.exceptions = exceptions;
    }

    @Override
    public void visitCode() {
        super.visitCode();
        this.savedVariableState.localVars.clear();
        this.savedVariableState.stackVars.clear();
        if ((this.access & 8) == 0) {
            this.savedVariableState.localVars.add(new HashSet());
        }
        for (Type argType : Type.getArgumentTypes(this.desc)) {
            for (int i = 0; i < argType.getSize(); ++i) {
                this.savedVariableState.localVars.add(new HashSet());
            }
        }
    }

    private void push(T ... possibleValues) {
        HashSet<T> vars = new HashSet<T>();
        for (T s2 : possibleValues) {
            vars.add(s2);
        }
        this.savedVariableState.stackVars.add(vars);
    }

    private void push(Set<T> possibleValues) {
        this.savedVariableState.stackVars.add(possibleValues);
    }

    private Set<T> pop() {
        return this.savedVariableState.stackVars.remove(this.savedVariableState.stackVars.size() - 1);
    }

    private Set<T> get(int stackIndex) {
        return this.savedVariableState.stackVars.get(this.savedVariableState.stackVars.size() - 1 - stackIndex);
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        int i;
        if (type != -1) {
            throw new IllegalStateException("Compressed frame encountered; class reader should use accept() with EXPANDED_FRAMES option.");
        }
        int stackSize = 0;
        for (int i2 = 0; i2 < nStack; ++i2) {
            Object typ = stack[i2];
            int objectSize = 1;
            if (typ.equals(Opcodes.LONG) || typ.equals(Opcodes.DOUBLE)) {
                objectSize = 2;
            }
            for (int j = this.savedVariableState.stackVars.size(); j < stackSize + objectSize; ++j) {
                this.savedVariableState.stackVars.add(new HashSet());
            }
            stackSize += objectSize;
        }
        int localSize = 0;
        for (i = 0; i < nLocal; ++i) {
            Object typ = local[i];
            int objectSize = 1;
            if (typ.equals(Opcodes.LONG) || typ.equals(Opcodes.DOUBLE)) {
                objectSize = 2;
            }
            for (int j = this.savedVariableState.localVars.size(); j < localSize + objectSize; ++j) {
                this.savedVariableState.localVars.add(new HashSet());
            }
            localSize += objectSize;
        }
        for (i = this.savedVariableState.stackVars.size() - stackSize; i > 0; --i) {
            this.savedVariableState.stackVars.remove(this.savedVariableState.stackVars.size() - 1);
        }
        for (i = this.savedVariableState.localVars.size() - localSize; i > 0; --i) {
            this.savedVariableState.localVars.remove(this.savedVariableState.localVars.size() - 1);
        }
        super.visitFrame(type, nLocal, local, nStack, stack);
        this.sanityCheck();
    }

    @Override
    public void visitInsn(int opcode) {
        this.sanityCheck();
        switch (opcode) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                this.push(new Object[0]);
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                this.push(new Object[0]);
                this.push(new Object[0]);
                break;
            }
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.pop();
                this.pop();
                this.push(new Object[0]);
                break;
            }
            case 47: 
            case 49: {
                this.pop();
                this.pop();
                this.push(new Object[0]);
                this.push(new Object[0]);
                break;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.pop();
                this.pop();
                this.pop();
                break;
            }
            case 80: 
            case 82: {
                this.pop();
                this.pop();
                this.pop();
                this.pop();
                break;
            }
            case 87: {
                this.pop();
                break;
            }
            case 88: {
                this.pop();
                this.pop();
                break;
            }
            case 89: {
                this.push(this.get(0));
                break;
            }
            case 90: {
                Set<T> saved0 = this.pop();
                Set<T> saved1 = this.pop();
                this.push(saved0);
                this.push(saved1);
                this.push(saved0);
                break;
            }
            case 91: {
                Set<T> saved0 = this.pop();
                Set<T> saved1 = this.pop();
                Set<T> saved2 = this.pop();
                this.push(saved0);
                this.push(saved2);
                this.push(saved1);
                this.push(saved0);
                break;
            }
            case 92: {
                this.push(this.get(1));
                this.push(this.get(1));
                break;
            }
            case 93: {
                Set<T> saved0 = this.pop();
                Set<T> saved1 = this.pop();
                Set<T> saved2 = this.pop();
                this.push(saved1);
                this.push(saved0);
                this.push(saved2);
                this.push(saved1);
                this.push(saved0);
                break;
            }
            case 94: {
                Set<T> saved0 = this.pop();
                Set<T> saved1 = this.pop();
                Set<T> saved2 = this.pop();
                Set<T> saved3 = this.pop();
                this.push(saved1);
                this.push(saved0);
                this.push(saved3);
                this.push(saved2);
                this.push(saved1);
                this.push(saved0);
                break;
            }
            case 95: {
                Set<T> saved0 = this.pop();
                Set<T> saved1 = this.pop();
                this.push(saved0);
                this.push(saved1);
                break;
            }
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: {
                this.pop();
                this.pop();
                this.push(new Object[0]);
                break;
            }
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: {
                this.pop();
                this.pop();
                this.pop();
                this.pop();
                this.push(new Object[0]);
                this.push(new Object[0]);
                break;
            }
            case 116: 
            case 118: {
                this.pop();
                this.push(new Object[0]);
                break;
            }
            case 117: 
            case 119: {
                this.pop();
                this.pop();
                this.push(new Object[0]);
                this.push(new Object[0]);
                break;
            }
            case 120: 
            case 122: 
            case 124: {
                this.pop();
                this.pop();
                this.push(new Object[0]);
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                this.pop();
                this.pop();
                this.pop();
                this.push(new Object[0]);
                this.push(new Object[0]);
                break;
            }
            case 126: 
            case 128: 
            case 130: {
                this.pop();
                this.pop();
                this.push(new Object[0]);
                break;
            }
            case 127: 
            case 129: 
            case 131: {
                this.pop();
                this.pop();
                this.pop();
                this.pop();
                this.push(new Object[0]);
                this.push(new Object[0]);
                break;
            }
            case 134: 
            case 145: 
            case 146: 
            case 147: {
                this.pop();
                this.push(new Object[0]);
                break;
            }
            case 133: 
            case 135: {
                this.pop();
                this.push(new Object[0]);
                this.push(new Object[0]);
                break;
            }
            case 136: 
            case 137: {
                this.pop();
                this.pop();
                this.push(new Object[0]);
                break;
            }
            case 138: 
            case 143: {
                this.pop();
                this.pop();
                this.push(new Object[0]);
                this.push(new Object[0]);
                break;
            }
            case 139: {
                this.pop();
                this.push(new Object[0]);
                break;
            }
            case 140: 
            case 141: {
                this.pop();
                this.push(new Object[0]);
                this.push(new Object[0]);
                break;
            }
            case 142: 
            case 144: {
                this.pop();
                this.pop();
                this.push(new Object[0]);
                break;
            }
            case 148: {
                this.pop();
                this.pop();
                this.pop();
                this.pop();
                this.push(new Object[0]);
                break;
            }
            case 149: 
            case 150: {
                this.pop();
                this.pop();
                this.push(new Object[0]);
                break;
            }
            case 151: 
            case 152: {
                this.pop();
                this.pop();
                this.pop();
                this.pop();
                this.push(new Object[0]);
                break;
            }
            case 172: 
            case 174: 
            case 176: {
                this.pop();
                break;
            }
            case 173: 
            case 175: {
                this.pop();
                this.pop();
                break;
            }
            case 177: {
                break;
            }
            case 190: {
                this.pop();
                this.push(new Object[0]);
                break;
            }
            case 191: {
                this.pop();
                break;
            }
            case 194: 
            case 195: {
                this.pop();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported opcode: " + opcode);
            }
        }
        super.visitInsn(opcode);
        this.sanityCheck();
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        switch (opcode) {
            case 16: 
            case 17: {
                this.push(new Object[0]);
                break;
            }
            case 188: {
                this.pop();
                this.push(new Object[0]);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported opcode: " + opcode);
            }
        }
        super.visitIntInsn(opcode, operand);
        this.sanityCheck();
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        for (int i = this.savedVariableState.localVars.size(); i <= var; ++i) {
            this.savedVariableState.localVars.add(new HashSet());
        }
        switch (opcode) {
            case 21: 
            case 23: {
                this.push(new Object[0]);
                break;
            }
            case 22: 
            case 24: {
                this.push(new Object[0]);
                this.push(new Object[0]);
                break;
            }
            case 25: {
                this.push(this.savedVariableState.localVars.get(var));
                break;
            }
            case 54: 
            case 56: {
                this.pop();
                this.savedVariableState.localVars.set(var, new HashSet());
                break;
            }
            case 55: 
            case 57: {
                this.pop();
                this.pop();
                this.savedVariableState.localVars.set(var, new HashSet());
                break;
            }
            case 58: {
                Set<T> saved0 = this.pop();
                this.savedVariableState.localVars.set(var, saved0);
                break;
            }
            case 169: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported opcode: " + opcode);
            }
        }
        super.visitVarInsn(opcode, var);
        this.sanityCheck();
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        switch (opcode) {
            case 187: {
                this.push(new Object[0]);
                break;
            }
            case 189: {
                this.pop();
                this.push(new Object[0]);
                break;
            }
            case 192: {
                break;
            }
            case 193: {
                this.pop();
                this.push(new Object[0]);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported opcode: " + opcode);
            }
        }
        super.visitTypeInsn(opcode, type);
        this.sanityCheck();
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        int typeSize = Type.getType(desc).getSize();
        switch (opcode) {
            case 178: {
                for (int i = 0; i < typeSize; ++i) {
                    this.push(new Object[0]);
                }
                break;
            }
            case 179: {
                for (int i = 0; i < typeSize; ++i) {
                    this.pop();
                }
                break;
            }
            case 180: {
                this.pop();
                for (int i = 0; i < typeSize; ++i) {
                    this.push(new Object[0]);
                }
                break;
            }
            case 181: {
                for (int i = 0; i < typeSize; ++i) {
                    this.pop();
                }
                this.pop();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported opcode: " + opcode);
            }
        }
        super.visitFieldInsn(opcode, owner, name, desc);
        this.sanityCheck();
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        MethodReference.Handle methodHandle = new MethodReference.Handle(new ClassReference.Handle(owner), name, desc);
        Type[] argTypes = Type.getArgumentTypes(desc);
        if (opcode != 184) {
            Type[] extendedArgTypes = new Type[argTypes.length + 1];
            System.arraycopy(argTypes, 0, extendedArgTypes, 1, argTypes.length);
            extendedArgTypes[0] = Type.getObjectType(owner);
            argTypes = extendedArgTypes;
        }
        Type returnType = Type.getReturnType(desc);
        int retSize = returnType.getSize();
        switch (opcode) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                Set<ClassReference.Handle> parents;
                Set<Integer> passthroughArgs;
                int i;
                ArrayList<Set<T>> argTaint = new ArrayList<Set<T>>(argTypes.length);
                for (i = 0; i < argTypes.length; ++i) {
                    argTaint.add(null);
                }
                for (i = 0; i < argTypes.length; ++i) {
                    Object[][] argType = argTypes[i];
                    if (argType.getSize() <= 0) continue;
                    for (int j = 0; j < argType.getSize() - 1; ++j) {
                        this.pop();
                    }
                    argTaint.set(argTypes.length - 1 - i, this.pop());
                }
                Set resultTaint = name.equals("<init>") ? (Set)argTaint.get(0) : new HashSet();
                if (owner.equals("java/io/ObjectInputStream") && name.equals("defaultReadObject") && desc.equals("()V")) {
                    this.savedVariableState.localVars.get(0).addAll((Collection)argTaint.get(0));
                }
                for (Object[] passthrough : PASSTHROUGH_DATAFLOW) {
                    if (!passthrough[0].equals(owner) || !passthrough[1].equals(name) || !passthrough[2].equals(desc)) continue;
                    for (int i2 = 3; i2 < passthrough.length; ++i2) {
                        resultTaint.addAll((Collection)argTaint.get((Integer)passthrough[i2]));
                    }
                }
                if (this.passthroughDataflow != null && (passthroughArgs = this.passthroughDataflow.get(methodHandle)) != null) {
                    for (int arg : passthroughArgs) {
                        resultTaint.addAll((Collection)argTaint.get(arg));
                    }
                }
                if (opcode != 184 && argTypes[0].getSort() == 10 && (parents = this.inheritanceMap.getSuperClasses(new ClassReference.Handle(argTypes[0].getClassName().replace('.', '/')))) != null && (parents.contains(new ClassReference.Handle("java/util/Collection")) || parents.contains(new ClassReference.Handle("java/util/Map")))) {
                    for (int i3 = 1; i3 < argTaint.size(); ++i3) {
                        ((Set)argTaint.get(0)).addAll((Collection)argTaint.get(i3));
                    }
                    if (returnType.getSort() == 10 || returnType.getSort() == 9) {
                        resultTaint.addAll((Collection)argTaint.get(0));
                    }
                }
                if (retSize <= 0) break;
                this.push(resultTaint);
                for (int i4 = 1; i4 < retSize; ++i4) {
                    this.push(new Object[0]);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported opcode: " + opcode);
            }
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        this.sanityCheck();
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        int i;
        int argsSize = 0;
        for (Type type : Type.getArgumentTypes(desc)) {
            argsSize += type.getSize();
        }
        int retSize = Type.getReturnType(desc).getSize();
        for (i = 0; i < argsSize; ++i) {
            this.pop();
        }
        for (i = 0; i < retSize; ++i) {
            this.push(new Object[0]);
        }
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        this.sanityCheck();
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.pop();
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.pop();
                this.pop();
                break;
            }
            case 167: {
                break;
            }
            case 168: {
                this.push(new Object[0]);
                super.visitJumpInsn(opcode, label);
                return;
            }
            default: {
                throw new IllegalStateException("Unsupported opcode: " + opcode);
            }
        }
        this.mergeGotoState(label, this.savedVariableState);
        super.visitJumpInsn(opcode, label);
        this.sanityCheck();
    }

    @Override
    public void visitLabel(Label label) {
        if (this.gotoStates.containsKey(label)) {
            this.savedVariableState = new SavedVariableState<T>(this.gotoStates.get(label));
        }
        if (this.exceptionHandlerLabels.contains(label)) {
            this.push(new HashSet());
        }
        super.visitLabel(label);
        this.sanityCheck();
    }

    @Override
    public void visitLdcInsn(Object cst) {
        if (cst instanceof Long || cst instanceof Double) {
            this.push(new Object[0]);
            this.push(new Object[0]);
        } else {
            this.push(new Object[0]);
        }
        super.visitLdcInsn(cst);
        this.sanityCheck();
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.sanityCheck();
    }

    @Override
    public void visitTableSwitchInsn(int min2, int max, Label dflt, Label ... labels) {
        this.pop();
        this.mergeGotoState(dflt, this.savedVariableState);
        for (Label label : labels) {
            this.mergeGotoState(label, this.savedVariableState);
        }
        super.visitTableSwitchInsn(min2, max, dflt, labels);
        this.sanityCheck();
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.pop();
        this.mergeGotoState(dflt, this.savedVariableState);
        for (Label label : labels) {
            this.mergeGotoState(label, this.savedVariableState);
        }
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.sanityCheck();
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        for (int i = 0; i < dims; ++i) {
            this.pop();
        }
        this.push(new Object[0]);
        super.visitMultiANewArrayInsn(desc, dims);
        this.sanityCheck();
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return super.visitInsnAnnotation(typeRef, typePath, desc, visible);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.exceptionHandlerLabels.add(handler);
        super.visitTryCatchBlock(start, end, handler, type);
    }

    @Override
    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return super.visitTryCatchAnnotation(typeRef, typePath, desc, visible);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack, maxLocals);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
    }

    private void mergeGotoState(Label label, SavedVariableState savedVariableState) {
        if (this.gotoStates.containsKey(label)) {
            SavedVariableState<T> combinedState = new SavedVariableState<T>(this.gotoStates.get(label));
            combinedState.combine(savedVariableState);
            this.gotoStates.put(label, combinedState);
        } else {
            this.gotoStates.put(label, new SavedVariableState(savedVariableState));
        }
    }

    private void sanityCheck() {
        if (this.analyzerAdapter.stack != null && this.savedVariableState.stackVars.size() != this.analyzerAdapter.stack.size()) {
            throw new IllegalStateException("Bad stack size.");
        }
    }

    protected Set<T> getStackTaint(int index) {
        return this.savedVariableState.stackVars.get(this.savedVariableState.stackVars.size() - 1 - index);
    }

    protected void setStackTaint(int index, T ... possibleValues) {
        HashSet<T> values = new HashSet<T>();
        for (T value : possibleValues) {
            values.add(value);
        }
        this.savedVariableState.stackVars.set(this.savedVariableState.stackVars.size() - 1 - index, values);
    }

    protected void setStackTaint(int index, Collection<T> possibleValues) {
        HashSet<T> values = new HashSet<T>();
        values.addAll(possibleValues);
        this.savedVariableState.stackVars.set(this.savedVariableState.stackVars.size() - 1 - index, values);
    }

    protected Set<T> getLocalTaint(int index) {
        return this.savedVariableState.localVars.get(index);
    }

    protected void setLocalTaint(int index, T ... possibleValues) {
        HashSet<T> values = new HashSet<T>();
        for (T value : possibleValues) {
            values.add(value);
        }
        this.savedVariableState.localVars.set(index, values);
    }

    protected void setLocalTaint(int index, Collection<T> possibleValues) {
        HashSet<T> values = new HashSet<T>();
        values.addAll(possibleValues);
        this.savedVariableState.localVars.set(index, values);
    }

    protected static final boolean couldBeSerialized(SerializableDecider serializableDecider, InheritanceMap inheritanceMap, ClassReference.Handle clazz) {
        if (Boolean.TRUE.equals(serializableDecider.apply(clazz))) {
            return true;
        }
        Set<ClassReference.Handle> subClasses = inheritanceMap.getSubClasses(clazz);
        if (subClasses != null) {
            for (ClassReference.Handle subClass : subClasses) {
                if (!Boolean.TRUE.equals(serializableDecider.apply(subClass))) continue;
                return true;
            }
        }
        return false;
    }

    private static class SavedVariableState<T> {
        List<Set<T>> localVars;
        List<Set<T>> stackVars;

        public SavedVariableState() {
            this.localVars = new ArrayList<Set<T>>();
            this.stackVars = new ArrayList<Set<T>>();
        }

        public SavedVariableState(SavedVariableState<T> copy) {
            this.localVars = new ArrayList<Set<T>>(copy.localVars.size());
            this.stackVars = new ArrayList<Set<T>>(copy.stackVars.size());
            for (Set<T> original : copy.localVars) {
                this.localVars.add(new HashSet<T>(original));
            }
            for (Set<T> original : copy.stackVars) {
                this.stackVars.add(new HashSet<T>(original));
            }
        }

        public void combine(SavedVariableState<T> copy) {
            int i;
            for (i = 0; i < copy.localVars.size(); ++i) {
                while (i >= this.localVars.size()) {
                    this.localVars.add(new HashSet());
                }
                this.localVars.get(i).addAll((Collection)copy.localVars.get(i));
            }
            for (i = 0; i < copy.stackVars.size(); ++i) {
                while (i >= this.stackVars.size()) {
                    this.stackVars.add(new HashSet());
                }
                this.stackVars.get(i).addAll((Collection)copy.stackVars.get(i));
            }
        }
    }
}

