/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector;

import gadgetinspector.data.ClassReference;
import gadgetinspector.data.DataLoader;
import gadgetinspector.data.InheritanceMap;
import gadgetinspector.data.MethodReference;
import gadgetinspector.data.Source;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class SourceDiscovery {
    private final List<Source> discoveredSources = new ArrayList<Source>();

    protected final void addDiscoveredSource(Source source) {
        this.discoveredSources.add(source);
    }

    public void discover() throws IOException {
        Map<ClassReference.Handle, ClassReference> classMap = DataLoader.loadClasses();
        Map<MethodReference.Handle, MethodReference> methodMap = DataLoader.loadMethods();
        InheritanceMap inheritanceMap = InheritanceMap.load();
        this.discover(classMap, methodMap, inheritanceMap);
    }

    public abstract void discover(Map<ClassReference.Handle, ClassReference> var1, Map<MethodReference.Handle, MethodReference> var2, InheritanceMap var3);

    public void save() throws IOException {
        DataLoader.saveData(Paths.get("sources.dat", new String[0]), new Source.Factory(), this.discoveredSources);
    }
}

