/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector;

import gadgetinspector.ClassResourceEnumerator;
import gadgetinspector.Util;
import gadgetinspector.data.ClassReference;
import gadgetinspector.data.DataLoader;
import gadgetinspector.data.InheritanceDeriver;
import gadgetinspector.data.MethodReference;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodDiscovery.class);
    private final List<ClassReference> discoveredClasses = new ArrayList<ClassReference>();
    private final List<MethodReference> discoveredMethods = new ArrayList<MethodReference>();

    public void save() throws IOException {
        DataLoader.saveData(Paths.get("classes.dat", new String[0]), new ClassReference.Factory(), this.discoveredClasses);
        DataLoader.saveData(Paths.get("methods.dat", new String[0]), new MethodReference.Factory(), this.discoveredMethods);
        HashMap<ClassReference.Handle, ClassReference> classMap = new HashMap<ClassReference.Handle, ClassReference>();
        for (ClassReference clazz : this.discoveredClasses) {
            classMap.put(clazz.getHandle(), clazz);
        }
        InheritanceDeriver.derive(classMap).save();
    }

    public void discover(ClassResourceEnumerator classResourceEnumerator) throws Exception {
        for (ClassResourceEnumerator.ClassResource classResource : classResourceEnumerator.getAllClasses()) {
            InputStream in = classResource.getInputStream();
            try {
                ClassReader cr = new ClassReader(in);
                try {
                    cr.accept(new MethodDiscoveryClassVisitor(), 8);
                }
                catch (Exception e) {
                    LOGGER.error("Exception analyzing: " + classResource.getName(), e);
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ClassLoader classLoader = Util.getWarClassLoader(Paths.get(args[0], new String[0]));
        MethodDiscovery methodDiscovery = new MethodDiscovery();
        methodDiscovery.discover(new ClassResourceEnumerator(classLoader));
        methodDiscovery.save();
    }

    private class MethodDiscoveryClassVisitor
    extends ClassVisitor {
        private String name;
        private String superName;
        private String[] interfaces;
        boolean isInterface;
        private List<ClassReference.Member> members;
        private ClassReference.Handle classHandle;

        private MethodDiscoveryClassVisitor() throws SQLException {
            super(393216);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.name = name;
            this.superName = superName;
            this.interfaces = interfaces;
            this.isInterface = (access & 0x200) != 0;
            this.members = new ArrayList<ClassReference.Member>();
            this.classHandle = new ClassReference.Handle(name);
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if ((access & 8) == 0) {
                Type type = Type.getType(desc);
                String typeName = type.getSort() == 10 || type.getSort() == 9 ? type.getInternalName() : type.getDescriptor();
                this.members.add(new ClassReference.Member(name, access, new ClassReference.Handle(typeName)));
            }
            return super.visitField(access, name, desc, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            boolean isStatic = (access & 8) != 0;
            MethodDiscovery.this.discoveredMethods.add(new MethodReference(this.classHandle, name, desc, isStatic));
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        @Override
        public void visitEnd() {
            ClassReference classReference = new ClassReference(this.name, this.superName, this.interfaces, this.isInterface, this.members.toArray(new ClassReference.Member[this.members.size()]));
            MethodDiscovery.this.discoveredClasses.add(classReference);
            super.visitEnd();
        }
    }
}

