/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector;

import gadgetinspector.ClassResourceEnumerator;
import gadgetinspector.PassthroughDiscovery;
import gadgetinspector.SerializableDecider;
import gadgetinspector.TaintTrackingMethodVisitor;
import gadgetinspector.Util;
import gadgetinspector.config.GIConfig;
import gadgetinspector.config.JavaDeserializationConfig;
import gadgetinspector.data.ClassReference;
import gadgetinspector.data.DataLoader;
import gadgetinspector.data.GraphCall;
import gadgetinspector.data.InheritanceMap;
import gadgetinspector.data.MethodReference;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallGraphDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallGraphDiscovery.class);
    private final Set<GraphCall> discoveredCalls = new HashSet<GraphCall>();

    public void discover(ClassResourceEnumerator classResourceEnumerator, GIConfig config) throws IOException {
        Map<MethodReference.Handle, MethodReference> methodMap = DataLoader.loadMethods();
        Map<ClassReference.Handle, ClassReference> classMap = DataLoader.loadClasses();
        InheritanceMap inheritanceMap = InheritanceMap.load();
        Map<MethodReference.Handle, Set<Integer>> passthroughDataflow = PassthroughDiscovery.load();
        SerializableDecider serializableDecider = config.getSerializableDecider(methodMap, inheritanceMap);
        for (ClassResourceEnumerator.ClassResource classResource : classResourceEnumerator.getAllClasses()) {
            InputStream in = classResource.getInputStream();
            try {
                ClassReader cr = new ClassReader(in);
                try {
                    cr.accept(new ModelGeneratorClassVisitor(classMap, inheritanceMap, passthroughDataflow, serializableDecider, 393216), 8);
                }
                catch (Exception e) {
                    LOGGER.error("Error analyzing: " + classResource.getName(), e);
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
    }

    public void save() throws IOException {
        DataLoader.saveData(Paths.get("callgraph.dat", new String[0]), new GraphCall.Factory(), this.discoveredCalls);
    }

    public static void main(String[] args) throws Exception {
        ClassLoader classLoader = Util.getWarClassLoader(Paths.get(args[0], new String[0]));
        CallGraphDiscovery callGraphDiscovery = new CallGraphDiscovery();
        callGraphDiscovery.discover(new ClassResourceEnumerator(classLoader), new JavaDeserializationConfig());
        callGraphDiscovery.save();
    }

    private class ModelGeneratorClassVisitor
    extends ClassVisitor {
        private final Map<ClassReference.Handle, ClassReference> classMap;
        private final InheritanceMap inheritanceMap;
        private final Map<MethodReference.Handle, Set<Integer>> passthroughDataflow;
        private final SerializableDecider serializableDecider;
        private String name;
        private String signature;
        private String superName;
        private String[] interfaces;

        public ModelGeneratorClassVisitor(Map<ClassReference.Handle, ClassReference> classMap, InheritanceMap inheritanceMap, Map<MethodReference.Handle, Set<Integer>> passthroughDataflow, SerializableDecider serializableDecider, int api) {
            super(api);
            this.classMap = classMap;
            this.inheritanceMap = inheritanceMap;
            this.passthroughDataflow = passthroughDataflow;
            this.serializableDecider = serializableDecider;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.name = name;
            this.signature = signature;
            this.superName = superName;
            this.interfaces = interfaces;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            ModelGeneratorMethodVisitor modelGeneratorMethodVisitor = new ModelGeneratorMethodVisitor(this.classMap, this.inheritanceMap, this.passthroughDataflow, this.serializableDecider, this.api, mv, this.name, access, name, desc, signature, exceptions);
            return new JSRInlinerAdapter(modelGeneratorMethodVisitor, access, name, desc, signature, exceptions);
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
            super.visitOuterClass(owner, name, desc);
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            super.visitInnerClass(name, outerName, innerName, access);
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
        }
    }

    private class ModelGeneratorMethodVisitor
    extends TaintTrackingMethodVisitor<String> {
        private final Map<ClassReference.Handle, ClassReference> classMap;
        private final InheritanceMap inheritanceMap;
        private final SerializableDecider serializableDecider;
        private final String owner;
        private final int access;
        private final String name;
        private final String desc;

        public ModelGeneratorMethodVisitor(Map<ClassReference.Handle, ClassReference> classMap, InheritanceMap inheritanceMap, Map<MethodReference.Handle, Set<Integer>> passthroughDataflow, SerializableDecider serializableDecider, int api, MethodVisitor mv, String owner, int access, String name, String desc, String signature, String[] exceptions) {
            super(inheritanceMap, passthroughDataflow, api, mv, owner, access, name, desc, signature, exceptions);
            this.classMap = classMap;
            this.inheritanceMap = inheritanceMap;
            this.serializableDecider = serializableDecider;
            this.owner = owner;
            this.access = access;
            this.name = name;
            this.desc = desc;
        }

        @Override
        public void visitCode() {
            super.visitCode();
            int localIndex = 0;
            int argIndex = 0;
            if ((this.access & 8) == 0) {
                this.setLocalTaint(localIndex, "arg" + argIndex);
                ++localIndex;
                ++argIndex;
            }
            for (Type argType : Type.getArgumentTypes(this.desc)) {
                this.setLocalTaint(localIndex, "arg" + argIndex);
                localIndex += argType.getSize();
                ++argIndex;
            }
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            switch (opcode) {
                case 178: {
                    break;
                }
                case 179: {
                    break;
                }
                case 180: {
                    Type type = Type.getType(desc);
                    if (type.getSize() != 1) break;
                    Boolean isTransient = null;
                    if (!ModelGeneratorMethodVisitor.couldBeSerialized(this.serializableDecider, this.inheritanceMap, new ClassReference.Handle(type.getInternalName()))) {
                        isTransient = Boolean.TRUE;
                    } else {
                        ClassReference clazz = this.classMap.get(new ClassReference.Handle(owner));
                        while (clazz != null) {
                            for (ClassReference.Member member : clazz.getMembers()) {
                                if (!member.getName().equals(name)) continue;
                                isTransient = (member.getModifiers() & 0x80) != 0;
                                break;
                            }
                            if (isTransient != null) break;
                            clazz = this.classMap.get(new ClassReference.Handle(clazz.getSuperClass()));
                        }
                    }
                    HashSet<CallSite> newTaint = new HashSet<CallSite>();
                    if (!Boolean.TRUE.equals(isTransient)) {
                        for (String s2 : this.getStackTaint(0)) {
                            newTaint.add((CallSite)((Object)(s2 + "." + name)));
                        }
                    }
                    super.visitFieldInsn(opcode, owner, name, desc);
                    this.setStackTaint(0, newTaint);
                    return;
                }
                case 181: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported opcode: " + opcode);
                }
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            Type[] argTypes = Type.getArgumentTypes(desc);
            if (opcode != 184) {
                Type[] extendedArgTypes = new Type[argTypes.length + 1];
                System.arraycopy(argTypes, 0, extendedArgTypes, 1, argTypes.length);
                extendedArgTypes[0] = Type.getObjectType(owner);
                argTypes = extendedArgTypes;
            }
            switch (opcode) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    int stackIndex = 0;
                    for (int i = 0; i < argTypes.length; ++i) {
                        int argIndex = argTypes.length - 1 - i;
                        Type type = argTypes[argIndex];
                        Set taint = this.getStackTaint(stackIndex);
                        if (taint.size() > 0) {
                            for (String argSrc : taint) {
                                String srcArgPath;
                                int srcArgIndex;
                                if (!argSrc.substring(0, 3).equals("arg")) {
                                    throw new IllegalStateException("Invalid taint arg: " + argSrc);
                                }
                                int dotIndex = argSrc.indexOf(46);
                                if (dotIndex == -1) {
                                    srcArgIndex = Integer.parseInt(argSrc.substring(3));
                                    srcArgPath = null;
                                } else {
                                    srcArgIndex = Integer.parseInt(argSrc.substring(3, dotIndex));
                                    srcArgPath = argSrc.substring(dotIndex + 1);
                                }
                                CallGraphDiscovery.this.discoveredCalls.add(new GraphCall(new MethodReference.Handle(new ClassReference.Handle(this.owner), this.name, this.desc), new MethodReference.Handle(new ClassReference.Handle(owner), name, desc), srcArgIndex, srcArgPath, argIndex));
                            }
                        }
                        stackIndex += type.getSize();
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported opcode: " + opcode);
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }
}

