﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace FuzzTalk
{
    public static class TemplateParser
    {
        public static IEnumerable<string> FindTokens(string Template)
        {
            return new Regex(@"\$\$([\w\d_\-]+)")
                .Matches(Template)
                .Cast<Match>()
                .Select(x => x.Groups[1].Value)
                .Distinct();
        }

        public static string ReplaceTokens(string Template, object Data)
        {
            var cachedValues = new Dictionary<string, string>();

            var dataType = Data.GetType();

            var t = new StringBuilder(Template);

            foreach (string propName in FindTokens(Template))
            {
                string val;

                if (cachedValues.ContainsKey(propName))
                    val = cachedValues[propName];
                else
                {
                    var propInfo = dataType.GetProperty(propName);

                    val = propInfo != null ? propInfo.GetValue(Data, null) as string : "";

                    cachedValues.Add(propName, val);
                }

                t = t.Replace("$$" + propName, val);
            }

            return t.ToString();
        }

        public static string ReplaceTokens(string Template, Dictionary<string, string> Data)
        {
            var t = new StringBuilder(Template);

            foreach (string key in FindTokens(Template))
            {
                string val = Data.ContainsKey(key) ? Data[key] : "";

                t = t.Replace("$$" + key, val);
            }

            return t.ToString();
        }
    }
}
