/*
 * Decompiled with CFR 0.152.
 */
package felonycrowbar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class Key {
    private static List<Key> allKeys = new Vector<Key>();
    private String publicKey;
    private String privateKey;
    private File file;

    public static synchronized Key getKey(String pubKey, String privKey) {
        for (Key k : allKeys) {
            if (!k.publicKey.equals(pubKey) || !privKey.equals(privKey)) continue;
            return k;
        }
        Key key = new Key(pubKey, privKey);
        allKeys.add(key);
        return key;
    }

    public static synchronized void writeKeys(File parent, String project) {
        int i = 0;
        for (Key k : allKeys) {
            k.write(new File(parent, String.format("%s-%d", project, ++i)));
        }
    }

    public static synchronized void clearKeys() {
        allKeys.clear();
    }

    private Key(String pubKey, String privKey) {
        this.publicKey = pubKey;
        this.privateKey = privKey;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Key) {
            Key k = (Key)obj;
            return this.publicKey.equals(k.publicKey) && this.privateKey.equals(k.privateKey);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 73 * hash + (this.publicKey != null ? this.publicKey.hashCode() : 0);
        hash = 73 * hash + (this.privateKey != null ? this.privateKey.hashCode() : 0);
        return hash;
    }

    private void write(File output) {
        output.mkdirs();
        this.file = output;
        this.writeFile(new File(this.file, "public_key.bin"), this.publicKey);
        this.writeFile(new File(this.file, "private_key.bin"), this.privateKey);
    }

    public File getFile() {
        return this.file;
    }

    private void writeFile(File target, String key) {
        try {
            FileOutputStream fos = new FileOutputStream(target);
            while (key.length() > 0) {
                String pre = key.substring(0, 2);
                key = key.substring(2);
                fos.write(Integer.parseInt(pre, 16));
            }
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

