/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidComboBoxUI;
import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.skin.SkinSimpleButtonIndexModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class LiquidComboBoxButton
extends JButton {
    protected JComboBox comboBox;
    protected JList listBox;
    protected CellRendererPane rendererPane;
    protected Icon comboIcon;
    protected boolean iconOnly = false;
    BufferedImage focusImg;
    SkinSimpleButtonIndexModel indexModel = new SkinSimpleButtonIndexModel();
    Skin skinArrow;
    Skin skinButton;

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox cb) {
        this.comboBox = cb;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon i) {
        this.comboIcon = i;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean isIconOnly) {
        this.iconOnly = isIconOnly;
    }

    LiquidComboBoxButton() {
        super("");
        DefaultButtonModel model = new DefaultButtonModel(){

            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() ? true : armed);
            }
        };
        this.setModel(model);
        this.setOpaque(false);
        this.setBackground(UIManager.getColor("ComboBox.background"));
        this.setForeground(UIManager.getColor("ComboBox.foreground"));
        ImageIcon icon = LiquidLookAndFeel.loadIcon("comboboxfocus.png", this);
        this.focusImg = new BufferedImage(2, 2, 1);
        Graphics g3 = this.focusImg.getGraphics();
        icon.paintIcon(this, g3, 0, 0);
    }

    public LiquidComboBoxButton(JComboBox cb, Icon i, CellRendererPane pane, JList list) {
        this();
        this.comboBox = cb;
        this.comboIcon = i;
        this.rendererPane = pane;
        this.listBox = list;
        this.setEnabled(this.comboBox.isEnabled());
    }

    public LiquidComboBoxButton(JComboBox cb, Icon i, boolean onlyIcon, CellRendererPane pane, JList list) {
        this(cb, i, pane, list);
        this.iconOnly = onlyIcon;
    }

    public int getIndexForState() {
        return this.indexModel.getIndexForState(this.model.isEnabled(), this.model.isRollover(), this.model.isArmed() && this.model.isPressed() | this.model.isSelected());
    }

    public void paintComponent(Graphics g) {
        int width;
        boolean leftToRight = this.getComponentOrientation().isLeftToRight();
        int index = this.indexModel.getIndexForState(this.model.isEnabled(), this.model.isRollover(), this.model.isArmed() && this.model.isPressed() | this.model.isSelected());
        index = this.comboBox.hasFocus() && !this.iconOnly ? 1 : index;
        Skin arrowSkin = this.getSkinArrow();
        int middle = (this.getHeight() - arrowSkin.getVsize()) / 2;
        arrowSkin.draw(g, index, this.getWidth() - arrowSkin.getHsize() - 6, middle, arrowSkin.getHsize(), arrowSkin.getVsize());
        Insets insets = new Insets(0, 12, 2, 2);
        int widthFocus = width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        if (height <= 0 || width <= 0) {
            return;
        }
        int left = insets.left;
        int top = insets.top;
        int right = left + (width - 1);
        int bottom = top + (height - 1);
        int iconWidth = LiquidComboBoxUI.comboBoxButtonSize;
        int iconLeft = leftToRight ? right : left;
        Component c = null;
        boolean mustResetOpaque = false;
        boolean savedOpaque = false;
        boolean paintFocus = this.comboBox.hasFocus();
        if (!this.iconOnly && this.comboBox != null) {
            ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
            boolean renderPressed = this.getModel().isPressed();
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, renderPressed, false);
            c.setFont(this.rendererPane.getFont());
            if (this.model.isArmed() && this.model.isPressed()) {
                if (this.isOpaque()) {
                    c.setBackground(UIManager.getColor("Button.select"));
                }
                c.setForeground(this.comboBox.getForeground());
            } else if (!this.comboBox.isEnabled()) {
                if (this.isOpaque()) {
                    c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                }
                c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            } else {
                c.setForeground(this.comboBox.getForeground());
                c.setBackground(this.comboBox.getBackground());
            }
            if (!mustResetOpaque && c instanceof JComponent) {
                mustResetOpaque = true;
                JComponent jc = (JComponent)c;
                savedOpaque = jc.isOpaque();
                jc.setOpaque(false);
            }
            int cWidth = width - (insets.right + iconWidth);
            boolean shouldValidate = false;
            if (c instanceof JPanel) {
                shouldValidate = true;
            }
            if (leftToRight) {
                this.rendererPane.paintComponent(g, c, this, left, top, cWidth, height, shouldValidate);
            } else {
                this.rendererPane.paintComponent(g, c, this, left + iconWidth, top, cWidth, height, shouldValidate);
            }
            if (paintFocus) {
                Graphics2D g2d = (Graphics2D)g;
                Rectangle bounds = this.comboBox.getBounds();
                int offset = bounds.height / 2 - 6;
                g.setColor(new Color(196, 195, 194));
                g2d.drawLine(6, offset, 11, offset + 5);
                g.setColor(new Color(175, 174, 174));
                g2d.drawLine(6, offset + 1, 6, offset + 11);
                g2d.drawLine(6, offset + 11, 11, offset + 6);
            }
        }
        if (mustResetOpaque) {
            JComponent jc = (JComponent)c;
            jc.setOpaque(savedOpaque);
        }
    }

    public Skin getSkinArrow() {
        if (this.skinArrow == null) {
            this.skinArrow = new Skin("comboboxarrow.png", 4, 0);
        }
        return this.skinArrow;
    }
}

