/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.mirror;

import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.plugin.mirror.DirectoryStatus;
import ddb.dsz.plugin.mirror.FileInformation;
import ddb.dsz.plugin.mirror.Mirror;
import ddb.dsz.plugin.mirror.jaxb.mirrorcomms.MirrorRequest;
import ddb.dsz.plugin.mirror.jaxb.mirrorcomms.MirrorTransfer;
import ddb.dsz.plugin.mirror.jaxb.mirrorcomms.ObjectFactory;
import ddb.dsz.plugin.peer.PeerTag;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.zip.InflaterInputStream;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;

@DszLive(live=false, replay=true)
@DszLogo(value="images/config-users.png")
@DszName(value="Reflection")
@DszDescription(value="Mirrors the connected Peer's logs")
public class ReplayMirror
extends Mirror {
    PeerTag tag = null;
    JLabel received = new JLabel("0");
    JLabel sent = new JLabel("0");
    ScheduledFuture<?> monitor = null;
    ObjectFactory objFact = new ObjectFactory();
    JCheckBox sendData = new JCheckBox("Retrieve Data", false);
    boolean connected = false;
    File lock;
    Map<String, FileInformation> transferedSize = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

        public Object transform(Object object) {
            FileInformation fileInformation = null;
            if (object instanceof String) {
                String string = (String)String.class.cast(object);
                fileInformation = new FileInformation();
                fileInformation.setName(string);
                fileInformation.setSize(0L);
                fileInformation.setSoFar(0L);
                ReplayMirror.this.model.addRecord(fileInformation);
            }
            return fileInformation;
        }
    });
    Runnable RequestData = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                DirectoryStatus directoryStatus = new DirectoryStatus(ReplayMirror.this.core, ReplayMirror.this.model);
                directoryStatus.run();
            }
            catch (JAXBException jAXBException) {
                ReplayMirror.this.core.logEvent(Level.WARNING, jAXBException.getMessage(), (Throwable)jAXBException);
            }
            finally {
                try {
                    ReplayMirror.this.core.sendMessageToPeer(ReplayMirror.this.marshall(ReplayMirror.this.objFact.createMirrorRequest(new MirrorRequest())), ReplayMirror.this.tag);
                }
                catch (JAXBException jAXBException) {
                    ReplayMirror.this.core.logEvent(Level.WARNING, jAXBException.getMessage(), (Throwable)jAXBException);
                }
            }
        }
    };

    protected int init3() {
        this.mainPanel.add((Component)this.sendData, "North");
        this.lock = new File(this.core.getLogDirectory(), ".replay");
        try {
            this.lock.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.lock.deleteOnExit();
        this.sendData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ReplayMirror.this.connected && ReplayMirror.this.sendData.isSelected()) {
                    ReplayMirror.this.sendData.setEnabled(false);
                    ReplayMirror.this.core.submit(ReplayMirror.this.RequestData);
                }
            }
        });
        return 0;
    }

    public void receivedMessage(String string, PeerTag peerTag) {
        super.receivedMessage(string, peerTag);
        Object object = this.unmarshal(string);
        if (object instanceof JAXBElement) {
            object = ((JAXBElement)JAXBElement.class.cast(object)).getValue();
        }
        if (object instanceof MirrorTransfer) {
            MirrorTransfer mirrorTransfer = (MirrorTransfer)object;
            this.handleTransfer(mirrorTransfer.getFile(), mirrorTransfer.getOffset(), mirrorTransfer.getLength(), mirrorTransfer.getData());
        }
    }

    public void newConnection(PeerTag peerTag) {
        this.tag = peerTag;
        this.connected = true;
        if (this.sendData.isSelected()) {
            this.sendData.setEnabled(false);
            this.core.submit(this.RequestData);
        }
    }

    public void handleTransfer(String string, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        FileInformation fileInformation = this.transferedSize.get(string);
        File file = new File(String.format("%s/%s", this.core.getLogDirectory(), string));
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        long l = 0L;
        if (file.getParentFile().exists()) {
            try {
                int n;
                long l2;
                if (file.exists()) {
                    long l3 = file.length();
                    long l4 = bigInteger.longValue();
                    l2 = bigInteger2.longValue();
                    if (l3 < l4) {
                        return;
                    }
                    if (l3 > l4) {
                        if (l4 + l2 < l3) {
                            fileInformation.setSize(l4 + l2);
                            fileInformation.setSoFar(fileInformation.getSize());
                            this.model.updateRecord(fileInformation);
                            return;
                        }
                        long l5 = l4 + l2 - l3;
                        bigInteger = BigInteger.valueOf(l3);
                        bigInteger2 = BigInteger.valueOf(l5);
                        l = l2 - l5;
                    }
                    if (file.length() != bigInteger.longValue()) {
                        return;
                    }
                }
                fileInformation.setSize(bigInteger.longValue() + bigInteger2.longValue());
                fileInformation.setSoFar(fileInformation.getSize());
                FileOutputStream fileOutputStream = null;
                for (int i = 0; i < 100; ++i) {
                    try {
                        fileOutputStream = new FileOutputStream(file, true);
                        break;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.out.println(i);
                        TimeUnit.MILLISECONDS.sleep(250L);
                        continue;
                    }
                }
                if (fileOutputStream == null) {
                    return;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
                byte[] byArray2 = new byte[1024];
                for (l2 = 0L; l2 < bigInteger2.longValue(); l2 += (long)n) {
                    n = inflaterInputStream.read(byArray2);
                    if (l > 0L) {
                        if (l > (long)n) {
                            l -= (long)n;
                            continue;
                        }
                        long l6 = (long)n - l;
                        fileOutputStream.write(byArray2, Long.valueOf(l).intValue(), Long.valueOf(l6).intValue());
                        l = 0L;
                        continue;
                    }
                    fileOutputStream.write(byArray2, 0, n);
                }
                fileOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.model.updateRecord(fileInformation);
        super.requestNext(this.tag);
    }
}

