/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.mirror;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.mirror.DirectoryScanner;
import ddb.dsz.plugin.mirror.FileInformation;
import ddb.dsz.plugin.mirror.StoppableRunnable;
import ddb.dsz.plugin.mirror.TransferredFilesModel;
import ddb.dsz.plugin.mirror.jaxb.mirrorcomms.MirrorTransfer;
import ddb.dsz.plugin.mirror.jaxb.mirrorcomms.ObjectFactory;
import ddb.dsz.plugin.peer.PeerTag;
import ddb.dsz.plugin.peer.PeerTransferStatus;
import ddb.util.JaxbCache;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.zip.DeflaterOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;

public class MonitorThread
extends DirectoryScanner
implements StoppableRunnable {
    public static final int MAX_SIZE = 4096;
    public static final int SEND_THRESH = 16384;
    Map<String, Long> transferedSize = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

        public Object transform(Object object) {
            return 0L;
        }
    });
    Marshaller marsh;
    ObjectFactory of;
    TransferredFilesModel model;
    PeerTag tag;
    final Object resumeLock = new Object();

    public MonitorThread(CoreController coreController, TransferredFilesModel transferredFilesModel, PeerTag peerTag) throws JAXBException {
        super(coreController);
        this.model = transferredFilesModel;
        this.tag = peerTag;
        JAXBContext jAXBContext = JaxbCache.getContext(ObjectFactory.class);
        this.marsh = jAXBContext.createMarshaller();
        this.of = new ObjectFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.stop) {
            return;
        }
        try {
            Object object = this.resumeLock;
            synchronized (object) {
                while (!this.scanDirectory(this.core.getLogDirectory(), "")) {
                    TimeUnit.SECONDS.timedWait(this.resumeLock, 3L);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.core.schedule((Runnable)this, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.resumeLock;
        synchronized (object) {
            this.resumeLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleFile(String string, File file) {
        FileInformation fileInformation = this.model.getFileInformation(string);
        Long l = this.transferedSize.get(string);
        fileInformation.setName(string);
        fileInformation.setSize(file.length());
        boolean bl = true;
        for (int i = 0; file.length() > l && (bl || l + 512L < file.length()) && i < 10; ++i) {
            try {
                long l2;
                int n;
                long l3 = file.length() - l;
                FileInputStream fileInputStream = new FileInputStream(file);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
                fileInputStream.skip(l);
                byte[] byArray = new byte[4096];
                for (l2 = 0L; l3 > 0L && l2 < 98304L && (n = fileInputStream.read(byArray)) > 0; l3 -= (long)n, l2 += (long)n) {
                    deflaterOutputStream.write(byArray, 0, n);
                    deflaterOutputStream.flush();
                }
                deflaterOutputStream.finish();
                this.send(string, BigInteger.valueOf(l), BigInteger.valueOf(l2), byteArrayOutputStream.toByteArray());
                l = l + l2;
                this.transferedSize.put(string, l);
                FileInformation fileInformation2 = fileInformation;
                synchronized (fileInformation2) {
                    fileInformation.setSoFar(fileInformation.getSoFar() + l2);
                }
                this.model.updateRecord(fileInformation);
                bl = false;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private void send(String string, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        try {
            MirrorTransfer mirrorTransfer = new MirrorTransfer();
            mirrorTransfer.setData(byArray);
            mirrorTransfer.setFile(string);
            mirrorTransfer.setOffset(bigInteger);
            mirrorTransfer.setLength(bigInteger2);
            StringWriter stringWriter = new StringWriter();
            this.marsh.marshal(this.of.createMirrorTransfer(mirrorTransfer), (Writer)stringWriter);
            if (this.core.sendMessageToPeer(stringWriter.toString(), this.tag) != PeerTransferStatus.SENT) {
                this.stop();
            }
        }
        catch (Exception exception) {
            this.core.logEvent(Level.SEVERE, exception.getMessage(), (Throwable)exception);
            this.stop();
        }
    }

    public void addFile(String string, BigInteger bigInteger) {
        FileInformation fileInformation = this.model.getFileInformation(string);
        fileInformation.setSize(bigInteger.longValue());
        fileInformation.setSoFar(bigInteger.longValue());
        this.model.updateRecord(fileInformation);
        this.transferedSize.put(string, bigInteger.longValue());
    }
}

