/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.mirror;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.plugin.mirror.StoppableRunnable;
import java.io.File;
import java.io.FilenameFilter;

public abstract class DirectoryScanner
implements StoppableRunnable {
    public static final FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return !string.toLowerCase().endsWith(".db");
        }
    };
    public static final FilenameFilter REPLAY_LOCK = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.toLowerCase().equals(".replay");
        }
    };
    protected boolean stop = false;
    protected CoreController core;

    protected abstract boolean handleFile(String var1, File var2);

    public DirectoryScanner(CoreController coreController) {
        this.core = coreController;
    }

    public void stop() {
        this.stop = true;
    }

    private boolean shouldSkip(File file) {
        if (file.isFile() && file.getName().equals(".replay")) {
            return true;
        }
        if (file.isFile()) {
            return false;
        }
        if (file.getName().equals("Temp")) {
            return true;
        }
        File[] fileArray = file.listFiles(REPLAY_LOCK);
        return fileArray != null && fileArray.length > 0;
    }

    public boolean scanDirectory(String string, String string2) {
        File file = new File(String.format("%s/%s", string, string2));
        if (this.shouldSkip(file)) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        HostInfo hostInfo = this.core.getHostById("localhost");
        String[] stringArray = new String[]{hostInfo != null ? hostInfo.getId() : "__", "Tasking"};
        for (String string3 : stringArray) {
            if (this.scanDirectory(string, String.format("%s%s/", string2, string3))) continue;
            return false;
        }
        if (file == null) {
            return true;
        }
        Object[] objectArray = file.listFiles(filter);
        if (objectArray == null) {
            return true;
        }
        for (Object object : objectArray) {
            if (this.stop) {
                return false;
            }
            boolean bl = false;
            String string4 = String.format("%s%s", string2, ((File)object).getName());
            if (((File)object).isDirectory()) {
                bl = this.scanDirectory(string, string4 + "/");
            } else {
                if (!((File)object).canRead()) continue;
                bl = this.handleFile(string4, (File)object);
            }
            if (bl) continue;
            return false;
        }
        return true;
    }
}

