/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.transfermonitor.renderer;

import ddb.dsz.plugin.transfermonitor.model.TransferDirection;
import ddb.dsz.plugin.transfermonitor.model.TransferRecord;
import ddb.dsz.plugin.transfermonitor.model.TransferState;
import ddb.gui.swing.DszTableCellRenderer;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.math.BigInteger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ProgressCellRenderer
extends DszTableCellRenderer
implements TableCellRenderer {
    JProgressBar progress = new JProgressBar();

    public ProgressCellRenderer() {
        this.progress.setStringPainted(true);
        this.progress.putClientProperty("inverted", Boolean.TRUE);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JComponent jComponent = this.progress;
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object instanceof TransferRecord) {
            TransferRecord transferRecord = (TransferRecord)object;
            jLabel.setHorizontalAlignment(4);
            if (transferRecord.getState().equals((Object)TransferState.FAILURE)) {
                jLabel.setText(String.format("%s %,d Bytes", transferRecord.getDirection().getText(), transferRecord.getTransfered()));
                jComponent = jLabel;
            } else if (transferRecord.getSize() == 0L) {
                jLabel.setText(String.format("%,d of ??? Bytes", transferRecord.getTransfered()));
                jComponent = jLabel;
            }
            if (transferRecord.getSize().compareTo(transferRecord.getTransfered()) == 0) {
                jLabel.setText(String.format("%s %,d Bytes", transferRecord.getDirection().getText(), transferRecord.getTransfered()));
                jComponent = jLabel;
            } else if (transferRecord.getSize().compareTo(transferRecord.getTransfered()) < 0 || transferRecord.getSize() < 0L || transferRecord.getTransfered() < 0L) {
                jLabel.setText(String.format("%s %,d of %,d Bytes", transferRecord.getDirection().getText(), transferRecord.getTransfered(), transferRecord.getSize()));
                jComponent = jLabel;
            } else {
                this.progress.setMaximum(transferRecord.getSize().intValue());
                this.progress.setString(String.format("%s %,d of %,d Bytes", transferRecord.getDirection().getText(), transferRecord.getTransfered(), transferRecord.getSize()));
                if (transferRecord.getDirection() == TransferDirection.GET) {
                    this.progress.setValue(transferRecord.getTransfered().intValue());
                } else {
                    this.progress.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                    this.progress.setValue(transferRecord.getSize().intValue() - transferRecord.getTransfered().intValue());
                }
            }
        } else {
            this.progress.setIndeterminate(true);
        }
        return jComponent;
    }

    private String stringify(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.ZERO) == 0) {
            return "0";
        }
        String string = "";
        while (bigInteger.compareTo(BigInteger.ZERO) > 0) {
            BigInteger bigInteger2 = bigInteger.mod(BigInteger.valueOf(1000L));
            if (string.length() > 0) {
                string = "," + string;
            }
            String string2 = "";
            if (bigInteger.compareTo(BigInteger.valueOf(1000L)) >= 0) {
                if (bigInteger2.compareTo(BigInteger.valueOf(100L)) < 0) {
                    string2 = string2 + "0";
                }
                if (bigInteger2.compareTo(BigInteger.valueOf(10L)) < 0) {
                    string2 = string2 + "0";
                }
            }
            string = bigInteger2 + string;
            if (bigInteger.compareTo(BigInteger.ZERO) > 0) {
                string = string2 + string;
            }
            bigInteger = bigInteger.divide(BigInteger.valueOf(1000L));
        }
        return string;
    }
}

