/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.transfermonitor.model;

import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.transfermonitor.model.TransferDirection;
import ddb.dsz.plugin.transfermonitor.model.TransferState;
import java.util.Calendar;

public class TransferRecord {
    private String description = "";
    private int id = -1;
    private String local = "";
    private String subDir = null;
    private String remote = "";
    private Long size = 0L;
    private TransferState state = TransferState.STARTED;
    private Long transfered = 0L;
    private Calendar modified;
    private Calendar accessed;
    private Calendar created;
    private TransferDirection direction = TransferDirection.GET;
    int type = -1;
    boolean resumable = true;
    TaskId taskId;

    public TransferRecord(int n, TransferState transferState, String string, String string2, int n2, String string3, TaskId taskId) {
        this.id = n;
        this.state = transferState;
        this.remote = string;
        this.local = string2;
        this.type = n2;
        this.subDir = string3;
        this.taskId = taskId;
    }

    public TransferRecord(int n, TransferState transferState, String string, String string2, String string3, TaskId taskId) {
        this.id = n;
        this.state = transferState;
        this.remote = string;
        this.local = string2;
        this.subDir = string3;
        this.taskId = taskId;
    }

    public TransferRecord(int n, String string, String string2, TaskId taskId) {
        this.id = n;
        this.remote = string;
        this.subDir = string2;
        this.taskId = taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransfered(Long l) {
        if (l == null) {
            System.err.println("Attempting to add a null");
            return;
        }
        TransferRecord transferRecord = this;
        synchronized (transferRecord) {
            this.transfered = this.transfered + l;
        }
    }

    public TransferDirection getDirection() {
        return this.direction;
    }

    public void setDirection(TransferDirection transferDirection) {
        this.direction = transferDirection;
    }

    public String getDescription() {
        return this.description;
    }

    public int getId() {
        return this.id;
    }

    public String getLocal() {
        return this.local;
    }

    public String getSubDir() {
        return this.subDir;
    }

    public String getRemote() {
        return this.remote;
    }

    public Long getSize() {
        return this.size;
    }

    public TransferState getState() {
        switch (this.state) {
            case STARTED: {
                if (TransferDirection.PUT.equals((Object)this.direction) && this.size.compareTo(this.transfered) == 0) {
                    return TransferState.SUCCESS;
                }
                return TransferState.STARTED;
            }
            case DONE: {
                if (this.size.longValue() == this.transfered.longValue()) {
                    return TransferState.SUCCESS;
                }
                return TransferState.FAILURE;
            }
        }
        return this.state;
    }

    public Long getTransfered() {
        return this.transfered;
    }

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTransfered() {
        TransferRecord transferRecord = this;
        synchronized (transferRecord) {
            this.transfered = 0L;
        }
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setId(int n) {
        this.id = n;
    }

    public void setLocal(String string) {
        this.local = string;
    }

    public void setSubDir(String string) {
        this.subDir = string;
    }

    public void setRemote(String string) {
        this.remote = string;
    }

    public void setSize(Long l) {
        this.size = l;
    }

    public void setState(TransferState transferState) {
        this.state = transferState;
    }

    public void setTransfered(Long l) {
        this.transfered = l;
    }

    public void setType(int n) {
        this.type = n;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public boolean isResumable() {
        return this.resumable && !this.state.equals((Object)TransferState.STARTED) && this.transfered != this.size;
    }

    public void setResumable(boolean bl) {
        this.resumable = bl;
    }

    public Calendar getAccessed() {
        return this.accessed;
    }

    public void setAccessed(Calendar calendar) {
        this.accessed = calendar;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public void setCreated(Calendar calendar) {
        this.created = calendar;
    }

    public Calendar getModified() {
        return this.modified;
    }

    public void setModified(Calendar calendar) {
        this.modified = calendar;
    }
}

