/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.transfermonitor.listeners;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.transfermonitor.TransferMonitorHost;
import ddb.dsz.plugin.transfermonitor.model.TransferDirection;
import ddb.dsz.plugin.transfermonitor.model.TransferRecord;
import ddb.dsz.plugin.transfermonitor.model.TransferState;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.Closure;

public class PutClosure
implements Closure {
    Map<TaskId, TransferRecord> putFile = new HashMap<TaskId, TransferRecord>();
    TransferMonitorHost monitor;
    CoreController core;

    public PutClosure(TransferMonitorHost transferMonitorHost, CoreController coreController) {
        this.monitor = transferMonitorHost;
        this.core = coreController;
    }

    public void execute(Object object) {
        TransferRecord transferRecord;
        if (!(object instanceof DataEvent)) {
            return;
        }
        DataEvent dataEvent = (DataEvent)object;
        Task task = this.core.getTaskById(dataEvent.getTaskId());
        if (task == null) {
            return;
        }
        if (!task.getHost().equals(this.monitor.getTarget())) {
            return;
        }
        TaskId taskId = dataEvent.getTaskId();
        for (ObjectValue objectValue : dataEvent.getData().getObjects("localfile")) {
            transferRecord = this.putFile.get(taskId);
            if (transferRecord == null) {
                transferRecord = new TransferRecord(this.monitor.getNext(), "", "", taskId);
                this.putFile.put(taskId, transferRecord);
            }
            transferRecord.setResumable(false);
            transferRecord.setLocal(objectValue.getString("name"));
            transferRecord.setDirection(TransferDirection.PUT);
            this.monitor.addRecord(transferRecord);
            if (transferRecord.getRemote() != null) continue;
            transferRecord.setRemote(new File(transferRecord.getLocal()).getName());
        }
        for (ObjectValue objectValue : dataEvent.getData().getObjects("file")) {
            transferRecord = this.putFile.get(taskId);
            if (transferRecord == null) {
                transferRecord = new TransferRecord(this.monitor.getNext(), "", "", taskId);
                transferRecord.setDirection(TransferDirection.PUT);
                this.putFile.put(dataEvent.getTaskId(), transferRecord);
            }
            Long l = objectValue.getInteger("byteswritten");
            Long l2 = objectValue.getInteger("bytesremaining");
            if (l != null && l2 != null) {
                if (transferRecord.getSize() == 0L) {
                    transferRecord.setSize(l2 + l);
                }
                transferRecord.addTransfered(l);
                if (l2 == 0L) {
                    transferRecord.setState(TransferState.DONE);
                }
            } else {
                transferRecord.setRemote(objectValue.getString("name"));
            }
            this.monitor.recordChanged(transferRecord);
        }
    }
}

