/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.transfermonitor.listeners;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.transfermonitor.TransferMonitorHost;
import ddb.dsz.plugin.transfermonitor.listeners.RetrieveClosureInterface;
import ddb.dsz.plugin.transfermonitor.listeners.closure.FileStartClosure;
import ddb.dsz.plugin.transfermonitor.listeners.closure.FileStopClosure;
import ddb.dsz.plugin.transfermonitor.listeners.closure.FileWriteClosure;
import ddb.dsz.plugin.transfermonitor.listeners.closure.LocalNameClosure;
import ddb.dsz.plugin.transfermonitor.listeners.closure.ObjectValueClosure;
import ddb.dsz.plugin.transfermonitor.model.TransferRecord;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.map.MultiKeyMap;

public class PapercutClosure
implements Closure,
RetrieveClosureInterface {
    TransferMonitorHost monitor;
    final Map<String, ObjectValueClosure> closureMap = new HashMap<String, ObjectValueClosure>();
    final Object pointerLock = new Object();
    MultiKeyMap pointerToRecords = new MultiKeyMap();
    Map<TaskId, String> storedPath = new HashMap<TaskId, String>();
    CoreController core;

    public PapercutClosure(TransferMonitorHost transferMonitorHost, CoreController coreController) {
        this.monitor = transferMonitorHost;
        this.core = coreController;
        this.closureMap.put("FileStart".toLowerCase(), new FileStartClosure(this));
        this.closureMap.put("FileLocalName".toLowerCase(), new LocalNameClosure(this));
        this.closureMap.put("FileWrite".toLowerCase(), new FileWriteClosure(this));
        this.closureMap.put("FileStop".toLowerCase(), new FileStopClosure(this));
    }

    public synchronized void execute(Object object) {
        if (object == null || !(object instanceof DataEvent)) {
            return;
        }
        DataEvent dataEvent = (DataEvent)object;
        if (!dataEvent.getDataType().equals((Object)DataEvent.DataEventType.DATA)) {
            return;
        }
        Task task = this.core.getTaskById(dataEvent.getTaskId());
        if (task == null) {
            return;
        }
        if (!task.getHost().equals(this.monitor.getTarget())) {
            return;
        }
        for (String string : dataEvent.getData().getObjectNames()) {
            ObjectValueClosure objectValueClosure = this.closureMap.get(string.toLowerCase());
            if (objectValueClosure == null) continue;
            for (ObjectValue objectValue : dataEvent.getData().getObjects(string)) {
                objectValueClosure.execute(objectValue, this.core.getTaskById(dataEvent.getTaskId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferRecord getRecord(TaskId taskId, String string, boolean bl, boolean bl2) {
        TransferRecord transferRecord;
        Object object = this.pointerLock;
        synchronized (object) {
            transferRecord = (TransferRecord)TransferRecord.class.cast(this.pointerToRecords.get((Object)taskId, (Object)string));
            if (transferRecord == null && bl) {
                transferRecord = new TransferRecord(this.monitor.getNext(), "", null, taskId);
                this.pointerToRecords.put((Object)taskId, (Object)string, (Object)transferRecord);
                this.monitor.addRecord(transferRecord);
            }
        }
        return transferRecord;
    }

    public void recordChanged(TransferRecord transferRecord) {
        this.monitor.recordChanged(transferRecord);
    }

    public boolean isResumable() {
        return false;
    }
}

