/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.taskmanager.models;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.taskmanager.enumerated.FileStatus;
import ddb.dsz.plugin.taskmanager.enumerated.HandlesStatus;
import ddb.dsz.plugin.taskmanager.enumerated.ProcessInfoStatus;
import ddb.dsz.plugin.taskmanager.models.ProcessTableColumns;
import ddb.dsz.plugin.taskmanager.processinformation.ProcessInformation;
import ddb.util.AbstractEnumeratedTableModel;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessTableModel
extends AbstractEnumeratedTableModel<ProcessTableColumns> {
    List<ProcessInformation> processes = new Vector<ProcessInformation>(40);
    int updateNumber = 0;
    CoreController core;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    Lock read = this.lock.readLock();
    Lock write = this.lock.writeLock();

    public ProcessTableModel(CoreController cc) {
        super(ProcessTableColumns.class);
        this.core = cc;
    }

    public Class<?> getColumnClass(ProcessTableColumns column) {
        return column.getClazz();
    }

    public String getColumnName(ProcessTableColumns column) {
        return column.getColumnName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        this.read.lock();
        try {
            int n = this.processes.size();
            return n;
        }
        finally {
            this.read.unlock();
        }
    }

    public int getColumnCount() {
        return ProcessTableColumns.values().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessInformation getProcessAtRow(int row) {
        this.read.lock();
        try {
            if (row >= 0 && row < this.processes.size()) {
                ProcessInformation processInformation = this.processes.get(row);
                return processInformation;
            }
            ProcessInformation processInformation = null;
            return processInformation;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int row, ProcessTableColumns column) {
        ProcessInformation p = null;
        this.read.lock();
        try {
            if (row >= 0 && row < this.processes.size()) {
                p = this.processes.get(row);
            }
        }
        finally {
            this.read.unlock();
        }
        if (p == null) {
            return null;
        }
        switch (column) {
            case PROCESSID: {
                return p.getId();
            }
            case PROCESSNAME: {
                return p.getProcName();
            }
            case PROCESSPATH: {
                return p.getProcPath();
            }
            case USERNAME: {
                return p.getUserName();
            }
            case CPUTIME: {
                int time = p.getCpuTime().intValue();
                int seconds = time % 60;
                int minutes = (time /= 60) % 60;
                int hours = (time /= 60) % 24;
                int days = time /= 24;
                if (days > 0) {
                    return String.format("%d.%02d:%02d:%02d", days, hours, minutes, seconds);
                }
                return String.format("%02d:%02d:%02d", hours, minutes, seconds);
            }
            case ARCH_TYPE: {
                if (p.is64Bit()) {
                    return "64-Bit";
                }
                return "";
            }
            case CREATIONTIME: {
                if (p.getCreateTime() == null) {
                    return "--";
                }
                return String.format("%04d-%02d-%02d %02d:%02d:%02d", p.getCreateTime().get(1), p.getCreateTime().get(3), p.getCreateTime().get(5), p.getCreateTime().get(11), p.getCreateTime().get(12), p.getCreateTime().get(13));
            }
            case DISPLAY: {
                return p.getDisplay();
            }
            case PARENTID: {
                return p.getParent();
            }
            case HIGHLIGHT: {
                return p.isHighlight();
            }
            case TYPE: {
                return p.getType();
            }
            case PROCESS: {
                return p;
            }
            case EXPLANATION: {
                return p.getComment();
            }
            case HANDLEINFO: {
                return p.hasHandleInfo() ? HandlesStatus.HasHandles : HandlesStatus.NoHandles;
            }
            case PROCESSINFO: {
                return p.hasProcessInfo() ? ProcessInfoStatus.HasProcessInfo : ProcessInfoStatus.NoProcessInfo;
            }
        }
        return "oops";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcess(final ProcessInformation p) {
        int index = -1;
        boolean inserted = false;
        this.write.lock();
        try {
            if (p.getId() == null) {
                System.out.println("Error!");
            }
            if ((index = this.processes.indexOf(p)) != -1) {
                this.processes.get(index).setAs(p);
            } else {
                p.addObserver(new Observer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void update(Observable o, Object arg) {
                        int newIndex;
                        ProcessTableModel.this.read.lock();
                        try {
                            newIndex = ProcessTableModel.this.processes.indexOf(p);
                            if (newIndex == -1) {
                                return;
                            }
                        }
                        finally {
                            ProcessTableModel.this.read.unlock();
                        }
                        ProcessTableModel.this.fireTableRowsUpdated(newIndex, newIndex);
                    }
                });
                index = this.processes.size();
                this.processes.add(p);
                inserted = true;
            }
        }
        finally {
            this.write.unlock();
        }
        if (inserted) {
            this.fireTableRowsInserted(index, index);
        } else {
            this.fireTableRowsUpdated(index, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcess(ProcessInformation p) {
        int index = -1;
        this.write.lock();
        try {
            index = this.processes.indexOf(p);
            if (index == -1) {
                return;
            }
            this.processes.remove(index);
        }
        finally {
            this.write.unlock();
        }
        this.fireTableRowsDeleted(index, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProcess(ProcessInformation p) {
        int index = -1;
        this.write.lock();
        try {
            index = this.processes.indexOf(p);
            if (index == -1) {
                return;
            }
        }
        finally {
            this.write.unlock();
        }
        this.fireTableRowsUpdated(index, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        int size;
        this.write.lock();
        try {
            size = this.processes.size() - 1;
            this.processes.clear();
        }
        finally {
            this.write.unlock();
        }
        if (size >= 0) {
            this.fireTableRowsDeleted(0, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessInformation getProcessById(Long integerValue) {
        if (integerValue == null) {
            return null;
        }
        this.read.lock();
        try {
            for (ProcessInformation p : this.processes) {
                if (!p.getId().equals(integerValue)) continue;
                ProcessInformation processInformation = p;
                return processInformation;
            }
            ProcessInformation processInformation = null;
            return processInformation;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus getType(int row) {
        this.read.lock();
        try {
            FileStatus fileStatus = this.processes.get(row).getType();
            return fileStatus;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProcessInformation> getProcessesWithModule(String file) {
        Vector<ProcessInformation> retVal = new Vector<ProcessInformation>();
        this.read.lock();
        try {
            for (ProcessInformation p : this.processes) {
                if (!p.hasModuleNamed(file)) continue;
                retVal.add(p);
            }
        }
        finally {
            this.read.unlock();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProcessInformation> getAllProcesses() {
        Vector<ProcessInformation> retVal = new Vector<ProcessInformation>();
        this.read.lock();
        try {
            retVal.addAll(this.processes);
        }
        finally {
            this.read.unlock();
        }
        return retVal;
    }
}

