/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.taskmanager;

import ddb.detach.Tabbable;
import ddb.detach.TabbableOption;
import ddb.detach.TabbableStatus;
import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.plugin.multitarget.MultipleTargetPlugin;
import ddb.dsz.plugin.multitarget.MultipleTargetWorkbench;
import ddb.dsz.plugin.multitarget.SingleTargetInterface;
import ddb.dsz.plugin.taskmanager.TargetProcessSpace;
import ddb.dsz.plugin.taskmanager.TaskManagerOptions;
import ddb.dsz.plugin.taskmanager.TaskManagerWorkBench;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JComponent;

@DszLive(live=true, replay=true)
@DszLogo(value="images/taskmanager.png")
@DszName(value="Processes")
@DszDescription(value="Displays the current state of the target's processes")
public class TaskManager2
extends MultipleTargetPlugin {
    public static final int HIGHLIGHT_TIME = 60;
    static List<String> interestingCommands = new Vector<String>();
    static TaskManagerOptions optionPane;

    public TaskManager2() {
        super.setName("Processes");
        super.setShowButtons(false);
    }

    public int init3() {
        optionPane.init(this.core);
        this.core.logEvent(Level.FINE, "Initializing TaskManager2");
        this.tabWorkbench.setTabPlacement(2);
        super.setDisplay((JComponent)this.tabWorkbench);
        return 0;
    }

    protected void fini3() {
        for (Tabbable tab : this.tabWorkbench.getTabs()) {
            if (!(tab instanceof TargetProcessSpace)) continue;
            TargetProcessSpace tps = (TargetProcessSpace)tab;
            tps.fini();
        }
    }

    protected MultipleTargetWorkbench generateWorkbench() {
        return new TaskManagerWorkBench(this);
    }

    protected SingleTargetInterface newHost(HostInfo host) {
        return new TargetProcessSpace(host, this.core, this);
    }

    public TabbableStatus getStatus() {
        return this.tabWorkbench.getStatus();
    }

    protected MultipleTargetPlugin.LocalHostState getLocalHostState() {
        return MultipleTargetPlugin.LocalHostState.IGNORE;
    }

    public String newItemName() {
        return "New Processes";
    }

    public TabbableOption getStaticOptions() {
        return optionPane;
    }

    public static void main(String[] args) throws Throwable {
        Class<?> live = Class.forName("ds.plugin.live.DSClientApp");
        Class<?> replay = Class.forName("ds.plugin.replay.OpReplayDriver");
        Method m = live.getMethod("main", args.getClass());
        m.invoke(null, new Object[]{args});
    }

    static {
        interestingCommands.add("processes");
        interestingCommands.add("processinfo");
        optionPane = new TaskManagerOptions();
    }
}

