/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.taskmanager;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.contextmenu.CommandCallbackListener;
import ddb.dsz.core.contextmenu.ContextMenuAction;
import ddb.dsz.core.contextmenu.ContextMenuFactory;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.ClosureFactory;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.DataTransformer;
import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.multitarget.MultipleTargetPlugin;
import ddb.dsz.plugin.multitarget.SingleTargetImpl;
import ddb.dsz.plugin.taskmanager.ProcessAnalyzer;
import ddb.dsz.plugin.taskmanager.ProcessDetailsPopup;
import ddb.dsz.plugin.taskmanager.TaskManager2;
import ddb.dsz.plugin.taskmanager.details.ProcessDetails;
import ddb.dsz.plugin.taskmanager.enumerated.FileStatus;
import ddb.dsz.plugin.taskmanager.enumerated.HandlesStatus;
import ddb.dsz.plugin.taskmanager.enumerated.ProcessInfoStatus;
import ddb.dsz.plugin.taskmanager.models.ProcessTableColumns;
import ddb.dsz.plugin.taskmanager.models.ProcessTableModel;
import ddb.dsz.plugin.taskmanager.processinformation.ProcessDatabase;
import ddb.dsz.plugin.taskmanager.processinformation.ProcessInformation;
import ddb.dsz.plugin.taskmanager.processinformation.generator.Generator;
import ddb.dsz.plugin.taskmanager.processinformation.generator.WindowsGenerator;
import ddb.dsz.plugin.taskmanager.renderers.FileStatusRenderer;
import ddb.dsz.plugin.taskmanager.renderers.HandleRenderer;
import ddb.dsz.plugin.taskmanager.renderers.HasProcessInformationRenderer;
import ddb.dsz.plugin.taskmanager.renderers.ProcessShadingRenderer;
import ddb.imagemanager.ImageManager;
import ddb.util.TableSorter;
import ddb.util.UtilityConstants;
import ddb.util.predicate.CheckBoxMatchPredicate;
import ddb.util.predicate.CheckBoxPredicate;
import ddb.util.predicate.MustMatchOnePredicate;
import ddb.util.tablefilter.FilteredTableModel;
import ddb.util.tablefilter.sample.ColumnHidingModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetProcessSpace
extends SingleTargetImpl
implements Observer {
    private static final Collection<String> INTERESTING_COMMANDS;
    public static final String HOST_NAME = "-host";
    public static final String INITIAL = "initial";
    public static final String STARTED = "started";
    public static final String STOPPED = "stopped";
    public static final String TASKMANAGER_ICON = "images/taskmanager.png";
    public static final String MENUENTRIES = "/TaskManager/ProcessContextMenu.xml";
    static final ScheduledExecutorService analyzer;
    static final ProcessAnalyzer procAnalyze;
    static final DataTransformer dataTranslator;
    private boolean stop = false;
    final MultipleTargetPlugin parent;
    JTable jtable;
    ProcessTableModel tableModel;
    ProcessDetails details;
    TableSorter sorter = new TableSorter();
    FilteredTableModel filteredModel;
    ColumnHidingModel columnHider = new ColumnHidingModel(ProcessTableColumns.class);
    private final ProcessDatabase database;
    private CheckBoxMatchPredicate highlightedPredicate = new CheckBoxMatchPredicate(false);
    private CheckBoxPredicate showSafePredicate = new CheckBoxPredicate(true);
    private CheckBoxPredicate showUnknownPredicate = new CheckBoxPredicate(true);
    private CheckBoxPredicate showSecurityPredicate = new CheckBoxPredicate(true);
    private CheckBoxPredicate showMaliciousPredicate = new CheckBoxPredicate(true);
    private CheckBoxPredicate showCorePredicate = new CheckBoxPredicate(true);
    Predicate typePredicate = PredicateUtils.anyPredicate((Predicate[])new Predicate[]{PredicateUtils.andPredicate((Predicate)this.showSafePredicate, (Predicate)new MustMatchOnePredicate(new Object[]{FileStatus.SAFE})), PredicateUtils.andPredicate((Predicate)this.showSecurityPredicate, (Predicate)new MustMatchOnePredicate(new Object[]{FileStatus.SECURITY_PRODUCT})), PredicateUtils.andPredicate((Predicate)this.showMaliciousPredicate, (Predicate)new MustMatchOnePredicate(new Object[]{FileStatus.MALICIOUS_SOFTWARE})), PredicateUtils.andPredicate((Predicate)this.showCorePredicate, (Predicate)new MustMatchOnePredicate(new Object[]{FileStatus.CORE_OS})), PredicateUtils.andPredicate((Predicate)this.showUnknownPredicate, (Predicate)new MustMatchOnePredicate(new Object[]{FileStatus.NONE}))});
    JComponent localDisplay = null;
    HostInfo host = null;

    public TargetProcessSpace(HostInfo target, CoreController cc, MultipleTargetPlugin parent) {
        super(target, cc);
        this.database = ProcessDatabase.GetInstance(cc);
        this.host = target;
        super.setName(target.getId());
        this.target = target;
        this.parent = parent;
        this.details = new ProcessDetails(cc);
        procAnalyze.setResourceDirectory(cc.getResourceDirectory());
        this.core.logEvent(Level.FINE, "Initializing TaskMonitor");
        JPanel mainFrame = new JPanel();
        JPanel filterAtTop = new JPanel();
        filterAtTop.add(this.makeCheckBox("New Only", false, new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TargetProcessSpace.this.filteredModel.filterChanged();
            }
        }, this.highlightedPredicate.getModel()));
        ActionListener typeFilterHasChanged = new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TargetProcessSpace.this.filteredModel.filterChanged();
            }
        };
        JSeparator sep = new JSeparator(1);
        sep.setPreferredSize(new Dimension(10, 1));
        filterAtTop.add(sep);
        filterAtTop.add(this.makeCheckBox("Safe", true, typeFilterHasChanged, this.showSafePredicate.getModel()));
        filterAtTop.add(this.makeCheckBox("Security Products", true, typeFilterHasChanged, this.showSecurityPredicate.getModel()));
        filterAtTop.add(this.makeCheckBox("Core OS", true, typeFilterHasChanged, this.showCorePredicate.getModel()));
        filterAtTop.add(this.makeCheckBox("Malicious", true, typeFilterHasChanged, this.showMaliciousPredicate.getModel()));
        filterAtTop.add(this.makeCheckBox("Unknown", true, typeFilterHasChanged, this.showUnknownPredicate.getModel()));
        final JSplitPane splitter = new JSplitPane(0);
        splitter.setOneTouchExpandable(true);
        splitter.setResizeWeight(0.9);
        splitter.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                splitter.setDividerLocation(splitter.getMaximumDividerLocation() * 2);
                splitter.setLastDividerLocation(splitter.getMaximumDividerLocation() * 5 / 10);
                splitter.removeComponentListener(this);
            }
        });
        mainFrame.setLayout(new BorderLayout());
        this.tableModel = new ProcessTableModel(cc);
        this.filteredModel = new FilteredTableModel((TableModel)((Object)this.tableModel));
        this.filteredModel.addFilter((Predicate)this.highlightedPredicate, new Enum[]{ProcessTableColumns.HIGHLIGHT});
        this.filteredModel.addFilter(this.typePredicate, new Enum[]{ProcessTableColumns.TYPE});
        this.sorter.setModel((TableModel)this.filteredModel);
        this.jtable = new JTable(){

            public String getToolTipText(MouseEvent event) {
                int row = event.getY() / TargetProcessSpace.this.jtable.getRowHeight();
                Object obj = TargetProcessSpace.this.jtable.getModel().getValueAt(row, ProcessTableColumns.EXPLANATION.ordinal());
                if (obj == null) {
                    return "";
                }
                return obj.toString();
            }
        };
        this.jtable.setColumnModel((TableColumnModel)this.columnHider);
        this.jtable.setModel((TableModel)this.sorter);
        this.sorter.addMouseListenerToHeaderInTable(this.jtable);
        this.columnHider.applyToTable(this.jtable);
        this.jtable.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new ProcessShadingRenderer(this.core, (TableModel)this.sorter, TaskManager2.optionPane)));
        this.jtable.setDefaultRenderer(Long.class, (TableCellRenderer)((Object)new ProcessShadingRenderer(this.core, (TableModel)this.sorter, TaskManager2.optionPane)));
        this.jtable.setDefaultRenderer(FileStatus.class, (TableCellRenderer)((Object)new FileStatusRenderer(this.core, (TableModel)this.sorter, TaskManager2.optionPane)));
        this.jtable.setDefaultRenderer(HandlesStatus.class, (TableCellRenderer)((Object)new HandleRenderer(this.core, (TableModel)this.sorter, TaskManager2.optionPane)));
        this.jtable.setDefaultRenderer(ProcessInfoStatus.class, (TableCellRenderer)((Object)new HasProcessInformationRenderer(this.core, (TableModel)this.sorter, TaskManager2.optionPane)));
        this.jtable.getSelectionModel().setSelectionMode(0);
        this.jtable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int row = TargetProcessSpace.this.jtable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                row = TargetProcessSpace.this.sorter.convertViewRowToModel(row);
                if ((row = TargetProcessSpace.this.filteredModel.translateViewLocationToModelRow(row, 0)) == -1) {
                    return;
                }
                ProcessInformation p = TargetProcessSpace.this.tableModel.getProcessAtRow(row);
                if (p == null) {
                    return;
                }
                if (TargetProcessSpace.this.details.setProcessInfo(p) && (p.hasProcessInfo() || p.hasHandleInfo())) {
                    if (splitter.getDividerLocation() >= splitter.getMaximumDividerLocation()) {
                        splitter.setDividerLocation(splitter.getLastDividerLocation());
                    }
                } else if (splitter.getDividerLocation() < splitter.getMaximumDividerLocation()) {
                    splitter.setLastDividerLocation(splitter.getDividerLocation());
                    splitter.setDividerLocation(splitter.getMaximumDividerLocation() * 2);
                }
            }
        });
        mainFrame.add((Component)new JScrollPane(this.jtable), "Center");
        mainFrame.add((Component)filterAtTop, "North");
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                switch (e.getType()) {
                    case -1: 
                    case 1: {
                        TargetProcessSpace.this.fireContentsChanged();
                    }
                }
            }
        });
        this.jtable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                this.popUp(e);
            }

            public void mousePressed(MouseEvent e) {
                this.popUp(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.popUp(e);
            }

            private void popUp(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int row = e.getY() / TargetProcessSpace.this.jtable.getRowHeight();
                    TargetProcessSpace.this.jtable.addRowSelectionInterval(row, row);
                    row = TargetProcessSpace.this.sorter.convertViewRowToModel(row);
                    int finalRow = row = TargetProcessSpace.this.filteredModel.translateViewLocationToModelRow(row, 0);
                    final ProcessInformation p = TargetProcessSpace.this.tableModel.getProcessAtRow(finalRow);
                    Hashtable<String, String> replacements = new Hashtable<String, String>();
                    replacements.put("id", p.getId().toString());
                    replacements.put("parent", p.getParent().toString());
                    replacements.put("user", p.getUserName());
                    replacements.put("name", p.getProcName());
                    JPopupMenu popup = ContextMenuFactory.createContextMenuString((String)TargetProcessSpace.MENUENTRIES, (CoreController)TargetProcessSpace.this.core, (CommandCallbackListener)new CommandCallbackListener(){

                        public void registerCommand(String string, TaskId id) {
                        }
                    }, (HostInfo)TargetProcessSpace.this.host, Collections.singleton(replacements), null, (ContextMenuAction)new ContextMenuAction(){

                        public void action(List<String> parameters) {
                            if (parameters == null || parameters.size() == 0) {
                                return;
                            }
                            if (parameters.get(0).equalsIgnoreCase("ProcessDetail")) {
                                new ProcessDetailsPopup(TargetProcessSpace.this.core, p).setVisible(true);
                            } else if (parameters.get(0).equalsIgnoreCase("GetComment")) {
                                String comment = JOptionPane.showInputDialog("Please enter a comment for this process:", (Object)"(None)");
                                if (comment != null) {
                                    Vector<String> dup = new Vector<String>(parameters.subList(1, parameters.size()));
                                    dup.add(String.format("comment=%s", comment));
                                    TargetProcessSpace.this.core.internalCommand(null, dup);
                                }
                            } else {
                                parameters.add(String.format("host=%s", TargetProcessSpace.this.target.getId()));
                                TargetProcessSpace.this.core.internalCommand(null, parameters);
                            }
                        }

                        public void action(List<String> parameters, Object extraContext) {
                            this.action(parameters);
                        }
                    });
                    if (popup.getSubElements().length > 0) {
                        popup.show(TargetProcessSpace.this.jtable, e.getX(), e.getY());
                    }
                }
            }
        });
        this.localDisplay = splitter;
        super.setDisplay(this.localDisplay);
        splitter.setTopComponent(mainFrame);
        splitter.setBottomComponent(this.details);
        this.setColumnWidth(ProcessTableColumns.TYPE, "", true, true);
        this.setColumnWidth(ProcessTableColumns.PROCESSINFO, "", true, true);
        this.setColumnWidth(ProcessTableColumns.HANDLEINFO, "", true, true);
        this.setColumnWidth(ProcessTableColumns.PROCESSID, "12345678", false, true);
        this.setColumnWidth(ProcessTableColumns.PARENTID, "12345678", false, true);
        this.setColumnWidth(ProcessTableColumns.CPUTIME, "10 days 00:00:00", false, true);
        this.setColumnWidth(ProcessTableColumns.DISPLAY, "1234", false, true);
        this.setColumnWidth(ProcessTableColumns.ARCH_TYPE, "64-Bit", true, true);
        for (ProcessTableColumns c : ProcessTableColumns.values()) {
            if (!c.isHidden()) continue;
            this.columnHider.hide((Enum)c);
        }
        if (dataTranslator != null) {
            final Predicate examineData = this.getDataPredicate();
            dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)this.core, (String)"processinfo", (String)"Dsz", (Closure)new Closure(){

                public void execute(Object arg0) {
                    if (!examineData.evaluate(arg0)) {
                        return;
                    }
                    DataEvent de = (DataEvent)arg0;
                    for (ObjectValue procInfo : de.getData().getObjects("processinfo")) {
                        ProcessInformation proc = TargetProcessSpace.this.tableModel.getProcessById(procInfo.getInteger("id"));
                        if (proc == null) continue;
                        proc.setProcessInformation(TargetProcessSpace.this.core.getTaskById(de.getTaskId()), procInfo);
                        procAnalyze.enqueProcess(proc);
                        TargetProcessSpace.this.tableModel.updateProcess(proc);
                    }
                }
            }));
            dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)this.core, (String)"processes", (String)"Dsz", (Closure)new Closure(){
                Set<TaskId> ignoreTask = new HashSet<TaskId>();

                public void execute(Object arg0) {
                    if (!examineData.evaluate(arg0)) {
                        return;
                    }
                    DataEvent dtde = (DataEvent)DataEvent.class.cast(arg0);
                    if (this.ignoreTask.contains(dtde.getTaskId())) {
                        return;
                    }
                    ObjectValue data = dtde.getData();
                    Boolean local = data.getBoolean("target::local");
                    if (local != null && !local.booleanValue()) {
                        this.ignoreTask.add(dtde.getTaskId());
                        return;
                    }
                    Vector<ProcessInformation> newFullList = new Vector<ProcessInformation>();
                    for (DszProcessGroup group : DszProcessGroup.values()) {
                        for (ObjectValue processItem : data.getObjects(group.data + "::processitem")) {
                            ProcessInformation proc = new ProcessInformation(processItem, TargetProcessSpace.this.core, TargetProcessSpace.this.host);
                            if (TargetProcessSpace.INITIAL.equalsIgnoreCase(group.status)) {
                                newFullList.add(proc);
                                continue;
                            }
                            if (TargetProcessSpace.STARTED.equalsIgnoreCase(group.status)) {
                                proc.SetHighlight();
                                TargetProcessSpace.this.tableModel.addProcess(proc);
                                procAnalyze.enqueProcess(proc);
                                continue;
                            }
                            if (!TargetProcessSpace.STOPPED.equalsIgnoreCase(group.status)) continue;
                            TargetProcessSpace.this.tableModel.removeProcess(proc);
                        }
                    }
                    if (newFullList.size() > 0) {
                        List<ProcessInformation> existingProcesses = TargetProcessSpace.this.tableModel.getAllProcesses();
                        boolean highlight = existingProcesses.size() > 0;
                        for (ProcessInformation pi : newFullList) {
                            boolean found = false;
                            for (ProcessInformation existing : existingProcesses) {
                                if (!existing.getId().equals(pi.getId())) continue;
                                existing.setAs(pi);
                                existingProcesses.remove(existing);
                                found = true;
                                break;
                            }
                            if (found) continue;
                            if (highlight) {
                                pi.SetHighlight();
                            }
                            procAnalyze.enqueProcess(pi);
                            TargetProcessSpace.this.tableModel.addProcess(pi);
                        }
                        for (ProcessInformation pi : existingProcesses) {
                            TargetProcessSpace.this.tableModel.removeProcess(pi);
                        }
                    }
                }
            }));
            dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)this.core, (String)"handles", (String)"Dsz", (Closure)new Closure(){

                public void execute(Object arg0) {
                    if (!examineData.evaluate(arg0)) {
                        return;
                    }
                    DataEvent de = (DataEvent)arg0;
                    for (ObjectValue procInfo : de.getData().getObjects("process")) {
                        ProcessInformation proc = TargetProcessSpace.this.tableModel.getProcessById(procInfo.getInteger("id"));
                        if (proc == null) continue;
                        WindowsGenerator g = new WindowsGenerator(TargetProcessSpace.this.core);
                        for (ObjectValue handle : procInfo.getObjects("handle")) {
                            proc.addHandle(((Generator)g).newHandle(handle));
                        }
                        TargetProcessSpace.this.tableModel.updateProcess(proc);
                    }
                }
            }));
        }
        analyzer.schedule(new Runnable(){

            public void run() {
                List<ProcessInformation> existingProcesses = TargetProcessSpace.this.tableModel.getAllProcesses();
                if (existingProcesses != null) {
                    for (ProcessInformation pi : existingProcesses) {
                        procAnalyze.enqueProcess(pi);
                    }
                }
                if (!TargetProcessSpace.this.stop) {
                    analyzer.schedule(this, 15L, TimeUnit.SECONDS);
                }
            }
        }, 15L, TimeUnit.SECONDS);
    }

    public void commandEventReceived(CommandEvent event) {
        Task t = this.core.getTaskById(event.getId());
        if (t == null) {
            return;
        }
        if (t.getCommandName() == null) {
            return;
        }
        if (INTERESTING_COMMANDS.contains(t.getCommandName().toLowerCase()) && dataTranslator != null) {
            dataTranslator.addTask(t);
        }
    }

    public JComponent getHeader() {
        return null;
    }

    JCheckBox makeCheckBox(String name, boolean checked, ActionListener listener, JToggleButton.ToggleButtonModel model) {
        JCheckBox check = new JCheckBox();
        check.setText(name);
        check.setSelected(checked);
        check.addActionListener(listener);
        check.setModel(model);
        return check;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == TaskManager2.optionPane.getObservable()) {
            this.jtable.repaint();
        }
    }

    private void setColumnWidth(Enum<?> col, String string, boolean icon, boolean binding) {
        TableColumn column = this.jtable.getColumnModel().getColumn(col.ordinal());
        JLabel label = new JLabel(string);
        if (icon) {
            label.setIcon(ImageManager.getIcon((String)TASKMANAGER_ICON, (Dimension)this.core.getLabelImageSize()));
        }
        column.setPreferredWidth(label.getPreferredSize().width + 10);
        if (binding) {
            column.setMaxWidth(label.getPreferredSize().width + 15);
            column.setMinWidth(label.getPreferredSize().width + 5);
        }
    }

    public void evaluateAll() {
        for (ProcessInformation pi : this.tableModel.getAllProcesses()) {
            procAnalyze.enqueProcess(pi);
        }
    }

    public String toString() {
        return String.format("Processes: %s", this.target.getId());
    }

    public void fini2() {
        this.stop = true;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("processes");
        set.add("processinfo");
        set.add("handles");
        INTERESTING_COMMANDS = Collections.unmodifiableSet(set);
        dataTranslator = DataTransformer.newInstance();
        analyzer = Executors.newSingleThreadScheduledExecutor(UtilityConstants.createThreadFactory((String)"TaskProcessSpace"));
        procAnalyze = new ProcessAnalyzer(analyzer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DszProcessGroup {
        INIT("initialprocesslistitem", "initial"),
        START("startprocesslistitem", "started"),
        STOP("stopprocesslistitem", "stopped");

        String data;
        String status;

        private DszProcessGroup(String dataName, String status) {
            this.data = dataName;
            this.status = status;
        }
    }
}

