/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.taskmanager;

import ddb.dsz.plugin.taskmanager.enumerated.FileStatus;
import ddb.dsz.plugin.taskmanager.processinformation.ProcessInformation;
import ddb.util.FileManips;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ProcessAnalyzer
implements Runnable {
    public static final String DATABASE_SCHEMA = "create Table ProcessInformation (\t\t\tName TEXT NOT NULL COLLATE NOCASE,\tComment TEXT,\tType TEXT,\tPRIMARY KEY (Name) ON CONFLICT IGNORE)";
    public static final String DATABASE = "Databases/SimpleProcesses.db";
    final Object databaseLock = new Object();
    Connection processConnection = null;
    boolean connected = false;
    Set<ProcessInformation> pendingEvaluation = new HashSet<ProcessInformation>();
    private String resourceDirectory = null;
    private String userDirectory = null;
    ScheduledExecutorService analyzer;
    PreparedStatement getProcess = null;

    public ProcessAnalyzer(ScheduledExecutorService analyzer) {
        this.analyzer = analyzer;
        this.analyzer.schedule(this, 5L, TimeUnit.SECONDS);
    }

    public synchronized void setResourceDirectory(String resDir) {
        if (this.resourceDirectory == null) {
            this.resourceDirectory = resDir;
        }
    }

    public synchronized void setUserDirectory(String userDir) {
        if (this.userDirectory == null) {
            this.userDirectory = userDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        HashSet<ProcessInformation> temp = new HashSet<ProcessInformation>();
        try {
            if (!this.openDatabase()) {
                return;
            }
            if (this.getProcess == null) {
                return;
            }
            Object object = this.databaseLock;
            synchronized (object) {
                temp.addAll(this.pendingEvaluation);
                this.pendingEvaluation.clear();
            }
            if (temp.size() == 0) {
                return;
            }
            for (ProcessInformation eval : temp) {
                try {
                    try {
                        ResultSet results;
                        this.getProcess.clearParameters();
                        this.getProcess.setString(1, eval.getProcName());
                        Object object2 = this.databaseLock;
                        synchronized (object2) {
                            results = this.getProcess.executeQuery();
                        }
                        try {
                            while (results.next()) {
                                eval.setComment(results.getString("comment"));
                                String tempStr = results.getString("type");
                                if (tempStr == null) continue;
                                eval.setType(FileStatus.valueOf(tempStr));
                            }
                        }
                        finally {
                            results.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        this.connected = false;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                    return;
                }
            }
        }
        finally {
            Object object = this.databaseLock;
            synchronized (object) {
                this.analyzer.schedule(this, 5L, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openDatabase() {
        Object object = this.databaseLock;
        synchronized (object) {
            if (this.connected) {
                return true;
            }
            if (this.resourceDirectory == null) {
                return false;
            }
            try {
                String src = "Dsz";
                String dest = "Ops";
                File databaseFile = new File(String.format("%s/%s/%s", this.resourceDirectory, dest, DATABASE));
                File databaseSrc = new File(String.format("%s/%s/%s", this.resourceDirectory, src, DATABASE));
                databaseFile.getParentFile().mkdirs();
                boolean create = false;
                if (!databaseFile.exists()) {
                    create = !databaseSrc.exists() ? true : !FileManips.CopyFile((File)databaseSrc, (File)databaseFile);
                }
                Class.forName("org.sqlite.JDBC");
                this.processConnection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", databaseFile.getAbsolutePath()));
                this.connected = true;
                if (create) {
                    this.processConnection.createStatement().execute(DATABASE_SCHEMA);
                }
                this.getProcess = this.processConnection.prepareStatement("Select * from ProcessInformation where name == ?");
                return true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueProcess(ProcessInformation pi) {
        Object object = this.databaseLock;
        synchronized (object) {
            this.pendingEvaluation.add(pi);
        }
    }
}

