/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.display;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.netmapviewer.Resource;
import ddb.util.AbstractEnumeratedTableModel;
import ddb.util.tablefilter.sample.ColumnHidingModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareDisplay
extends JPanel {
    ColumnHidingModel hider = new ColumnHidingModel(SharesColumns.class);
    private JScrollPane scroller;
    private JTable sharesTable;

    public ShareDisplay(CoreController coreController, List<Resource> list) {
        this.initComponents();
        this.sharesTable.setColumnModel((TableColumnModel)this.hider);
        SharesTableModel sharesTableModel = new SharesTableModel(list);
        this.sharesTable.setModel((TableModel)((Object)sharesTableModel));
        this.hider.applyToTable(this.sharesTable);
        this.sharesTable.setRowSorter(new TableRowSorter<SharesTableModel>(sharesTableModel));
    }

    private void initComponents() {
        this.scroller = new JScrollPane();
        this.sharesTable = new JTable();
        this.sharesTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.scroller.setViewportView(this.sharesTable);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.scroller, -1, 410, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.scroller, -1, 399, Short.MAX_VALUE));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SharesTableModel
    extends AbstractEnumeratedTableModel<SharesColumns> {
        List<Resource> shares;

        public SharesTableModel(List<Resource> list) {
            super(SharesColumns.class);
            this.shares = new ArrayList<Resource>();
            this.shares.addAll(list);
            Collections.sort(this.shares, new Comparator<Resource>(){

                @Override
                public int compare(Resource resource, Resource resource2) {
                    return resource.getName().compareTo(resource2.getName());
                }
            });
        }

        public Object getValueAt(int n, SharesColumns sharesColumns) {
            try {
                if (n < this.shares.size() && n >= 0) {
                    switch (sharesColumns) {
                        case Name: {
                            return this.shares.get(n).getName();
                        }
                        case Path: {
                            return this.shares.get(n).getPath();
                        }
                        case Type: {
                            return this.shares.get(n).getNodeType();
                        }
                        case Description: {
                            return this.shares.get(n).getDescription();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return null;
        }

        public int getRowCount() {
            return this.shares.size();
        }

        public String getColumnName(SharesColumns sharesColumns) {
            switch (sharesColumns) {
                case Name: {
                    return "Name";
                }
                case Path: {
                    return "Path";
                }
                case Type: {
                    return "Type";
                }
                case Description: {
                    return "Description";
                }
            }
            return super.getColumnName((Enum)sharesColumns);
        }

        public Class<?> getColumnClass(SharesColumns sharesColumns) {
            return sharesColumns.getClazz();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SharesColumns {
        Name(String.class),
        Path(String.class),
        Type(Resource.TYPE.class),
        Description(String.class);

        Class<?> clazz;

        private SharesColumns(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }
    }
}

