/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.display;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.netmapviewer.data.Ping;
import ddb.gui.swing.DszTableCellRenderer;
import ddb.util.AbstractEnumeratedTableModel;
import ddb.util.tablefilter.sample.ColumnHidingModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingDisplay
extends JPanel {
    CoreController core;
    ColumnHidingModel hider;
    private JScrollPane jScrollPane1;
    private JTable pingTable;

    public PingDisplay(CoreController coreController, List<Ping> list) {
        this.core = coreController;
        this.hider = new ColumnHidingModel(PingColumns.class);
        this.initComponents();
        this.pingTable.setColumnModel((TableColumnModel)this.hider);
        PingTableModel pingTableModel = new PingTableModel(list);
        this.pingTable.setModel((TableModel)((Object)pingTableModel));
        this.hider.applyToTable(this.pingTable);
        this.pingTable.setDefaultRenderer(Calendar.class, (TableCellRenderer)new DszTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object != null) {
                    Calendar calendar = (Calendar)object;
                    return super.getTableCellRendererComponent(jTable, (Object)String.format("%04d-%02d-%02d   %02d:%02d:%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13)), bl, bl2, n, n2);
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        this.pingTable.setDefaultRenderer(Long.class, (TableCellRenderer)new DszTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object != null) {
                    Long l = (Long)object;
                    StringBuilder stringBuilder = new StringBuilder();
                    if (l >= 60000L) {
                        stringBuilder.append(l / 60000L);
                        stringBuilder.append(":");
                        l = l % 60000L;
                    }
                    if (l >= 1000L || stringBuilder.length() > 0) {
                        stringBuilder.append(String.format("%02d.", l / 1000L));
                        l = l % 1000L;
                    } else {
                        stringBuilder.append("0.");
                    }
                    stringBuilder.append(String.format("%03d s", l));
                    return super.getTableCellRendererComponent(jTable, (Object)stringBuilder.toString(), bl, bl2, n, n2);
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.pingTable = new JTable();
        this.pingTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.pingTable);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 300, Short.MAX_VALUE));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PingTableModel
    extends AbstractEnumeratedTableModel<PingColumns> {
        List<Ping> pings;

        public PingTableModel(List<Ping> list) {
            super(PingColumns.class);
            this.pings = new ArrayList<Ping>();
            this.pings.addAll(list);
            Collections.sort(this.pings, new Comparator<Ping>(){

                @Override
                public int compare(Ping ping, Ping ping2) {
                    long l = ping.getLpTimestamp() - ping2.getLpTimestamp();
                    if (l < 0L) {
                        return -1;
                    }
                    if (l == 0L) {
                        return 0;
                    }
                    return 1;
                }
            });
        }

        public Object getValueAt(int n, PingColumns pingColumns) {
            try {
                if (n < this.pings.size() && n >= 0) {
                    switch (pingColumns) {
                        case Destination: {
                            return this.pings.get(n).getDestination();
                        }
                        case Time: {
                            return this.pings.get(n).getElapsed();
                        }
                        case Timestamp: {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTimeInMillis(this.pings.get(n).getLpTimestamp());
                            return calendar;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return null;
        }

        public int getRowCount() {
            return this.pings.size();
        }

        public String getColumnName(PingColumns pingColumns) {
            switch (pingColumns) {
                case Destination: {
                    return "Destination";
                }
                case Time: {
                    return "Time (ms)";
                }
                case Timestamp: {
                    return "Time";
                }
            }
            return super.getColumnName((Enum)pingColumns);
        }

        public Class<?> getColumnClass(PingColumns pingColumns) {
            return pingColumns.getClazz();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PingColumns {
        Destination(String.class),
        Time(Long.class),
        Timestamp(Calendar.class);

        Class<?> clazz;

        private PingColumns(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }
    }
}

