/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.display;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.netmapviewer.data.Netmap;
import java.awt.EventQueue;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class NetmapDisplay
extends JPanel {
    Netmap current = null;
    CoreController core;
    private JTextArea addressField;
    private JTextField commentField;
    private JLabel estimatedTimeField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField localNameField;
    private JTextField nameField;
    private JTextField osField;
    private JTextField providerField;
    private JLabel reportedTimeField;
    private JTextArea softwareField;

    public NetmapDisplay(CoreController coreController, Netmap netmap) {
        this.core = coreController;
        this.initComponents();
        this.setNode(netmap);
    }

    public void setNode(Netmap netmap) {
        this.current = netmap;
        this.core.submit((Runnable)new UpdateTime(netmap));
        this.nameField.setText(netmap != null ? netmap.getName() : "");
        this.localNameField.setText(netmap != null ? netmap.getLocalName() : "");
        this.commentField.setText(netmap != null ? netmap.getComment() : "");
        this.providerField.setText(netmap != null ? netmap.getProvider() : "");
        this.reportedTimeField.setText(netmap != null ? this.calcTimeZone(netmap.getTimeZone()) : "");
        this.addressField.setText("");
        this.softwareField.setText("");
        if (netmap != null) {
            this.reportedTimeField.setText(this.formatCalendar(netmap.getReportedTime()));
        } else {
            this.reportedTimeField.setText("");
        }
        if (netmap != null) {
            for (String string : netmap.getAddresses()) {
                this.addressField.append(string + "\n");
            }
            for (String string : netmap.getSoftware()) {
                this.softwareField.append(string + "\n");
            }
        }
        Object object = "Unknown";
        if (netmap != null && netmap.getOsPlatform() != null && netmap.getOsPlatform().length() != 0) {
            object = String.format("%s %d.%d", netmap.getOsPlatform(), netmap.getMajorVersion(), netmap.getMinorVersion());
        }
        this.osField.setText((String)object);
    }

    private String calcTimeZone(long l) {
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            l = Math.abs(l);
        }
        l /= 1000L;
        long l2 = (l /= 60L) % 60L;
        long l3 = l / 60L;
        return (bl ? "-" : "") + String.format("%02d:%02d", l3, l2);
    }

    private String formatCalendar(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        return this.formatCalendar(calendar);
    }

    private String formatCalendar(Calendar calendar) {
        if (calendar == null) {
            return "Unknown";
        }
        return String.format("%04d-%02d-%02d %02d:%02d:%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameField = new JTextField();
        this.jLabel2 = new JLabel();
        this.estimatedTimeField = new JLabel();
        this.jLabel3 = new JLabel();
        this.commentField = new JTextField();
        this.jLabel4 = new JLabel();
        this.providerField = new JTextField();
        this.jLabel5 = new JLabel();
        this.localNameField = new JTextField();
        this.jLabel6 = new JLabel();
        this.reportedTimeField = new JLabel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.addressField = new JTextArea();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.softwareField = new JTextArea();
        this.jLabel7 = new JLabel();
        this.osField = new JTextField();
        this.jLabel1.setText("Name:");
        this.nameField.setEditable(false);
        this.jLabel2.setText("Estimated Time:");
        this.estimatedTimeField.setText("Unknown");
        this.jLabel3.setText("Comment:");
        this.commentField.setEditable(false);
        this.jLabel4.setText("Provider:");
        this.providerField.setEditable(false);
        this.jLabel5.setText("Local Name:");
        this.localNameField.setEditable(false);
        this.jLabel6.setText("Reported Time:");
        this.reportedTimeField.setText("Unknown");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Addresses"));
        this.addressField.setColumns(20);
        this.addressField.setEditable(false);
        this.addressField.setRows(5);
        this.jScrollPane1.setViewportView(this.addressField);
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 169, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 169, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 181, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 181, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Software"));
        this.softwareField.setColumns(20);
        this.softwareField.setEditable(false);
        this.softwareField.setRows(5);
        this.jScrollPane2.setViewportView(this.softwareField);
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 186, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 181, Short.MAX_VALUE));
        this.jLabel7.setText("OS:");
        this.osField.setEditable(false);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel2).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameField, -1, 303, Short.MAX_VALUE).addComponent(this.commentField, -1, 303, Short.MAX_VALUE).addComponent(this.estimatedTimeField, -1, 303, Short.MAX_VALUE).addComponent(this.providerField, -1, 303, Short.MAX_VALUE).addComponent(this.localNameField, -1, 303, Short.MAX_VALUE).addComponent(this.reportedTimeField, -1, 303, Short.MAX_VALUE).addComponent(this.osField, -1, 303, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.nameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.localNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.commentField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.providerField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.osField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.estimatedTimeField).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.reportedTimeField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    private class UpdateTime
    implements Runnable {
        Netmap node;

        public UpdateTime(Netmap netmap) {
            this.node = netmap;
        }

        public void run() {
            Netmap netmap = this.node;
            if (netmap != NetmapDisplay.this.current) {
                this.node = null;
                return;
            }
            if (EventQueue.isDispatchThread()) {
                if (netmap == null || netmap.getTimeOffset() == 0L) {
                    NetmapDisplay.this.estimatedTimeField.setText("Unknown");
                } else {
                    Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                    calendar.add(14, (int)netmap.getTimeOffset());
                    NetmapDisplay.this.estimatedTimeField.setText(String.format("%s (TZ %s)", NetmapDisplay.this.formatCalendar(calendar), NetmapDisplay.this.calcTimeZone(netmap.getTimeZone())));
                }
            } else {
                EventQueue.invokeLater(this);
                if (netmap != null) {
                    NetmapDisplay.this.core.schedule((Runnable)this, 500L, TimeUnit.MILLISECONDS);
                } else {
                    System.out.println("Stopping updates");
                }
            }
        }
    }
}

