/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.display;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.netmapviewer.data.Group;
import ddb.util.AbstractEnumeratedTableModel;
import ddb.util.tablefilter.sample.ColumnHidingModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsDisplay
extends JPanel {
    ColumnHidingModel hider = new ColumnHidingModel(GroupsColumns.class);
    private JTable dispTable;
    private JScrollPane scroller;

    public GroupsDisplay(CoreController coreController, List<Group> list) {
        this.initComponents();
        this.dispTable.setColumnModel((TableColumnModel)this.hider);
        GroupsTableModel groupsTableModel = new GroupsTableModel(list);
        this.dispTable.setModel((TableModel)((Object)groupsTableModel));
        this.hider.applyToTable(this.dispTable);
        this.dispTable.setRowSorter(new TableRowSorter<GroupsTableModel>(groupsTableModel));
    }

    private void initComponents() {
        this.scroller = new JScrollPane();
        this.dispTable = new JTable();
        this.dispTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.scroller.setViewportView(this.dispTable);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.scroller, -1, 418, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.scroller, -1, 749, Short.MAX_VALUE));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GroupsTableModel
    extends AbstractEnumeratedTableModel<GroupsColumns> {
        List<Group> groups;

        public GroupsTableModel(List<Group> list) {
            super(GroupsColumns.class);
            this.groups = new ArrayList<Group>();
            this.groups.addAll(list);
            Collections.sort(this.groups, new Comparator<Group>(){

                @Override
                public int compare(Group group, Group group2) {
                    long l = group.getLpTimestamp() - group2.getLpTimestamp();
                    if (l < 0L) {
                        return -1;
                    }
                    if (l == 0L) {
                        return 0;
                    }
                    return 1;
                }
            });
        }

        public Object getValueAt(int n, GroupsColumns groupsColumns) {
            try {
                if (n < this.groups.size() && n >= 0) {
                    switch (groupsColumns) {
                        case GroupName: {
                            return this.groups.get(n).getGroupName();
                        }
                        case GroupComment: {
                            return this.groups.get(n).getGroupComment();
                        }
                        case GroupId: {
                            return this.groups.get(n).getGroupId();
                        }
                        case GroupAttributes: {
                            return this.groups.get(n).getGroupAttributes();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return null;
        }

        public int getRowCount() {
            return this.groups.size();
        }

        public String getColumnName(GroupsColumns groupsColumns) {
            switch (groupsColumns) {
                case GroupName: {
                    return "Group Name";
                }
                case GroupComment: {
                    return "Group Comment";
                }
                case GroupId: {
                    return "Group Id";
                }
                case GroupAttributes: {
                    return "Group Attributes";
                }
            }
            return super.getColumnName((Enum)groupsColumns);
        }

        public Class<?> getColumnClass(GroupsColumns groupsColumns) {
            return groupsColumns.getClazz();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GroupsColumns {
        GroupName(String.class),
        GroupComment(String.class),
        GroupId(String.class),
        GroupAttributes(String.class);

        Class<?> clazz;

        private GroupsColumns(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }
    }
}

