/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.data;

import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.plugin.netmapviewer.data.Data;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Traceroute
extends Data {
    String location;
    List<Hop> hops = new Vector<Hop>();

    public Traceroute(ObjectValue objectValue) {
        super(objectValue);
        this.location = objectValue.getString(TracerouteConstants.Location.text);
    }

    public int addHop(ObjectValue objectValue) {
        int n = this.hops.size();
        this.hops.add(new Hop(objectValue));
        return n;
    }

    public List<Hop> getHops() {
        return this.hops;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Hop
    extends Data
    implements Comparable<Hop> {
        String address;
        long time;
        int hop;

        public Hop(ObjectValue objectValue) {
            super(objectValue);
            this.address = objectValue.getString(TracerouteConstants.Host.text);
            this.time = objectValue.getInteger(TracerouteConstants.Time.text);
            this.hop = objectValue.getInteger(TracerouteConstants.Hop.text).intValue();
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String string) {
            this.address = string;
        }

        public int getHop() {
            return this.hop;
        }

        public void setHop(int n) {
            this.hop = n;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long l) {
            this.time = l;
        }

        @Override
        public int compareTo(Hop hop) {
            if (hop == null) {
                return -1;
            }
            return ((Integer)Integer.class.cast(this.hop)).compareTo(hop.hop);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TracerouteConstants {
        Location,
        Time,
        Hop,
        Host;

        public final String text;

        private TracerouteConstants() {
            this.text = this.name();
        }

        private TracerouteConstants(String string2) {
            this.text = string2;
        }
    }
}

