/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.data;

import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.plugin.netmapviewer.NetmapNodeType;
import ddb.dsz.plugin.netmapviewer.NetmapViewerHost;
import ddb.dsz.plugin.netmapviewer.data.Data;
import ddb.util.GeneralUtilities;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Netmap
extends Data {
    private long level;
    private long osVersionMajor;
    private long osVersionMinor;
    private long timeOffset;
    private long timeZone = 0L;
    private String name;
    private String localName;
    private String provider;
    private NetmapNodeType type;
    private String parent;
    private String comment;
    private String osPlatform;
    private SortedSet<String> addresses = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private SortedSet<String> software = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private long reportedTime;

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public long getTimeZone() {
        return this.timeZone;
    }

    public Collection<String> getAddresses() {
        return Collections.unmodifiableSortedSet(this.addresses);
    }

    public Collection<String> getSoftware() {
        return Collections.unmodifiableSortedSet(this.software);
    }

    public void setOsVersion(long l, long l2) {
        this.osVersionMajor = l;
        this.osVersionMinor = l2;
    }

    public long getMajorVersion() {
        return this.osVersionMajor;
    }

    public long getMinorVersion() {
        return this.osVersionMinor;
    }

    public void setTimeOffset(long l) {
        this.timeOffset = l;
    }

    public void setTimeZone(long l) {
        this.timeZone = l;
    }

    public void addAddresses(List<String> list) {
        for (String string : list) {
            this.addresses.add(string);
        }
    }

    public void addAddresses(String ... stringArray) {
        for (String string : stringArray) {
            this.addresses.add(string);
        }
    }

    public void addSoftware(List<String> list) {
        for (String string : list) {
            this.software.add(string);
        }
    }

    public void addSoftware(String ... stringArray) {
        for (String string : stringArray) {
            this.software.add(string);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public long getLevel() {
        return this.level;
    }

    public void setLevel(long l) {
        this.level = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string.startsWith("\\\\")) {
            string = string.substring(2);
        }
        try {
            if (string.matches("^[0-9]{1,3}\\..*$")) {
                this.addAddresses(string);
                if (this.name != null) {
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.name = string;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String string) {
        this.parent = string;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String string) {
        this.provider = string;
    }

    public NetmapNodeType getNodeType() {
        return this.type;
    }

    public void setNodeType(NetmapNodeType netmapNodeType) {
        this.type = netmapNodeType;
    }

    public void setNodeType(String string) {
        for (NetmapNodeType netmapNodeType : NetmapNodeType.values()) {
            if (!netmapNodeType.match(string)) continue;
            this.setNodeType(netmapNodeType);
            return;
        }
    }

    public void setOsPlatform(String string) {
        this.osPlatform = string;
    }

    public String getOsPlatform() {
        return this.osPlatform;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String string) {
        this.localName = string;
    }

    public long getReportedTime() {
        return this.reportedTime;
    }

    public void setReportedTime(long l) {
        this.reportedTime = l;
    }

    public Netmap(ObjectValue objectValue) {
        super(objectValue);
        this.setLevel(objectValue.getInteger(NetmapConstants.LEVEL.text));
        this.setName(objectValue.getString(NetmapConstants.REMOTE_NAME.text));
        this.setProvider(objectValue.getString(NetmapConstants.PROVIDER.text));
        this.setNodeType(objectValue.getString(NetmapConstants.TYPE.text));
        this.setComment(objectValue.getString(NetmapConstants.COMMENT.text));
        this.setParent(objectValue.getString(NetmapConstants.PARENT.text));
        this.setLocalName(objectValue.getString(NetmapConstants.LOCAL_NAME.text));
        this.addSoftware(objectValue.getStrings(NetmapConstants.SOFTWARE.text));
        this.setOsPlatform(objectValue.getString(NetmapConstants.OS_PLATFORM.text));
        try {
            if (objectValue.getInteger(NetmapConstants.OS_VERSION_MAJOR.text) != null && objectValue.getInteger(NetmapConstants.OS_VERSION_MINOR.text) != null) {
                this.setOsVersion(objectValue.getInteger(NetmapConstants.OS_VERSION_MAJOR.text), objectValue.getInteger(NetmapConstants.OS_VERSION_MINOR.text));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String string = objectValue.getString(NetmapConstants.TIME.text);
        String string2 = objectValue.getString(NetmapConstants.TIME_ZONE_OFFSET.text);
        if (string != null && string.length() > 0) {
            Calendar calendar = GeneralUtilities.stringToCalendar((String)string, null);
            long l = calendar.getTimeInMillis() - super.getLpTimestamp();
            if (l == 0L) {
                l = -1L;
            }
            this.setTimeOffset(l);
            this.setTimeZone(NetmapViewerHost.stringToMillisecondDuration(string2));
            this.setReportedTime(super.getLpTimestamp());
        }
        this.addAddresses(objectValue.getStrings(NetmapConstants.IP.text));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NetmapConstants {
        LEVEL,
        TIME,
        OS_PLATFORM("osplatform"),
        REMOTE_NAME("remotename"),
        TIME_ZONE_OFFSET("timezoneoffset"),
        PROVIDER,
        PARENT("parentname"),
        TYPE,
        COMMENT,
        LOCAL_NAME("localname"),
        IP,
        OS_VERSION_MAJOR("osversionmajor"),
        OS_VERSION_MINOR("osversionminor"),
        SOFTWARE("software::description");

        public final String text;

        private NetmapConstants() {
            this.text = this.name();
        }

        private NetmapConstants(String string2) {
            this.text = string2;
        }
    }
}

