/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.closures;

import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.netmapviewer.NetmapViewerHost;
import ddb.dsz.plugin.netmapviewer.data.Traceroute;
import ddb.dsz.plugin.netmapviewer.insertion.InsertTraceroute;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Closure;

public class TracerouteClosure
implements Closure {
    NetmapViewerHost networkHost;
    final Map<TaskId, Traceroute> traceRouteMap = new HashMap<TaskId, Traceroute>();
    final Set<DataEvent> pendingEvents = new HashSet<DataEvent>();

    public TracerouteClosure(NetmapViewerHost netmapViewerHost) {
        this.networkHost = netmapViewerHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object object) {
        DataEvent dataEvent = (DataEvent)object;
        TaskId taskId = dataEvent.getTaskId();
        if (taskId == null) {
            return;
        }
        if (!DataEvent.DataEventType.DATA.equals((Object)dataEvent.getDataType())) {
            return;
        }
        HashSet<DataEvent> hashSet = new HashSet<DataEvent>();
        Map<TaskId, Traceroute> map = this.traceRouteMap;
        synchronized (map) {
            Traceroute traceroute;
            for (ObjectValue objectValue : dataEvent.getData().getObjects("target")) {
                traceroute = new Traceroute(objectValue);
                Map<TaskId, Traceroute> map2 = this.traceRouteMap;
                synchronized (map2) {
                    this.traceRouteMap.put(dataEvent.getTaskId(), traceroute);
                }
                EventQueue.invokeLater(new InsertTraceroute(traceroute, -1, this.networkHost));
                for (DataEvent dataEvent2 : this.pendingEvents) {
                    if (!dataEvent2.getTaskId().equals((Object)dataEvent.getTaskId())) continue;
                    hashSet.add(dataEvent2);
                }
                this.pendingEvents.removeAll(hashSet);
            }
            for (ObjectValue objectValue : dataEvent.getData().getObjects("hopinfo")) {
                Map<TaskId, Traceroute> map3 = this.traceRouteMap;
                synchronized (map3) {
                    traceroute = this.traceRouteMap.get(dataEvent.getTaskId());
                }
                if (traceroute == null) {
                    this.pendingEvents.add(dataEvent);
                    continue;
                }
                int n = traceroute.addHop(objectValue);
                EventQueue.invokeLater(new InsertTraceroute(traceroute, n, this.networkHost));
            }
        }
        for (DataEvent dataEvent3 : hashSet) {
            this.execute(dataEvent3);
        }
    }
}

