/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.closures;

import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.netmapviewer.NetmapViewerHost;
import ddb.dsz.plugin.netmapviewer.insertion.InsertAddress;
import ddb.dsz.plugin.netmapviewer.insertion.MergeAddresses;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.collections.Closure;

public class NetConnectionsClosure
implements Closure {
    final NetmapViewerHost networkHost;
    final Collection<String> AllRemoteAddressesSeen;
    final Collection<String> AllLocalAddressesSeen;

    public NetConnectionsClosure(NetmapViewerHost netmapViewerHost) {
        this.networkHost = netmapViewerHost;
        this.AllRemoteAddressesSeen = new HashSet<String>();
        this.AllLocalAddressesSeen = new HashSet<String>();
    }

    public void execute(Object object) {
        DataEvent dataEvent = (DataEvent)object;
        TaskId taskId = dataEvent.getTaskId();
        if (taskId == null) {
            return;
        }
        if (!DataEvent.DataEventType.DATA.equals((Object)dataEvent.getDataType())) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String string : new String[]{"InitialConnectionListItem", "StartConnectionListItem", "StopConnectionListItem"}) {
            for (ObjectValue objectValue : dataEvent.getData().getObjects(String.format("%s::ConnectionItem", string))) {
                ObjectValue objectValue2;
                ObjectValue objectValue3 = objectValue.getObject("local");
                if (objectValue3 != null) {
                    hashSet.add(objectValue3.getString("address"));
                    hashSet.add(objectValue3.getString("ipv4"));
                    hashSet.add(objectValue3.getString("ipv6"));
                }
                if ((objectValue2 = objectValue.getObject("remote")) == null) continue;
                Vector<String> vector = new Vector<String>();
                vector.add(objectValue2.getString("address"));
                vector.add(objectValue2.getString("ipv4"));
                vector.add(objectValue2.getString("ipv6"));
                for (String string2 : vector) {
                    if (string2 == null || string2.equals("::") || string2.equals("0.0.0.0")) continue;
                    hashSet2.add(string2);
                }
            }
        }
        hashSet2.removeAll(this.AllRemoteAddressesSeen);
        if (hashSet2.size() > 0) {
            this.AllRemoteAddressesSeen.addAll(hashSet2);
            EventQueue.invokeLater(new InsertAddress(hashSet2, this.networkHost));
        }
        hashSet.removeAll(this.AllLocalAddressesSeen);
        if (hashSet.size() > 0) {
            this.AllLocalAddressesSeen.addAll(hashSet);
            EventQueue.invokeLater(new MergeAddresses(hashSet, this.networkHost));
        }
    }
}

