/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.contextmenu.CommandCallbackListener;
import ddb.dsz.core.contextmenu.ContextMenuAction;
import ddb.dsz.core.contextmenu.ContextMenuFactory;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.ClosureFactory;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.DataTransformer;
import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.multitarget.SingleTargetImpl;
import ddb.dsz.plugin.netmapviewer.Node;
import ddb.dsz.plugin.netmapviewer.closures.ArpClosure;
import ddb.dsz.plugin.netmapviewer.closures.IfConfigClosure;
import ddb.dsz.plugin.netmapviewer.closures.NetConnectionsClosure;
import ddb.dsz.plugin.netmapviewer.closures.NetmapClosure;
import ddb.dsz.plugin.netmapviewer.closures.PingClosure;
import ddb.dsz.plugin.netmapviewer.closures.SharesClosure;
import ddb.dsz.plugin.netmapviewer.closures.TracerouteClosure;
import ddb.dsz.plugin.netmapviewer.data.Group;
import ddb.dsz.plugin.netmapviewer.data.Service;
import ddb.dsz.plugin.netmapviewer.data.User;
import ddb.dsz.plugin.netmapviewer.display.ArpDisplay;
import ddb.dsz.plugin.netmapviewer.display.GroupsDisplay;
import ddb.dsz.plugin.netmapviewer.display.IfConfigDisplay;
import ddb.dsz.plugin.netmapviewer.display.NetmapDisplay;
import ddb.dsz.plugin.netmapviewer.display.PingDisplay;
import ddb.dsz.plugin.netmapviewer.display.PrintableCommandsDisplay;
import ddb.dsz.plugin.netmapviewer.display.ServiceDisplay;
import ddb.dsz.plugin.netmapviewer.display.ShareDisplay;
import ddb.dsz.plugin.netmapviewer.display.TracerouteDisplay;
import ddb.dsz.plugin.netmapviewer.display.UserDisplay;
import ddb.dsz.plugin.netmapviewer.insertion.InsertGroupsNode;
import ddb.dsz.plugin.netmapviewer.insertion.InsertPrintCommandNode;
import ddb.dsz.plugin.netmapviewer.insertion.InsertServicesNode;
import ddb.dsz.plugin.netmapviewer.insertion.InsertUsersNode;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetmapViewerHost
extends SingleTargetImpl
implements ContextMenuAction,
CommandCallbackListener {
    static final String CONTEXT_MENU = "/NetmapViewer/ContextMenu.xml";
    static final Set<String> INTERESTING_COMMANDS;
    private static Set<String> TARGETED_COMMANDS;
    private static Set<String> PRINTABLE_COMMANDS;
    private DataTransformer dataTranslator;
    private DataTransformer targetTranslator;
    public JTree itemList;
    private JTabbedPane nodeDisplay;
    public DefaultMutableTreeNode rootNode;
    private Node root;
    public DefaultMutableTreeNode unknownNode;
    private Node unknown;
    public Node ArpNode = null;
    public DefaultTreeModel treeModel;
    public final Map<String, DefaultMutableTreeNode> nameToNode = new HashMap<String, DefaultMutableTreeNode>();

    private synchronized void initializeTransformers() {
        if (this.targetTranslator == null) {
            this.targetTranslator = DataTransformer.newInstance();
        }
        if (this.dataTranslator == null) {
            this.dataTranslator = DataTransformer.newInstance();
        }
    }

    public NetmapViewerHost(HostInfo hostInfo, final CoreController coreController) {
        super(hostInfo, coreController);
        this.initializeTransformers();
        if (this.dataTranslator == null || this.targetTranslator == null) {
            throw new IllegalStateException("Unable to instansiate NetmapViewerHost because 'dataTranslator' is null");
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                NetmapViewerHost.this.rootNode = new DefaultMutableTreeNode("Network");
                NetmapViewerHost.this.root = new Node();
                NetmapViewerHost.this.nameToNode.put("", NetmapViewerHost.this.rootNode);
                NetmapViewerHost.this.unknownNode = new DefaultMutableTreeNode("Unknown");
                NetmapViewerHost.this.unknown = new Node();
                NetmapViewerHost.this.unknownNode.setUserObject(NetmapViewerHost.this.unknown);
                NetmapViewerHost.this.unknown.setMatchable(false);
                NetmapViewerHost.this.treeModel = new DefaultTreeModel(NetmapViewerHost.this.rootNode);
                NetmapViewerHost.this.treeModel.insertNodeInto(NetmapViewerHost.this.unknownNode, NetmapViewerHost.this.rootNode, 0);
                NetmapViewerHost.this.itemList = new JTree(NetmapViewerHost.this.treeModel);
                NetmapViewerHost.this.nodeDisplay = new JTabbedPane();
                NetmapViewerHost.this.nodeDisplay.setTabLayoutPolicy(1);
                final JSplitPane jSplitPane = new JSplitPane(1, new JScrollPane(NetmapViewerHost.this.itemList), NetmapViewerHost.this.nodeDisplay);
                NetmapViewerHost.this.setDisplay(jSplitPane);
                jSplitPane.addComponentListener(new ComponentAdapter(){

                    public void componentShown(ComponentEvent componentEvent) {
                        jSplitPane.setDividerLocation(0.33);
                        jSplitPane.removeComponentListener(this);
                    }
                });
                NetmapViewerHost.this.itemList.addTreeSelectionListener(new TreeSelectionListener(){

                    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                        Component[] componentArray = NetmapViewerHost.this.nodeDisplay.getComponents();
                        if (componentArray != null) {
                            for (Component component : componentArray) {
                                if (!(component instanceof NetmapDisplay)) continue;
                                ((NetmapDisplay)NetmapDisplay.class.cast(component)).setNode(null);
                            }
                        }
                        NetmapViewerHost.this.nodeDisplay.removeAll();
                        Object object = null;
                        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                        if (treePath != null) {
                            Object object2 = treePath.getLastPathComponent();
                            if (object2 instanceof DefaultMutableTreeNode) {
                                object2 = ((DefaultMutableTreeNode)DefaultMutableTreeNode.class.cast(object2)).getUserObject();
                            }
                            if (object2 instanceof Node) {
                                object = (Node)object2;
                            }
                        }
                        if (object == null) {
                            return;
                        }
                        if (((Node)object).isUpdated()) {
                            ((Node)object).viewed();
                            NetmapViewerHost.this.treeModel.nodeChanged((TreeNode)treePath.getLastPathComponent());
                        }
                        if (((Node)object).getNetmapData() != null) {
                            NetmapDisplay netmapDisplay = new NetmapDisplay(coreController, ((Node)object).getNetmapData());
                            NetmapViewerHost.this.nodeDisplay.add("Netmap", netmapDisplay);
                        }
                        if (((Node)object).getIfConfig() != null) {
                            IfConfigDisplay ifConfigDisplay = new IfConfigDisplay(((Node)object).getIfConfig());
                            NetmapViewerHost.this.nodeDisplay.add("IfConfig", new JScrollPane(ifConfigDisplay));
                        }
                        if (((Node)object).getArps().size() > 0) {
                            ArpDisplay arpDisplay = new ArpDisplay(((Node)object).getArps());
                            NetmapViewerHost.this.nodeDisplay.add("Arp", arpDisplay);
                        }
                        if (((Node)object).getGroups().size() > 0) {
                            GroupsDisplay groupsDisplay = new GroupsDisplay(coreController, ((Node)object).getGroups());
                            NetmapViewerHost.this.nodeDisplay.add("Groups", groupsDisplay);
                        }
                        if (((Node)object).getResources().size() > 0) {
                            ShareDisplay shareDisplay = new ShareDisplay(coreController, ((Node)object).getResources());
                            NetmapViewerHost.this.nodeDisplay.add("Shares", shareDisplay);
                        }
                        if (((Node)object).getPings().size() > 0) {
                            PingDisplay pingDisplay = new PingDisplay(coreController, ((Node)object).getPings());
                            NetmapViewerHost.this.nodeDisplay.add("Ping", pingDisplay);
                        }
                        if (((Node)object).getServices().size() > 0) {
                            ServiceDisplay serviceDisplay = new ServiceDisplay(coreController, ((Node)object).getServices());
                            NetmapViewerHost.this.nodeDisplay.add("Services", serviceDisplay);
                        }
                        if (((Node)object).getTraceroutes().size() > 0) {
                            TracerouteDisplay tracerouteDisplay = new TracerouteDisplay(coreController, (Node)object);
                            NetmapViewerHost.this.nodeDisplay.add("Traceroute", tracerouteDisplay);
                        }
                        if (((Node)object).getUsers().size() > 0) {
                            UserDisplay userDisplay = new UserDisplay(coreController, ((Node)object).getUsers());
                            NetmapViewerHost.this.nodeDisplay.add("Users", userDisplay);
                        }
                        for (Task task : ((Node)object).getPrintedCommands()) {
                            PrintableCommandsDisplay printableCommandsDisplay = new PrintableCommandsDisplay(coreController, task, ((Node)object).getPrintedCommand(task));
                            NetmapViewerHost.this.nodeDisplay.add(String.format("%d: %s", task.getId().getId(), task.getCommandName()), printableCommandsDisplay);
                        }
                    }
                });
                NetmapViewerHost.this.itemList.setCellRenderer(new DefaultTreeCellRenderer(){
                    Font BOLD = null;
                    Font PLAIN = null;
                    Font ITALICS = null;

                    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                        if (this.BOLD == null) {
                            this.BOLD = super.getFont().deriveFont(1);
                        }
                        if (this.PLAIN == null) {
                            this.PLAIN = super.getFont().deriveFont(0);
                        }
                        if (this.ITALICS == null) {
                            this.ITALICS = super.getFont().deriveFont(2);
                        }
                        Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                        component.setFont(this.PLAIN);
                        if (object instanceof DefaultMutableTreeNode) {
                            object = ((DefaultMutableTreeNode)DefaultMutableTreeNode.class.cast(object)).getUserObject();
                        }
                        if (object == NetmapViewerHost.this.ArpNode) {
                            component.setFont(this.BOLD);
                        }
                        if (object instanceof Node) {
                            Node node = (Node)object;
                            if (node.getNetmapData() != null && node.getNetmapData().getLevel() == 1L) {
                                component.setFont(this.BOLD);
                            }
                            if (node.isUpdated()) {
                                component.setFont(this.ITALICS);
                            }
                        }
                        return component;
                    }
                });
                NetmapViewerHost.this.itemList.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        this.maybeShowPopup(mouseEvent);
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                        this.maybeShowPopup(mouseEvent);
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                        this.maybeShowPopup(mouseEvent);
                    }

                    private void maybeShowPopup(MouseEvent mouseEvent) {
                        if (!mouseEvent.isPopupTrigger()) {
                            return;
                        }
                        int n = NetmapViewerHost.this.itemList.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                        if (n < 0) {
                            return;
                        }
                        TreePath treePath = NetmapViewerHost.this.itemList.getPathForRow(n);
                        if (treePath == null) {
                            return;
                        }
                        Object object = treePath.getLastPathComponent();
                        if (object instanceof DefaultMutableTreeNode) {
                            object = ((DefaultMutableTreeNode)DefaultMutableTreeNode.class.cast(object)).getUserObject();
                        }
                        if (object instanceof Node) {
                            Map<String, String> map = NetmapViewerHost.this.generateMap((Node)object);
                            JPopupMenu jPopupMenu = ContextMenuFactory.createContextMenuString((String)NetmapViewerHost.CONTEXT_MENU, (CoreController)NetmapViewerHost.this.core, (CommandCallbackListener)NetmapViewerHost.this, (HostInfo)NetmapViewerHost.this.target, Collections.singleton(map), null, (ContextMenuAction)NetmapViewerHost.this);
                            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                });
            }
        });
        Closure closure = new Closure(){

            public void execute(Object object) {
                DataEvent dataEvent = (DataEvent)object;
                TaskId taskId = dataEvent.getTaskId();
                if (taskId == null) {
                    return;
                }
                Boolean bl = dataEvent.getData().getBoolean("target::local");
                String string = dataEvent.getData().getString("target::location");
                if (bl == null || bl == Boolean.TRUE) {
                    return;
                }
                if (string != null) {
                    NetmapViewerHost.this.handleTargetedTask(string, coreController.getTaskById(taskId));
                }
            }
        };
        this.targetTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"groups", (String)"Dsz", (Closure)closure));
        this.targetTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"ldap", (String)"Dsz", (Closure)closure));
        this.targetTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"netbios", (String)"Dsz", (Closure)closure));
        this.targetTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"processes", (String)"Dsz", (Closure)closure));
        this.targetTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"scheduler", (String)"Dsz", (Closure)closure));
        this.targetTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"services", (String)"Dsz", (Closure)closure));
        this.targetTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"uptime", (String)"Dsz", (Closure)closure));
        this.targetTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"users", (String)"Dsz", (Closure)closure));
        this.targetTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"shares", (String)"ZBng", (Closure)closure));
        this.targetTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"route", (String)"Dsz", (Closure)new Closure(){
            Set<Task> handledTasks = new TreeSet<Task>(Task.TaskComparator);

            public void execute(Object object) {
                DataEvent dataEvent = (DataEvent)object;
                TaskId taskId = dataEvent.getTaskId();
                if (taskId == null) {
                    return;
                }
                try {
                    Task task;
                    if (dataEvent.getData().getObject("route") != null && this.handledTasks.add(task = coreController.getTaskById(taskId))) {
                        NetmapViewerHost.this.handleTargetedTask(NetmapViewerHost.this.unknown, task);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }));
        this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"arp", (String)"Dsz", (Closure)new ArpClosure(this)));
        this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"ifconfig", (String)"Dsz", (Closure)new IfConfigClosure(coreController, this)));
        this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"netconnections", (String)"Dsz", (Closure)new NetConnectionsClosure(this)));
        this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"netmap", (String)"Dsz", (Closure)new NetmapClosure(this)));
        this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"ping", (String)"Dsz", (Closure)new PingClosure(this)));
        this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"traceroute", (String)"Dsz", (Closure)new TracerouteClosure(this)));
        this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"shares", (String)"ZBng", (Closure)new SharesClosure(coreController, this)));
    }

    public CoreController getCore() {
        return this.core;
    }

    private void handleTargetedTask(final Node node, final Task task) {
        if (node == null || task == null) {
            return;
        }
        this.dataTranslator.addClosure(ClosureFactory.newDisplayClosure((CoreController)this.core, (Task)task, (Closure)new Closure(){

            public void execute(Object object) {
                EventQueue.invokeLater(new InsertPrintCommandNode(object.toString(), task, node, NetmapViewerHost.this));
            }
        }));
        this.dataTranslator.addTask(task);
    }

    private void handleTargetedTask(String string, final Task task) {
        if (string == null || task == null) {
            return;
        }
        if (string.startsWith("\\\\")) {
            string = string.substring(2);
        }
        final String string2 = string;
        if (task.getCommandName().equalsIgnoreCase("groups")) {
            this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)this.core, (Task)task, (Closure)new Closure(){

                public void execute(Object object) {
                    DataEvent dataEvent = (DataEvent)object;
                    for (ObjectValue objectValue : dataEvent.getData().getObjects("group")) {
                        EventQueue.invokeLater(new InsertGroupsNode(new Group(objectValue, string2, dataEvent.getTaskId()), NetmapViewerHost.this));
                    }
                }
            }));
        }
        if (task.getCommandName().equalsIgnoreCase("services")) {
            this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)this.core, (Task)task, (Closure)new Closure(){

                public void execute(Object object) {
                    DataEvent dataEvent = (DataEvent)object;
                    for (ObjectValue objectValue : dataEvent.getData().getObjects("service")) {
                        EventQueue.invokeLater(new InsertServicesNode(new Service(objectValue, string2, dataEvent.getTaskId()), NetmapViewerHost.this));
                    }
                }
            }));
        }
        if (task.getCommandName().equalsIgnoreCase("users")) {
            this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)this.core, (Task)task, (Closure)new Closure(){

                public void execute(Object object) {
                    DataEvent dataEvent = (DataEvent)object;
                    for (ObjectValue objectValue : dataEvent.getData().getObjects("user")) {
                        EventQueue.invokeLater(new InsertUsersNode(new User(objectValue, string2, dataEvent.getTaskId()), NetmapViewerHost.this));
                    }
                }
            }));
        }
        if (PRINTABLE_COMMANDS.contains(task.getCommandName().toLowerCase())) {
            this.dataTranslator.addClosure(ClosureFactory.newDisplayClosure((CoreController)this.core, (Task)task, (Closure)new Closure(){

                public void execute(Object object) {
                    EventQueue.invokeLater(new InsertPrintCommandNode(object.toString(), task, string2, NetmapViewerHost.this));
                }
            }));
        }
        this.dataTranslator.addTask(task);
    }

    public static long stringToMillisecondDuration(String string) {
        if (string == null) {
            return 0L;
        }
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            Duration duration = datatypeFactory.newDurationDayTime(string);
            if (duration != null) {
                Calendar calendar = Calendar.getInstance();
                return duration.getTimeInMillis(calendar);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0L;
        }
        return 0L;
    }

    public void commandEventReceived(CommandEvent commandEvent) {
        if (commandEvent == null || this.dataTranslator == null) {
            return;
        }
        if (commandEvent.getId() == null) {
            return;
        }
        if (commandEvent.getId().equals((Object)TaskId.UNINITIALIZED_ID)) {
            return;
        }
        Task task = this.core.getTaskById(commandEvent.getId());
        if (task == null) {
            return;
        }
        if (task.getCommandName() == null) {
            return;
        }
        if (TARGETED_COMMANDS.contains(task.getCommandName().toLowerCase())) {
            this.targetTranslator.addTask(task);
        }
        if (INTERESTING_COMMANDS.contains(task.getCommandName().toLowerCase())) {
            this.dataTranslator.addTask(task);
        }
    }

    public void action(List<String> list) {
        this.action(list, null);
    }

    public void action(List<String> list, Object object) {
        if (list.size() == 0) {
            return;
        }
        list.add(String.format("host=%s", this.target.getId()));
        if (this.core.internalCommand(null, list)) {
            // empty if block
        }
    }

    public void registerCommand(String string, TaskId taskId) {
        System.out.println(string);
    }

    public static void Traverse(TreeNode treeNode, Closure closure) {
        if (treeNode != null) {
            closure.execute((Object)treeNode);
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                NetmapViewerHost.Traverse(treeNode.getChildAt(i), closure);
            }
        }
    }

    public static DefaultMutableTreeNode DepthFirstSearch(TreeNode treeNode, Predicate predicate) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (treeNode == null) {
            return null;
        }
        if (treeNode instanceof DefaultMutableTreeNode && predicate.evaluate((defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode).getUserObject())) {
            return defaultMutableTreeNode;
        }
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = NetmapViewerHost.DepthFirstSearch(treeNode2, predicate);
            if (defaultMutableTreeNode2 == null) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    public void NewNodeCleanup(TreeNode treeNode, Node node) {
        Collection<String> collection = node.getAddresses();
        for (int i = 0; i < this.unknownNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.unknownNode.getChildAt(i);
            Node node2 = (Node)defaultMutableTreeNode.getUserObject();
            if (node2 == this.ArpNode) continue;
            for (String string : collection) {
                if (!node2.doesAddressMatch(string) && !node2.doesNameMatch(string)) continue;
                NetmapViewerHost.CopyNode(node2, node);
                if (defaultMutableTreeNode.getParent() == null) continue;
                this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            }
        }
    }

    public static void CopyNode(Node node, Node node2) {
        node2.CopyNode(node);
    }

    public Map<String, String> generateMap(Node node) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Vector<String> vector = new Vector<String>();
        vector.addAll(node.getAddresses());
        Collections.sort(vector, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string == string2) {
                    return 0;
                }
                if (string == null) {
                    return -1;
                }
                if (string2 == null) {
                    return 1;
                }
                if (string.contains(".") && string2.contains(".") || string.contains(":") && string2.contains(":")) {
                    return string.compareToIgnoreCase(string2);
                }
                if (string.contains(".")) {
                    return -1;
                }
                return 1;
            }
        });
        int n = 0;
        for (String string : vector) {
            hashMap.put(String.format("Address_%d", ++n), string);
        }
        return hashMap;
    }

    public void expand(TreeNode treeNode) {
        try {
            TreePath treePath = new TreePath(this.treeModel.getPathToRoot(treeNode));
            this.itemList.expandPath(treePath);
        }
        catch (Throwable throwable) {
            this.core.logEvent(Level.SEVERE, throwable.getMessage(), throwable);
            throwable.printStackTrace();
        }
    }

    public void insertNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        boolean bl = false;
        if (defaultMutableTreeNode2.getUserObject() instanceof Node) {
            Node node = (Node)defaultMutableTreeNode2.getUserObject();
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                if (!(defaultMutableTreeNode3.getUserObject() instanceof Node)) continue;
                Node node2 = (Node)defaultMutableTreeNode3.getUserObject();
                if (node.getOrder().equals((Object)node2.getOrder()) && node.toString().compareTo(node2.toString()) < 0) {
                    this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, i);
                    bl = true;
                    break;
                }
                if (node.getOrder().ordinal() >= node2.getOrder().ordinal()) continue;
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, i);
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        }
        this.expand(defaultMutableTreeNode);
        this.expand(defaultMutableTreeNode2);
    }

    public void removeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
    }

    public static void main(String[] stringArray) throws Throwable {
        Class<?> clazz = Class.forName("ds.plugin.live.DSClientApp");
        Class<?> clazz2 = Class.forName("ds.plugin.replay.OpReplayDriver");
        Method method = clazz.getMethod("main", stringArray.getClass());
        method.invoke(null, new Object[]{stringArray});
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("arp");
        hashSet.add("ifconfig");
        hashSet.add("netconnections");
        hashSet.add("netmap");
        hashSet.add("ping");
        hashSet.add("traceroute");
        INTERESTING_COMMANDS = Collections.unmodifiableSet(hashSet);
        TARGETED_COMMANDS = new HashSet<String>();
        TARGETED_COMMANDS.add("groups");
        TARGETED_COMMANDS.add("ldap");
        TARGETED_COMMANDS.add("netbios");
        TARGETED_COMMANDS.add("processes");
        TARGETED_COMMANDS.add("route");
        TARGETED_COMMANDS.add("scheduler");
        TARGETED_COMMANDS.add("services");
        TARGETED_COMMANDS.add("uptime");
        TARGETED_COMMANDS.add("users");
        PRINTABLE_COMMANDS = new HashSet<String>();
        PRINTABLE_COMMANDS.add("ldap");
        PRINTABLE_COMMANDS.add("netbios");
        PRINTABLE_COMMANDS.add("processes");
        PRINTABLE_COMMANDS.add("route");
        PRINTABLE_COMMANDS.add("scheduler");
        PRINTABLE_COMMANDS.add("uptime");
    }
}

