/*
 * Decompiled with CFR 0.152.
 */
package ds.util.datatransforms.transformers;

import ddb.dsz.core.data.ObjectValue;
import ds.util.datatransforms.DataType;
import ds.util.datatransforms.transformers.LowerCaseTransformer;
import ds.util.datatransforms.transformers.MutableObjectValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.collections.map.TransformedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectValueImpl
implements ObjectValue,
MutableObjectValue {
    static final Transformer StringToLowerCase = new LowerCaseTransformer();
    List<Map<String, Object>> hashes = new ArrayList<Map<String, Object>>(DataType.values().length);
    private static final Pattern nameSplit = Pattern.compile("([^\\[]+)\\[([0-9]+)\\]");

    public static final void AddData(ObjectValue objectValue, DataType dataType, String string, Object object) {
        if (objectValue instanceof MutableObjectValue) {
            ((MutableObjectValue)MutableObjectValue.class.cast(objectValue)).addValue(dataType, string, object);
        }
    }

    public ObjectValueImpl() {
        for (DataType dataType : DataType.values()) {
            this.hashes.add(TransformedMap.decorate((Map)new MultiValueMap(), (Transformer)StringToLowerCase, (Transformer)dataType.getTransformer()));
        }
    }

    @Override
    public void addValue(DataType dataType, String string, Object object) {
        this.getHash(dataType).put(string, object);
    }

    private static List<String> getStages(String string) {
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(string.toLowerCase().split("::"));
    }

    public String getString(String string) {
        return (String)String.class.cast(this.getValue(DataType.STRING, string));
    }

    public List<String> getStrings(String string) {
        return this.getValues(DataType.STRING, string);
    }

    public Set<String> getStringNames() {
        return this.getKeys(DataType.STRING);
    }

    public Boolean getBoolean(String string) {
        return (Boolean)Boolean.class.cast(this.getValue(DataType.BOOLEAN, string));
    }

    public List<Boolean> getBooleans(String string) {
        return this.getValues(DataType.BOOLEAN, string);
    }

    public Set<String> getBooleanNames() {
        return this.getKeys(DataType.BOOLEAN);
    }

    public Long getInteger(String string) {
        return (Long)Long.class.cast(this.getValue(DataType.INTEGER, string));
    }

    public List<Long> getIntegers(String string) {
        return this.getValues(DataType.INTEGER, string);
    }

    public Set<String> getIntegerNames() {
        return this.getKeys(DataType.INTEGER);
    }

    public ObjectValueImpl getObject(String string) {
        return (ObjectValueImpl)ObjectValueImpl.class.cast(this.getValue(DataType.OBJECT, string));
    }

    public List<ObjectValue> getObjects(String string) {
        return this.getValues(DataType.OBJECT, string);
    }

    public Set<String> getObjectNames() {
        return this.getKeys(DataType.OBJECT);
    }

    private Object getValue(DataType dataType, String string) {
        return this.getValue(dataType, ObjectValueImpl.getStages(string));
    }

    private Object getValue(DataType dataType, List<String> list) {
        List<Object> list2 = this.getValues(dataType, list);
        if (list2.size() > 0) {
            return list2.get(0);
        }
        return null;
    }

    private List getValues(DataType dataType, String string) {
        return this.getValues(dataType, ObjectValueImpl.getStages(string));
    }

    protected List<Object> getValues(DataType dataType, List<String> list) {
        if (list.size() == 0) {
            return Collections.emptyList();
        }
        String string = list.get(0);
        Matcher matcher = nameSplit.matcher(string);
        String string2 = "";
        int n = -1;
        if (matcher.matches()) {
            string2 = matcher.group(1);
            n = Integer.parseInt(matcher.group(2));
        } else {
            string2 = string;
        }
        if (list.size() > 1) {
            List<ObjectValue> list2 = this.getObjects(string2);
            if (n == -1) {
                Vector<Object> vector = new Vector<Object>();
                for (ObjectValue objectValue : list2) {
                    if (!(objectValue instanceof ObjectValueImpl)) continue;
                    vector.addAll(((ObjectValueImpl)ObjectValueImpl.class.cast(objectValue)).getValues(dataType, list.subList(1, list.size())));
                }
                return vector;
            }
            if (n >= 0 && n < list2.size()) {
                return ((ObjectValueImpl)ObjectValueImpl.class.cast(list2.get(n))).getValues(dataType, list.subList(1, list.size()));
            }
        } else {
            Object object = this.getHash(dataType).get(string2);
            if (object instanceof List) {
                List list3 = (List)List.class.cast(object);
                if (n == -1) {
                    return list3;
                }
                if (n >= 0 && n < list3.size()) {
                    return Collections.singletonList(list3.get(n));
                }
            }
        }
        return Collections.emptyList();
    }

    private Set<String> getKeys(DataType dataType) {
        return this.getHash(dataType).keySet();
    }

    private Map<String, Object> getHash(DataType dataType) {
        return this.hashes.get(dataType.ordinal());
    }
}

