/*
 * Decompiled with CFR 0.152.
 */
package ds.util.datatransforms;

import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import ds.core.impl.task.TaskStateAccess;
import ds.util.datatransforms.AbstractDataTransformer;
import ds.util.datatransforms.IncompleteDataException;
import ds.util.datatransforms.TaskClosure;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.w3c.dom.Document;

public abstract class DocumentTaskClosure
extends TaskClosure
implements Closure {
    protected Predicate handlesData = PredicateUtils.falsePredicate();
    private Task task;

    public DocumentTaskClosure(Task task, Closure closure) {
        super(closure);
        this.task = task;
        this.handlesData = PredicateUtils.equalPredicate((Object)task);
    }

    protected Task getTask() {
        return this.task;
    }

    public DocumentTaskClosure(final String string, Closure closure) {
        super(closure);
        this.handlesData = string == null ? PredicateUtils.truePredicate() : new Predicate(){

            public boolean evaluate(Object object) {
                if (!(object instanceof Task)) {
                    return false;
                }
                Task task = (Task)object;
                return task.getCommandName().equalsIgnoreCase(string);
            }
        };
    }

    public void execute(Object object) {
        if (object == null || !(object instanceof TaskDataAccess)) {
            return;
        }
        if (object instanceof TaskStateAccess) {
            return;
        }
        TaskDataAccess taskDataAccess = (TaskDataAccess)object;
        if (!this.handlesData.evaluate((Object)taskDataAccess.getTask())) {
            return;
        }
        if (taskDataAccess.getLocation() == null) {
            return;
        }
        this.executeDirectly(taskDataAccess);
    }

    private void executeDirectly(TaskDataAccess taskDataAccess) {
        try {
            this.handleDocument(taskDataAccess, AbstractDataTransformer.parseDocument(taskDataAccess));
        }
        catch (IncompleteDataException incompleteDataException) {
            throw incompleteDataException;
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    protected abstract void handleDocument(TaskDataAccess var1, Document var2);
}

