/*
 * Decompiled with CFR 0.152.
 */
package ds.util.datatransforms;

import ddb.dsz.core.data.ObjectValue;
import ds.util.datatransforms.transformers.BooleanTransformer;
import ds.util.datatransforms.transformers.LongTransformer;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NOPTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataType {
    OBJECT(ObjectValue.class, NOPTransformer.getInstance(), "ObjectValue"),
    STRING(String.class, NOPTransformer.getInstance(), "StringValue"),
    INTEGER(Long.class, new LongTransformer(), "IntValue", "UIntValue"),
    BOOLEAN(Boolean.class, new BooleanTransformer(), "BoolValue");

    Class<?> clazz;
    Transformer transformer;
    Predicate instanceOf;
    String[] elemName;

    private DataType(Class<?> clazz, Transformer transformer, String ... stringArray) {
        this.clazz = clazz;
        this.transformer = transformer;
        this.instanceOf = PredicateUtils.instanceofPredicate(clazz);
        this.elemName = stringArray;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public Predicate getPredicate() {
        return this.instanceOf;
    }

    public String[] getElementName() {
        return this.elemName;
    }

    public boolean isElement(String string) {
        for (String string2 : this.elemName) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static DataType getTypeForName(String string) {
        for (DataType dataType : DataType.values()) {
            for (String string2 : dataType.getElementName()) {
                if (!string2.equals(string)) continue;
                return dataType;
            }
        }
        return null;
    }
}

