/*
 * Decompiled with CFR 0.152.
 */
package ds.util.datatransforms;

import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.DataTransformer;
import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.data.TransformEvent;
import ddb.dsz.core.task.TaskId;
import ddb.util.GeneralUtilities;
import ds.util.datatransforms.DataType;
import ds.util.datatransforms.transformers.ObjectValueImpl;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataTransformsDataEvent
implements DataEvent {
    private DataEvent.DataEventType type = DataEvent.DataEventType.START;
    private DataTransformer source = null;
    StringBuilder rawText = new StringBuilder();
    StringBuilder transformedText = new StringBuilder();
    ObjectValueImpl data = new ObjectValueImpl();
    TaskId taskId = TaskId.UNINITIALIZED_ID;
    Calendar timestamp;
    String resourceDirectory;
    String display;
    String storage;
    Map<String, String> parameters;
    List<String> guiflags = new Vector<String>();

    public DataTransformsDataEvent(DataEvent.DataEventType dataEventType, DataTransformer dataTransformer, TaskId taskId) {
        this.type = dataEventType;
        this.source = dataTransformer;
        this.taskId = taskId;
    }

    public List<String> getGuiflags() {
        return this.guiflags;
    }

    public void addFlag(String string) {
        this.guiflags.add(string);
    }

    public DataTransformer getSource() {
        return this.source;
    }

    public void setSource(DataTransformer dataTransformer) {
        this.source = dataTransformer;
    }

    public void setParameters(String string, String string2, String string3, Map<String, String> map) {
        this.display = string;
        this.storage = string2;
        this.resourceDirectory = string3;
        this.parameters = map;
    }

    public TransformEvent.TransformEventType getType() {
        return TransformEvent.TransformEventType.DATA;
    }

    public DataEvent.DataEventType getDataType() {
        return this.type;
    }

    void setType(DataEvent.DataEventType dataEventType) {
        this.type = dataEventType;
    }

    public void addTransformedText(String string) {
        this.transformedText.append(string);
    }

    public void addObject(String string, ObjectValue objectValue) {
        this.data.addValue(DataType.OBJECT, string, objectValue);
    }

    public String getTransformedText() {
        return this.transformedText.toString();
    }

    public String getRawText() {
        return this.rawText.toString();
    }

    public ObjectValue getData() {
        return this.data;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public void setTaskId(TaskId taskId) {
        this.taskId = taskId;
    }

    public Calendar getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String string) {
        this.timestamp = GeneralUtilities.stringToCalendar((String)string, (Calendar)this.timestamp);
    }

    public String getDisplay() {
        return this.display;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getStorage() {
        return this.storage;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }
}

