/*
 * Decompiled with CFR 0.152.
 */
package ds.plugin.replay;

import ddb.util.AbstractEnumeratedTableModel;
import ds.core.commanddispatcher.ObserveOngoingOperationCommandDispatcher;
import ds.core.commanddispatcher.ReplayCommandDispatcher;
import ds.core.controller.MutableCoreController;
import ds.plugin.replay.ReplayTableModelColumns;
import java.io.File;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayTableModel
extends AbstractEnumeratedTableModel<ReplayTableModelColumns> {
    private static final ReplayTableModel model = new ReplayTableModel();
    private Predicate alreadyLookedAt = PredicateUtils.notPredicate((Predicate)PredicateUtils.uniquePredicate());
    final List<OperationMetaData> replayOptions = new Vector<OperationMetaData>();
    MutableCoreController mcc = null;
    boolean autoLoad;
    boolean stop = false;

    public static ReplayTableModel getReplayModel() {
        return model;
    }

    private ReplayTableModel() {
        super(ReplayTableModelColumns.class);
    }

    public int getRowCount() {
        return this.replayOptions.size();
    }

    public Object getValueAt(int n, ReplayTableModelColumns replayTableModelColumns) {
        if (n < 0 || n > this.replayOptions.size()) {
            return null;
        }
        OperationMetaData operationMetaData = this.replayOptions.get(n);
        switch (replayTableModelColumns) {
            case FILE: {
                return operationMetaData.file;
            }
            case GUID: {
                if (operationMetaData.dispatcher == null) {
                    return null;
                }
                return operationMetaData.dispatcher.getOperation().getGuid();
            }
            case START: {
                if (operationMetaData.dispatcher == null) {
                    return null;
                }
                return operationMetaData.dispatcher.getOperation().getStartTime();
            }
            case LOADED: {
                return operationMetaData.loaded;
            }
        }
        return null;
    }

    public String getColumnName(ReplayTableModelColumns replayTableModelColumns) {
        return replayTableModelColumns.getName();
    }

    public Class<?> getColumnClass(ReplayTableModelColumns replayTableModelColumns) {
        return replayTableModelColumns.getClazz();
    }

    public boolean isCellEditable(int n, ReplayTableModelColumns replayTableModelColumns) {
        if (n < 0 || n > this.replayOptions.size()) {
            return false;
        }
        OperationMetaData operationMetaData = this.replayOptions.get(n);
        switch (replayTableModelColumns) {
            case LOADED: {
                return operationMetaData.loaded == false;
            }
        }
        return false;
    }

    public void setValueAt(Object object, int n, ReplayTableModelColumns replayTableModelColumns) {
        if (n < 0 || n > this.replayOptions.size() || !ReplayTableModelColumns.LOADED.equals((Object)replayTableModelColumns)) {
            return;
        }
        OperationMetaData operationMetaData = this.replayOptions.get(n);
        if (operationMetaData.loaded.booleanValue()) {
            return;
        }
        if (object.equals(Boolean.TRUE)) {
            operationMetaData.loaded = Boolean.TRUE;
            if (this.mcc != null) {
                this.mcc.newThread(new OperationHandler(operationMetaData.dispatcher)).start();
            } else {
                Thread thread = new Thread(new OperationHandler(operationMetaData.dispatcher));
                thread.setPriority(1);
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    public void setCoreController(MutableCoreController mutableCoreController) {
        this.mcc = mutableCoreController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(File file) {
        if (file == null) {
            return;
        }
        int n = -1;
        ReplayTableModel replayTableModel = this;
        synchronized (replayTableModel) {
            if (this.alreadyLookedAt.evaluate((Object)file)) {
                return;
            }
            OperationMetaData operationMetaData = new OperationMetaData();
            operationMetaData.file = file;
            operationMetaData.loaded = false;
            operationMetaData.dispatcher = this.mcc.isLiveOperation() ? new ReplayCommandDispatcher(this.mcc.getDispatcherClient(), this.mcc, file) : new ObserveOngoingOperationCommandDispatcher(this.mcc.getDispatcherClient(), this.mcc, file);
            if (operationMetaData.dispatcher.getOperation() == null) {
                return;
            }
            if (!this.mcc.getDispatcherClient().addReplayCommandDispatcher(operationMetaData.dispatcher)) {
                return;
            }
            n = this.replayOptions.size();
            this.replayOptions.add(n, operationMetaData);
        }
        this.fireTableRowsInserted(n, n);
        if (this.isAutoLoad()) {
            this.setValueAt(Boolean.TRUE, n, ReplayTableModelColumns.LOADED.ordinal());
        }
    }

    public boolean isAutoLoad() {
        return this.autoLoad;
    }

    public void setAutoLoad(boolean bl) {
        this.autoLoad = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStop() {
        this.stop = true;
        List<OperationMetaData> list = this.replayOptions;
        synchronized (list) {
            for (OperationMetaData operationMetaData : this.replayOptions) {
                operationMetaData.dispatcher.stop();
            }
        }
    }

    private class OperationMetaData {
        public File file;
        public Boolean loaded;
        public ReplayCommandDispatcher dispatcher;

        private OperationMetaData() {
        }
    }

    private class OperationHandler
    implements Runnable {
        ReplayCommandDispatcher dispatcher;
        long lastSize = 0L;

        public OperationHandler(ReplayCommandDispatcher replayCommandDispatcher) {
            this.dispatcher = replayCommandDispatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this.dispatcher == null) {
                    return;
                }
                while (!this.dispatcher.isFinished()) {
                    long l = this.dispatcher.getFileSize();
                    if (l > this.lastSize) {
                        try {
                            this.dispatcher.parseFile();
                            this.lastSize = l;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                System.out.println("finished dispatcher");
            }
        }
    }
}

