/*
 * Decompiled with CFR 0.152.
 */
package ds.plugin.peer;

import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.plugin.peer.PeerTag;
import ddb.dsz.plugin.peer.PeerTransferStatus;
import ds.plugin.peer.Peer;
import ds.plugin.peer.PeerSocketHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Socket;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.ClosureUtils;

@DszLogo(value="images/kwallet2.png")
@DszName(value="Peer")
@DszDescription(value="Handles communication between this computer and a Peer")
public class PeerClient
extends Peer {
    JLabel label = new JLabel("Address:");
    JTextField field = new JTextField("localhost:0");
    JButton connect = new JButton("Connect");
    PeerSocketHandler socketHandler = null;
    Closure closure = ClosureUtils.nopClosure();
    JLabel connectedTo = new JLabel("");

    protected JComponent designTop() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)this.connectedTo, "East");
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.add((Component)this.label, "West");
        jPanel2.add((Component)this.field, "Center");
        jPanel2.add((Component)this.connect, "East");
        this.connect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PeerClient.this.pending();
                PeerClient.this.core.submit(new Runnable(){

                    public void run() {
                        if (PeerClient.this.socketHandler == null || !PeerClient.this.socketHandler.isConnected()) {
                            String[] stringArray = PeerClient.this.field.getText().split(":");
                            String string = "localhost";
                            int n = 0;
                            if (stringArray.length == 1) {
                                n = Integer.parseInt(stringArray[0]);
                            } else {
                                string = stringArray[0];
                                n = Integer.parseInt(stringArray[1]);
                            }
                            try {
                                System.out.printf("Connecting to %s:%d\n", string, n);
                                PeerClient.this.socketHandler = new PeerSocketHandler(PeerClient.this.core, new Socket(string, n), PeerClient.this);
                                PeerClient.this.socketHandler.begin("Replay Peer");
                                PeerClient.this.mcc.firePeerConnected(PeerClient.this.socketHandler);
                                PeerClient.this.connected();
                            }
                            catch (Exception exception) {
                                PeerClient.this.disconnected();
                            }
                        } else {
                            PeerClient.this.socketHandler.stop();
                            PeerClient.this.socketHandler = null;
                            PeerClient.this.disconnected();
                        }
                    }
                });
            }
        });
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "PeerClient"));
        return jPanel;
    }

    void pending() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                PeerClient.this.connect.setEnabled(false);
                PeerClient.this.field.setEditable(false);
            }
        });
    }

    void connected() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                PeerClient.this.connect.setText("Disconnect");
                PeerClient.this.connect.setEnabled(true);
                PeerClient.this.field.setEditable(false);
            }
        });
    }

    void disconnected() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                PeerClient.this.connect.setText("Connect");
                PeerClient.this.connectedTo.setText("");
                PeerClient.this.connect.setEnabled(true);
                PeerClient.this.field.setEditable(true);
            }
        });
    }

    public PeerTransferStatus sendMessage(String string, PeerTag peerTag) {
        if (peerTag != this.socketHandler && peerTag != null) {
            return PeerTransferStatus.DESTINATION_NOT_FOUND;
        }
        if (this.socketHandler == null) {
            return PeerTransferStatus.DISCONNECTED;
        }
        return this.socketHandler.sendMessage(string);
    }

    public void connectionUpdated(final PeerSocketHandler peerSocketHandler) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                PeerClient.this.connectedTo.setText("Connected to:" + peerSocketHandler.getPeerName());
            }
        });
    }

    public void connectionStopping(PeerTag peerTag) {
        this.disconnected();
        super.connectionStopping(peerTag);
    }
}

