/*
 * Decompiled with CFR 0.152.
 */
package ds.core.impl.task;

import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.util.FileManips;
import ds.core.impl.task.AbstractDataAccess;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FileAccess
extends AbstractDataAccess
implements TaskDataAccess {
    final File file;
    final String relativeLocation;
    long length = -1L;

    public FileAccess(Task task, TaskDataAccess.DataType dataType, File file, String string, int n) {
        super(task, dataType, n);
        this.file = file;
        this.relativeLocation = string;
    }

    public InputStreamReader getReader() {
        try {
            return FileManips.createFileReader((File)this.file);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    public InputStream getStream() {
        try {
            return FileManips.createFileStream((File)this.file);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public long getSize() {
        if (this.length < 0L) {
            this.length = this.file.length();
        }
        return this.length;
    }

    public String toString() {
        if (this.file == null) {
            return "null";
        }
        return String.format("File:  %s", this.file.getAbsolutePath());
    }

    public String getLocation() {
        if (this.file == null) {
            return "";
        }
        return this.file.getAbsolutePath();
    }

    public String getLocationType() {
        return "File";
    }

    public String getRelativeLocation() {
        return this.relativeLocation;
    }

    public File getFile() {
        return this.file;
    }
}

