/*
 * Decompiled with CFR 0.152.
 */
package ds.core.impl;

import ddb.dsz.core.operation.MutableOperation;
import ddb.dsz.core.operation.Operation;
import ddb.util.Guid;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public class OperationImpl
implements Operation,
MutableOperation {
    private static final List<OperationImpl> ALL_CREATED_OPERATIONS = new ArrayList<OperationImpl>();
    private final Guid guid;
    private final long startTime;
    private long lastTime = 0L;

    public static OperationImpl GenerateOperation(Guid guid) {
        return OperationImpl.GenerateOperation(guid, Calendar.getInstance());
    }

    public static synchronized OperationImpl GenerateOperation(Guid guid, Calendar calendar) {
        return OperationImpl.GenerateOperation(guid, calendar.getTimeInMillis());
    }

    public static synchronized OperationImpl GenerateOperation(Guid guid, long l) {
        OperationImpl operationImpl = new OperationImpl(guid, l);
        int n = Collections.binarySearch(ALL_CREATED_OPERATIONS, operationImpl);
        if (n >= 0) {
            return ALL_CREATED_OPERATIONS.get(n);
        }
        ++n;
        if ((n = 0 - n) < ALL_CREATED_OPERATIONS.size()) {
            ALL_CREATED_OPERATIONS.add(n, operationImpl);
        } else {
            ALL_CREATED_OPERATIONS.add(operationImpl);
        }
        return operationImpl;
    }

    private OperationImpl(Guid guid, Calendar calendar) {
        this.guid = guid;
        this.startTime = calendar.getTimeInMillis();
    }

    private OperationImpl(Guid guid, long l) {
        this.guid = guid;
        this.startTime = l;
    }

    public Guid getGuid() {
        return this.guid;
    }

    public void setLastTime(Calendar calendar) {
        long l = calendar.getTimeInMillis();
        if (l > this.lastTime) {
            this.lastTime = l;
        }
    }

    public Calendar getStartTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.startTime);
        return calendar;
    }

    public Calendar getLastTime() {
        if (this.lastTime == 0L) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.lastTime);
        return calendar;
    }

    public int compareTo(Operation operation) {
        if (this == operation) {
            return 0;
        }
        if (operation == null) {
            return 1;
        }
        return this.guid.compareTo(operation.getGuid());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof Operation) {
            Operation operation = (Operation)object;
            return this.guid.equals((Object)operation.getGuid());
        }
        return false;
    }

    public int hashCode() {
        int n = 3;
        n = 37 * n + (this.guid != null ? this.guid.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "Operation:  " + this.guid.toString();
    }
}

