/*
 * Decompiled with CFR 0.152.
 */
package ds.core.impl;

import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.host.MutableHostInfo;
import ddb.dsz.core.task.TaskId;
import java.util.Calendar;

public class HostInfoImpl
implements MutableHostInfo {
    private boolean local;
    private boolean connected;
    private String id;
    private String hostname;
    private String version;
    private String platform;
    private String implantType;
    private String arch;
    private long modified;
    private TaskId task;

    public HostInfoImpl(String string, boolean bl) {
        this(string, "unknown", "unknown", "unknown", "unknown", "unknown", bl, false);
    }

    public HostInfoImpl(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2) {
        this.hostname = string2;
        this.version = string3;
        this.platform = string5;
        this.implantType = string6;
        this.arch = string4;
        this.local = bl;
        this.id = string;
        this.connected = bl2;
        this.modified = Calendar.getInstance().getTimeInMillis();
    }

    public HostInfoImpl(String string, String string2, String string3, String string4) {
        this(string, "unknown", string2, null, string3, string4, false, true);
    }

    public TaskId getTask() {
        return this.task;
    }

    public void setTask(TaskId taskId) {
        this.task = taskId;
    }

    public String getImplantType() {
        return this.implantType;
    }

    public String getId() {
        return this.id;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getVersion() {
        return this.version;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void copyFromHost(HostInfo hostInfo) {
        if (hostInfo == null) {
            return;
        }
        this.arch = hostInfo.getArch();
        this.implantType = hostInfo.getImplantType();
        this.platform = hostInfo.getPlatform();
        this.version = hostInfo.getVersion();
        this.connected = hostInfo.isConnected();
        this.modified = hostInfo.getModifiedTime().getTimeInMillis();
    }

    public boolean sameHost(HostInfo hostInfo) {
        if (hostInfo == null) {
            return false;
        }
        if (this.id == null && hostInfo.getId() == null) {
            return true;
        }
        if (this.id != null && hostInfo.getId() != null) {
            return this.id.equals(hostInfo.getId());
        }
        return false;
    }

    public String toString() {
        return String.format("HostInfo[id=%s]", this.id);
    }

    public Calendar getModifiedTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.modified);
        return calendar;
    }

    public void setArch(String string) {
        this.arch = string;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setImplantType(String string) {
        this.implantType = string;
    }

    public void setLocal(boolean bl) {
        this.local = bl;
    }

    public void setPlatform(String string) {
        this.platform = string;
    }

    public void setModified(Calendar calendar) {
        this.modified = calendar.getTimeInMillis();
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int compareTo(HostInfo hostInfo) {
        return HostInfo.COMPARE.compare(this, hostInfo);
    }
}

