/*
 * Decompiled with CFR 0.152.
 */
package ds.core.controller;

import ddb.CheckThreadViolationRepaintManager;
import ddb.actions.tabnav.NavigationDirection;
import ddb.actions.tabnav.NavigationListener;
import ddb.detach.Alignment;
import ddb.detach.TabNavigationListener;
import ddb.detach.Workbench;
import ddb.dsz.core.command.CommandEventListener;
import ddb.dsz.core.connection.ConnectionChangeEvent;
import ddb.dsz.core.connection.ConnectionChangeListener;
import ddb.dsz.core.connection.events.DisconnectEvent;
import ddb.dsz.core.connection.events.LpTerminatedEvent;
import ddb.dsz.core.connection.events.NewHostEvent;
import ddb.dsz.core.connection.events.StatisticsEvent;
import ddb.dsz.core.connection.events.ThrottleEvent;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.internalcommand.InternalCommandCallback;
import ddb.dsz.core.internalcommand.InternalCommandHandler;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.MutableTask;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.Plugin;
import ddb.dsz.plugin.peer.PeerReceiver;
import ddb.dsz.plugin.peer.PeerTag;
import ddb.dsz.plugin.peer.PeerTransferStatus;
import ddb.util.BlockingInputStream;
import ddb.util.GeneralUtilities;
import ddb.util.Guid;
import ddb.util.KeybindingConfigParser;
import ddb.util.PluginInitInfo;
import ddb.util.SplitPrintStream;
import ddb.util.UtilityConstants;
import ddb.util.XMLException;
import ds.core.ConfigurationStore;
import ds.core.DSClient;
import ds.core.DSConstants;
import ds.core.PopupPromptWindow;
import ds.core.StatusBar;
import ds.core.UserManager;
import ds.core.commanddispatcher.MultipleCommandDispatcherClient;
import ds.core.controller.MutableCoreController;
import ds.core.impl.HostInfoImpl;
import ds.core.impl.OperationImpl;
import ds.core.impl.task.TaskDatabase;
import ds.core.impl.task.TaskImpl;
import ds.core.internalcommands.InternalCommandCallbackAdapter;
import ds.core.pluginevents.PluginEvent;
import ds.core.pluginevents.PluginEventListener;
import ds.gui.PluginWorkbench;
import ds.plugin.peer.Peer;
import ds.plugin.replay.ReplayTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCoreController
implements CoreController,
MutableCoreController {
    RepaintManager repaintManager;
    private PluginWorkbench workbench;
    private EventListenerList listeners = new EventListenerList();
    private String opDir = ".";
    private String logDir = ".";
    private String resourceDir = ".";
    private String buildType = "release";
    private String userConfigDir;
    private ConfigurationStore configurationStore;
    protected ScheduledThreadPoolExecutor executor;
    protected Logger systemLogger;
    protected MultipleCommandDispatcherClient dispatcherClient;
    private boolean debug = false;
    private StatusBar statusBar;
    private JComponent mainWidget;
    private JMenuBar menuBar;
    private JFrame ownerFrame;
    private final Map<Task, PopupPromptWindow> taskToPrompt = new HashMap<Task, PopupPromptWindow>();
    private final List<MutableTask> allTasks = new Vector<MutableTask>();
    private final Map<Integer, MutableTask> taskByTempId = new HashMap<Integer, MutableTask>();
    protected final List<PluginInitInfo> autoloadPlugins = new Vector<PluginInitInfo>();
    protected final UserManager userManager;
    String[] ResourceDirectories = null;
    private final Map<Guid, Operation> opById = new HashMap<Guid, Operation>();
    protected Peer mPeer = null;
    private String localhostAddress = "127.0.0.1";
    private static final FilloutPattern[] fillouts = new FilloutPattern[]{new FilloutPattern("[Zz]?([0-9]+)", "z0.0.0."), new FilloutPattern("[Zz]?([0-9]+\\.[0-9]+)", "z0.0."), new FilloutPattern("[Zz]?([0-9]+\\.[0-9]+\\.[0-9]+)", "z0."), new FilloutPattern("([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+)", "z")};
    protected final List<HostInfo> hosts = Collections.synchronizedList(new Vector());
    protected final Pattern localHostPattern = Pattern.compile("\\s*127\\.\\d*.\\d*.\\d*|localhost|0*1|[Zz]?0\\.0\\.0\\.1");
    protected String title = null;
    protected String userTitle = null;
    protected boolean fullStop = false;
    private int count = 0;
    Map<KeyStroke, String> keybindings = null;

    public void setRepaintManager(RepaintManager repaintManager) {
        this.repaintManager = repaintManager;
        if (this.repaintManager instanceof CheckThreadViolationRepaintManager) {
            ((CheckThreadViolationRepaintManager)CheckThreadViolationRepaintManager.class.cast(this.repaintManager)).setEnableChecking(this.debug);
        }
    }

    public AbstractCoreController(String[] stringArray) {
        this.parseArgs(stringArray);
        try {
            TaskImpl.DATABASE = new TaskDatabase(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread thread, Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    LogRecord logRecord = new LogRecord(Level.SEVERE, throwable.getMessage());
                    logRecord.setLoggerName("UncaughtExceptionHandler");
                    logRecord.setSourceMethodName("...");
                    logRecord.setSourceClassName("...");
                    logRecord.setThrown(throwable);
                    if (AbstractCoreController.this.systemLogger != null) {
                        AbstractCoreController.this.systemLogger.log(logRecord);
                    } else {
                        Logger.getLogger("ds.core");
                    }
                }
                catch (Throwable throwable2) {
                    throwable2.printStackTrace();
                }
            }
        });
        try {
            Calendar calendar = Calendar.getInstance();
            File file = new File(this.getUserConfigDirectory(), String.format("Output-%s", GeneralUtilities.CalendarToStringFile((Calendar)calendar)));
            file.mkdirs();
            SplitPrintStream splitPrintStream = new SplitPrintStream(new PrintStream[]{System.out, new PrintStream(new File(file, "out"))});
            SplitPrintStream splitPrintStream2 = new SplitPrintStream(new PrintStream[]{System.err, new PrintStream(new File(file, "err"))});
            System.setOut((PrintStream)splitPrintStream);
            System.setErr((PrintStream)splitPrintStream2);
        }
        catch (Throwable throwable) {
            this.logEvent(Level.WARNING, "Failed to redirect output", throwable);
        }
        DSConstants.addLibraryPath(String.format("%s/ExternalLibraries/%s", this.getResourceDirectory(), DSConstants.getOsString()));
        this.executor = new ScheduledThreadPoolExecutor(15, UtilityConstants.createThreadFactory((String)"DSZ Core Thread"));
        this.executor.setMaximumPoolSize(50);
        this.dispatcherClient = new MultipleCommandDispatcherClient(this);
        ReplayTableModel.getReplayModel().setCoreController(this);
        this.userManager = new UserManager(this);
        this.schedule(new Runnable(){

            public void run() {
                String[] stringArray;
                for (String string : stringArray = new String[]{System.getenv("TEMP"), System.getenv("TMP")}) {
                    if (string == null) continue;
                    File file = new File(string);
                    for (File file2 : file.listFiles(new FilenameFilter(){

                        public boolean accept(File file, String string) {
                            return string.matches("\\+~JF[0-9]+\\.tmp");
                        }
                    })) {
                        try {
                            file2.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }, 2L, TimeUnit.MINUTES);
    }

    public List<String> getUserAliases(HostInfo hostInfo) {
        return this.userManager.usersByHost(hostInfo);
    }

    public final void initialize() {
        this.workbench = new PluginWorkbench(this, null, 1);
        this.workbench.setSelected(true);
        this.workbench.setAllowWrap(true);
        this.statusBar = new StatusBar();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)((Object)this.workbench), "Center");
        jPanel.add((Component)this.statusBar, "South");
        this.mainWidget = jPanel;
        NavigationDirection.fill((NavigationListener)new TabNavigationListener(), (ActionMap)jPanel.getActionMap());
        jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(37, 128), NavigationDirection.PREVIOUS.getName());
        jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(39, 128), NavigationDirection.NEXT.getName());
        this.menuBar = new JMenuBar();
        this.initialize2();
    }

    protected void initialize2() {
    }

    public void createDirectoryMonitor() {
        this.dispatcherClient.addDirectoryMonitor(new File(this.getLogDir()));
    }

    protected final void parseArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].lastIndexOf(61);
            if (n == -1) continue;
            String string = stringArray[i].substring(0, n);
            String string2 = stringArray[i].substring(n + 1);
            this.parseArg(string, string2);
        }
    }

    protected void parseArg(String string, String string2) {
        if (string.equals("-opDir")) {
            this.setOpDir(string2);
        } else if (string.equals("-logDir")) {
            this.setLogDir(string2);
        } else if (string.equals("-comms")) {
            this.localhostAddress = string2;
        } else if (string.equals("-resourceDir")) {
            this.setResourceDir(string2);
        } else if (string.equals("-config")) {
            this.setUserConfigDirectory(string2);
        } else if (string.equals("-debug")) {
            this.debug = Boolean.parseBoolean(string2);
        } else if (string.equals("-threadDump") && string2.equals("true")) {
            this.newThread("Thread Dump", new Runnable(){

                public void run() {
                    new File("Thread.dump").delete();
                    int n = 0;
                    while (true) {
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream("Thread.dump", true);
                            PrintStream printStream = new PrintStream(fileOutputStream);
                            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
                            printStream.println("-------------------------------------------------------------");
                            printStream.println(String.format("Thread Dump #%d", n++));
                            printStream.println("-------------------------------------------------------------");
                            int n2 = 0;
                            for (Thread thread : map.keySet()) {
                                printStream.println(String.format("Thread %d: %s (%s)", n2++, thread.getName(), thread.getState().toString()));
                                StackTraceElement[] stackTraceElementArray = map.get(thread);
                                int n3 = 0;
                                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                                    printStream.println(String.format("\t%02d: %s:%s (%s: %d)", n3++, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber()));
                                }
                            }
                            printStream.close();
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        try {
                            TimeUnit.SECONDS.sleep(300L);
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            }).start();
        }
    }

    public void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public void addPluginEventListener(PluginEventListener pluginEventListener) {
        this.logEvent(Level.FINEST, "Registering PluginEventListener: " + pluginEventListener.toString());
        this.listeners.add(PluginEventListener.class, pluginEventListener);
    }

    @Override
    public void removePluginEventListener(PluginEventListener pluginEventListener) {
        this.logEvent(Level.FINEST, "Registering PluginEventListener: " + pluginEventListener.toString());
        this.listeners.remove(PluginEventListener.class, pluginEventListener);
    }

    protected void firePluginEvent(PluginEvent pluginEvent) {
        PluginEventListener[] pluginEventListenerArray;
        for (PluginEventListener pluginEventListener : pluginEventListenerArray = (PluginEventListener[])this.listeners.getListeners(PluginEventListener.class)) {
            try {
                pluginEventListener.pluginEvent(pluginEvent);
            }
            catch (Throwable throwable) {
                this.logEvent(Level.WARNING, "Unable to properly report plugin events", throwable);
            }
        }
    }

    public void addConnectionChangeListener(ConnectionChangeListener connectionChangeListener) {
        this.logEvent(Level.FINEST, "Registering ConnectionChangeListener: " + connectionChangeListener.toString());
        this.listeners.add(ConnectionChangeListener.class, connectionChangeListener);
    }

    public void removeConnectionChangeListener(ConnectionChangeListener connectionChangeListener) {
        this.logEvent(Level.FINEST, "Unregistering ConnectionChangeListener: " + connectionChangeListener.toString());
        this.listeners.remove(ConnectionChangeListener.class, connectionChangeListener);
    }

    protected void fireConnectionChangeEvent(ConnectionChangeEvent connectionChangeEvent) {
        ConnectionChangeListener[] connectionChangeListenerArray;
        for (ConnectionChangeListener connectionChangeListener : connectionChangeListenerArray = (ConnectionChangeListener[])this.listeners.getListeners(ConnectionChangeListener.class)) {
            try {
                connectionChangeListener.connectionChanged(connectionChangeEvent);
            }
            catch (Throwable throwable) {
                this.logEvent(Level.WARNING, "Unable to properly report connection change events", throwable);
            }
        }
    }

    protected void fireStatisticsChanged(StatisticsEvent statisticsEvent) {
        ConnectionChangeListener[] connectionChangeListenerArray;
        for (ConnectionChangeListener connectionChangeListener : connectionChangeListenerArray = (ConnectionChangeListener[])this.listeners.getListeners(ConnectionChangeListener.class)) {
            try {
                connectionChangeListener.connectionChanged((ConnectionChangeEvent)statisticsEvent);
            }
            catch (Throwable throwable) {
                this.logEvent(Level.WARNING, "Unable to properly report statistics events", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConnectionNewHost(HostInfo hostInfo) {
        List<MutableTask> list = this.allTasks;
        synchronized (list) {
            for (MutableTask mutableTask : this.allTasks) {
                try {
                    if (mutableTask.getHost() == null || !mutableTask.getHost().getId().equals(hostInfo.getId())) continue;
                    mutableTask.setHost(hostInfo);
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                }
            }
        }
        this.fireConnectionChangeEvent((ConnectionChangeEvent)new NewHostEvent((Object)this, hostInfo));
    }

    protected void fireDisconnectedHost(HostInfo hostInfo) {
        this.fireConnectionChangeEvent((ConnectionChangeEvent)new DisconnectEvent((Object)this, hostInfo));
    }

    @Override
    public void fireThrottleEvent(ThrottleEvent throttleEvent) {
        this.fireConnectionChangeEvent((ConnectionChangeEvent)throttleEvent);
    }

    @Override
    public MultipleCommandDispatcherClient getDispatcherClient() {
        return this.dispatcherClient;
    }

    @Override
    public void setDispatcherClient(MultipleCommandDispatcherClient multipleCommandDispatcherClient) {
        this.dispatcherClient = multipleCommandDispatcherClient;
    }

    public void addCommandEventListener(final CommandEventListener commandEventListener) {
        this.logEvent(Level.FINEST, "Registering CommandEventListener: " + commandEventListener.toString());
        this.dispatcherClient.addCommandEventListener(commandEventListener);
        this.submit(new Runnable(){

            public void run() {
                AbstractCoreController.this.dispatcherClient.repeatTasks(commandEventListener);
            }
        });
    }

    public void removeCommandEventListener(CommandEventListener commandEventListener) {
        this.logEvent(Level.FINEST, "Unregistering CommandEventListener: " + commandEventListener.toString());
        this.dispatcherClient.removeCommandEventListener(commandEventListener);
    }

    @Override
    public void lpConnectionTerminated() {
        this.fireConnectionChangeEvent((ConnectionChangeEvent)new LpTerminatedEvent((Object)this));
    }

    public void addInternalCommandHandler(InternalCommandHandler internalCommandHandler) {
        this.logEvent(Level.FINEST, "Registering InternalCommandHandler: " + internalCommandHandler.toString());
        this.listeners.add(InternalCommandHandler.class, internalCommandHandler);
    }

    public void removeInternalCommandHandler(InternalCommandHandler internalCommandHandler) {
        this.logEvent(Level.FINEST, "Unregistering InternalCommandHandler: " + internalCommandHandler.toString());
        this.listeners.remove(InternalCommandHandler.class, internalCommandHandler);
    }

    public boolean internalCommand(InternalCommandCallback internalCommandCallback, List<String> list) {
        return this.internalCommand(internalCommandCallback, null, list);
    }

    public void sendGuiCommandResponse(int n, boolean bl) {
        this.dispatcherClient.sendGuiCommandResponse(n, bl);
    }

    public boolean internalCommand(InternalCommandCallback internalCommandCallback, TaskId taskId, List<String> list) {
        Level level = Level.INFO;
        if (taskId != null) {
            this.logEvent(level, String.format("Command %d has issued a command:  '%s'", taskId.getId(), list.size() > 0 ? list.get(0) : "unknown"));
        } else {
            this.logEvent(level, String.format("Command Issued:  '%s'", list.size() > 0 ? list.get(0) : "unknown"));
        }
        if (internalCommandCallback == null) {
            internalCommandCallback = InternalCommandCallbackAdapter.INSTANCE;
        }
        InternalCommandHandler[] internalCommandHandlerArray = (InternalCommandHandler[])this.listeners.getListeners(InternalCommandHandler.class);
        for (int i = internalCommandHandlerArray.length - 1; i >= 0; --i) {
            if (taskId == null) {
                if (!internalCommandHandlerArray[i].runInternalCommand(list, internalCommandCallback)) continue;
                this.logEvent(level, String.format("Command '%s' succeeded on '%s'", list, internalCommandHandlerArray[i].toString()));
                return true;
            }
            if (!internalCommandHandlerArray[i].runInternalCommand(list, taskId, internalCommandCallback)) continue;
            this.logEvent(level, String.format("Command '%s' succeeded on '%s'", list.size() > 0 ? list.get(0) : "unknown", internalCommandHandlerArray[i].toString()));
            return true;
        }
        this.logEvent(level, String.format("Command '%s' not handled", list.size() > 0 ? list.get(0) : "unknown"));
        return false;
    }

    public boolean internalCommand(InternalCommandCallback internalCommandCallback, String ... stringArray) {
        return this.internalCommand(internalCommandCallback, Arrays.asList(stringArray));
    }

    public void pluginStarted(Plugin plugin) {
        this.firePluginEvent(new PluginEvent(plugin, PluginEvent.PluginEventState.START));
    }

    public void pluginStopped(Plugin plugin) {
        this.firePluginEvent(new PluginEvent(plugin, PluginEvent.PluginEventState.STOP));
    }

    public void setLogDir(String string) {
        this.logDir = new File(string).getAbsolutePath();
    }

    public String getLogDir() {
        return this.logDir;
    }

    public void setResourceDir(String string) {
        this.resourceDir = new File(string).getAbsolutePath();
    }

    public String getLogDirectory() {
        return this.logDir;
    }

    public String getResourceDirectory() {
        return this.resourceDir;
    }

    public String getUserConfigDirectory() {
        return this.userConfigDir;
    }

    public void setBuildType(String string) {
        this.buildType = string;
    }

    public String getBuildType() {
        return this.buildType;
    }

    public void setUserConfigDirectory(String string) {
        this.userConfigDir = new File(string).getAbsolutePath();
    }

    public String getOpDir() {
        return this.opDir;
    }

    public void setOpDir(String string) {
        this.opDir = string;
    }

    public ConfigurationStore getConfigurationStore() {
        if (this.configurationStore == null) {
            this.configurationStore = new ConfigurationStore(this.userConfigDir, (CoreController)this);
        }
        return this.configurationStore;
    }

    public void saveUserConfig() {
        this.getConfigurationStore().commitSettings();
    }

    public void setOption(Class<? extends Plugin> clazz, String string, Object object) {
        this.getConfigurationStore().setOption(clazz, string, object);
    }

    public void setOption(Plugin plugin, String string, Object object) {
        this.getConfigurationStore().setOption(plugin, string, object);
    }

    public Object getOption(Class<? extends Plugin> clazz, String string) {
        return this.getOption(clazz, string, null);
    }

    public Object getOption(Plugin plugin, String string) {
        return this.getOption(plugin, string, null);
    }

    public Object getOption(Class<? extends Plugin> clazz, String string, Object object) {
        Object object2 = this.getConfigurationStore().getOption(clazz, string);
        if (object2 == null) {
            return object;
        }
        return object2;
    }

    public Object getOption(Plugin plugin, String string, Object object) {
        Object object2 = this.getConfigurationStore().getOption(plugin, string);
        if (object2 == null) {
            return object;
        }
        return object2;
    }

    public void setObject(Class<? extends Plugin> clazz, String string, Serializable serializable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            this.setOption(clazz, string, (Object)byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            this.logEvent(Level.WARNING, "Unable to save theme", throwable);
        }
    }

    public void setObject(Plugin plugin, String string, Serializable serializable) {
        this.setObject(plugin.getClass(), string, serializable);
    }

    public <E extends Serializable> E getObject(Class<? extends Plugin> clazz, String string, Class<? extends E> clazz2) {
        Object object = this.getOption(clazz, string);
        if (object instanceof byte[]) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])byte[].class.cast(object));
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                Object object2 = objectInputStream.readObject();
                if (clazz2.isInstance(object2)) {
                    return (E)((Serializable)clazz2.cast(object2));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        return null;
    }

    public <E extends Serializable> E getObject(Plugin plugin, String string, Class<? extends E> clazz) {
        return this.getObject(plugin.getClass(), string, clazz);
    }

    public void commitSettings() {
        this.getConfigurationStore().commitSettings();
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
        return this.executor.schedule(callable, l, timeUnit);
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        return this.executor.schedule(runnable, l, timeUnit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        return this.executor.scheduleAtFixedRate(runnable, l, l2, timeUnit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        return this.executor.scheduleWithFixedDelay(runnable, l, l2, timeUnit);
    }

    public <T> Future<T> submit(Callable<T> callable) {
        return this.executor.submit(callable);
    }

    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.executor.submit(runnable, t);
    }

    public Future<?> submit(Runnable runnable) {
        return this.executor.submit(runnable);
    }

    public Operation getOperation() {
        return Operation.NULL;
    }

    @Override
    public void offerOperation(Operation operation) {
    }

    public synchronized Thread newThread(Runnable runnable) {
        return this.newThread(String.format("Thread %d", this.count++), runnable);
    }

    public synchronized Thread newThread(String string, Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.setName(string);
        return thread;
    }

    public final void logEvent(Level level, String string) {
        this.logEvent(level, null, string, null);
    }

    public final void logEvent(Level level, String string, String string2) {
        this.logEvent(level, string, string2, null);
    }

    public final void logEvent(Level level, String string, Throwable throwable) {
        this.logEvent(level, null, string, throwable);
    }

    public final void logEvent(Level level, String string, String string2, Throwable throwable) {
        if (level.intValue() >= Level.WARNING.intValue()) {
            System.out.printf("%s:  %s\n", level, string2);
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
        LogRecord logRecord = new LogRecord(level, string2);
        if (this.isDebugMode() || level.intValue() >= Level.WARNING.intValue()) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            for (int i = 2; i < stackTraceElementArray.length; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                boolean bl = false;
                for (String string3 : new String[]{"logEvent", "invoke0", "invoke"}) {
                    if (!stackTraceElement.getMethodName().equals(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                logRecord.setSourceClassName(stackTraceElement.getClassName());
                logRecord.setSourceMethodName(stackTraceElement.getMethodName());
                logRecord.setResourceBundleName(stackTraceElement.getFileName());
                if (string == null) {
                    try {
                        string = Class.forName(stackTraceElement.getFileName()).getSimpleName();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string == null) {
                    try {
                        Class<?> clazz = Class.forName(stackTraceElement.getClassName());
                        string = clazz.isAnonymousClass() ? stackTraceElement.getClassName() : clazz.getSimpleName();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string != null) break;
                if (stackTraceElement.getFileName() == null) {
                    string = stackTraceElement.getClassName();
                    break;
                }
                if (stackTraceElement.getFileName().lastIndexOf(46) <= -1) break;
                string = stackTraceElement.getFileName().substring(0, stackTraceElement.getFileName().lastIndexOf(46));
                break;
            }
        }
        logRecord.setLoggerName(string);
        logRecord.setThreadID(Long.valueOf(Thread.currentThread().getId()).intValue());
        logRecord.setThrown(throwable);
        if (this.systemLogger != null) {
            this.systemLogger.log(logRecord);
        } else if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    protected final void instantiatePlugin(PluginInitInfo pluginInitInfo) {
        try {
            Class<?> clazz = Class.forName(pluginInitInfo.getClassName(), false, DSConstants.getClassLoader());
            Plugin plugin = this.workbench.startPlugin(clazz, pluginInitInfo.getInstanceName(), pluginInitInfo.getInitArgs(), Alignment.getAlignment((String)pluginInitInfo.getAlign()), pluginInitInfo.getIcon(), true);
            if (plugin == null) {
                this.logEvent(Level.WARNING, "Failed to add plugin of class" + clazz);
            } else {
                plugin.setIdentifier(pluginInitInfo.getIdentifier());
            }
            if (pluginInitInfo.isDetached()) {
                this.workbench.enqueAction(PluginWorkbench.PluginWorkbenchAction.DETACHPLUGIN, new Object[]{plugin, pluginInitInfo.getFrameSize(), pluginInitInfo.getFramePosition()});
            } else {
                this.workbench.enqueAction(PluginWorkbench.PluginWorkbenchAction.PREDETACHPLUGIN, new Object[]{plugin, pluginInitInfo.getFrameSize(), pluginInitInfo.getFramePosition()});
            }
            if (!pluginInitInfo.isVisible()) {
                this.workbench.enqueAction((Enum)Workbench.WorkbenchAction.HIDETAB, new Object[]{plugin});
            }
        }
        catch (Throwable throwable) {
            System.err.println("Unable to instantiate " + pluginInitInfo.getClassName());
            throwable.printStackTrace();
        }
    }

    @Override
    public PluginWorkbench getWorkbench() {
        return this.workbench;
    }

    public void unhidePlugin(Plugin plugin) {
        this.workbench.enqueAction((Enum)Workbench.WorkbenchAction.UNHIDETAB, new Object[]{plugin});
    }

    public void hidePlugin(Plugin plugin) {
        this.workbench.enqueAction((Enum)Workbench.WorkbenchAction.HIDETAB, new Object[]{plugin});
    }

    public void detachPlugin(Plugin plugin, Dimension dimension, Point point) {
        this.workbench.enqueAction((Enum)Workbench.WorkbenchAction.DETACHTAB, new Object[]{plugin, dimension, point});
    }

    public boolean allowNewInstance(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return this.workbench.allowNewInstance(clazz);
    }

    public boolean startNewPlugin(Class<?> clazz, String string, List<String> list, boolean bl, boolean bl2) {
        return this.startNewPlugin(clazz, string, list, bl, bl2, Alignment.DEFAULT);
    }

    public boolean startNewPlugin(Class<?> clazz, String string, List<String> list, boolean bl, boolean bl2, Alignment alignment) {
        Plugin plugin = null;
        try {
            plugin = this.workbench.startPlugin(clazz, string, list, alignment, null, bl2);
        }
        catch (Exception exception) {
            this.systemLogger.logp(Level.WARNING, DSClient.class.getName(), "startNewPlugin", exception.getMessage());
            return false;
        }
        if (plugin == null) {
            this.logEvent(Level.WARNING, "Failed to add plugin of class" + clazz);
            return false;
        }
        if (bl) {
            this.workbench.enqueAction((Enum)Workbench.WorkbenchAction.DETACHTAB, new Object[]{plugin, null, null});
        }
        return true;
    }

    public void closePlugin(Plugin plugin) {
        if (plugin.isClosable()) {
            this.workbench.enqueAction(PluginWorkbench.PluginWorkbenchAction.STOPPLUGIN, new Object[]{plugin});
        }
    }

    public void setFocusOnDefaultElement() {
        this.workbench.setFocusOnDefaultElement();
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public JComponent getMainWidget() {
        return this.mainWidget;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setOwningFrame(JFrame jFrame) {
        this.ownerFrame = jFrame;
    }

    public JFrame getOwningFrame() {
        return this.ownerFrame;
    }

    public final Task getTaskById(TaskId taskId) {
        if (taskId == TaskId.NULL || taskId == TaskId.UNINITIALIZED_ID) {
            return null;
        }
        if (taskId.getTask() != null) {
            return taskId.getTask();
        }
        if (taskId.getId() == 0) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation getOperationById(Guid guid) {
        Operation operation;
        Map<Guid, Operation> map = this.opById;
        synchronized (map) {
            operation = this.opById.get(guid);
        }
        if (operation == null) {
            operation = OperationImpl.GenerateOperation(guid);
        }
        return operation;
    }

    public Operation getOperationById(BigInteger bigInteger) {
        return this.getOperationById(Guid.GenerateGuid((BigInteger)bigInteger));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOperation(Operation operation) {
        if (operation == null) {
            return;
        }
        Map<Guid, Operation> map = this.opById;
        synchronized (map) {
            this.opById.put(operation.getGuid(), operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<Operation> getOperationList() {
        Vector<Operation> vector = new Vector<Operation>();
        Map<Guid, Operation> map = this.opById;
        synchronized (map) {
            vector.addAll(this.opById.values());
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<Task> getTaskList() {
        Vector<Task> vector = new Vector<Task>();
        List<MutableTask> list = this.allTasks;
        synchronized (list) {
            vector.addAll(this.allTasks);
        }
        return vector;
    }

    public final Task getRunningTaskById(TaskId taskId) {
        Task task = taskId.getTask();
        if (task == null && (task = this.getTaskById(taskId)) == null) {
            return null;
        }
        if (task.isAlive()) {
            return task;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Task getTaskByTaskId(Guid guid) {
        if (guid == null) {
            return null;
        }
        List<MutableTask> list = this.allTasks;
        synchronized (list) {
            for (MutableTask mutableTask : this.allTasks) {
                if (mutableTask.getTaskId() == null || !mutableTask.getTaskId().equals((Object)guid)) continue;
                return mutableTask;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Task getTaskByTempId(int n) {
        Map<Integer, MutableTask> map = this.taskByTempId;
        synchronized (map) {
            return (Task)this.taskByTempId.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addNewTask(MutableTask mutableTask) {
        if (mutableTask.getId().equals((Object)TaskId.UNINITIALIZED_ID)) {
            Map<Integer, MutableTask> map = this.taskByTempId;
            synchronized (map) {
                this.taskByTempId.put(mutableTask.getTempId(), mutableTask);
            }
        }
        List<MutableTask> list = this.allTasks;
        synchronized (list) {
            this.allTasks.add(mutableTask);
        }
    }

    @Override
    public void registerTaskId(MutableTask mutableTask) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task registerId(int n, TaskId taskId) {
        MutableTask mutableTask;
        Object object = this.taskByTempId;
        synchronized (object) {
            mutableTask = this.taskByTempId.get(n);
            this.taskByTempId.remove(n);
        }
        if (mutableTask == null) {
            return null;
        }
        mutableTask.setId(taskId);
        object = this.allTasks;
        synchronized (object) {
            this.allTasks.add(mutableTask);
        }
        return mutableTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<TaskId> getTaskIdList() {
        Vector<TaskId> vector = new Vector<TaskId>();
        List<MutableTask> list = this.allTasks;
        synchronized (list) {
            for (MutableTask mutableTask : this.allTasks) {
                vector.add(mutableTask.getId());
            }
        }
        return vector;
    }

    protected final void setLocalMode(boolean bl) {
    }

    public final boolean isLocalMode() {
        return false;
    }

    public void setDebugMode(boolean bl) {
        this.debug = bl;
        if (this.repaintManager instanceof CheckThreadViolationRepaintManager) {
            ((CheckThreadViolationRepaintManager)CheckThreadViolationRepaintManager.class.cast(this.repaintManager)).setEnableChecking(this.debug);
        }
    }

    public boolean isDebugMode() {
        return this.debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<KeyStroke, String> getKeyBindings() {
        AbstractCoreController abstractCoreController = this;
        synchronized (abstractCoreController) {
            if (this.keybindings == null) {
                try {
                    this.keybindings = KeybindingConfigParser.parse(DSConstants.getClassLoader().getResourceAsStream("keybindings.xml"));
                }
                catch (XMLException xMLException) {
                    this.logEvent(Level.SEVERE, xMLException.getMessage(), xMLException);
                    return null;
                }
            }
        }
        return this.keybindings;
    }

    public void setupKeyBindings(JComponent jComponent) {
        Map<KeyStroke, String> map = this.getKeyBindings();
        InputMap inputMap = jComponent.getInputMap();
        Set<KeyStroke> set = map.keySet();
        for (KeyStroke keyStroke : set) {
            String string = map.get(keyStroke);
            inputMap.put(keyStroke, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String claimPrompt(Task task) {
        Map<Task, PopupPromptWindow> map = this.taskToPrompt;
        synchronized (map) {
            PopupPromptWindow popupPromptWindow = this.taskToPrompt.get(task);
            if (popupPromptWindow != null && popupPromptWindow.isVisible()) {
                this.taskToPrompt.remove(task);
                popupPromptWindow.setVisible(false);
                popupPromptWindow.dispose();
                return popupPromptWindow.getPromptText();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopPrompt(Task task) {
        Map<Task, PopupPromptWindow> map = this.taskToPrompt;
        synchronized (map) {
            PopupPromptWindow popupPromptWindow = this.taskToPrompt.get(task);
            if (popupPromptWindow != null && popupPromptWindow.isVisible()) {
                popupPromptWindow.setVisible(false);
                popupPromptWindow.dispose();
                this.taskToPrompt.remove(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPrompt(Task task, int n, String string) {
        Map<Task, PopupPromptWindow> map = this.taskToPrompt;
        synchronized (map) {
            PopupPromptWindow popupPromptWindow = this.taskToPrompt.get(task);
            if (popupPromptWindow != null && popupPromptWindow.isVisible()) {
                popupPromptWindow.setVisible(false);
                popupPromptWindow.dispose();
            }
            popupPromptWindow = new PopupPromptWindow(this, task, n, string);
            this.taskToPrompt.put(task, popupPromptWindow);
            popupPromptWindow.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskEnded(Task task) {
        if (task == null) {
            return;
        }
        Map<Task, PopupPromptWindow> map = this.taskToPrompt;
        synchronized (map) {
            PopupPromptWindow popupPromptWindow = this.taskToPrompt.remove(task);
            if (popupPromptWindow != null) {
                popupPromptWindow.setVisible(false);
                popupPromptWindow.dispose();
                this.taskToPrompt.remove(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getResourcePackages() {
        AbstractCoreController abstractCoreController = this;
        synchronized (abstractCoreController) {
            if (this.ResourceDirectories == null) {
                File[] fileArray;
                Vector<String> vector = new Vector<String>();
                vector.add("Ops");
                vector.add("Dsz");
                vector.add(".");
                File file = new File(this.getResourceDirectory());
                if (file.exists() && (fileArray = file.listFiles()) != null) {
                    for (File file2 : fileArray) {
                        if (!file2.isDirectory() || vector.contains(file2.getName())) continue;
                        vector.add(file2.getName());
                    }
                }
                this.ResourceDirectories = vector.toArray(new String[vector.size()]);
            }
        }
        return this.ResourceDirectories;
    }

    public int requestStatistics() {
        try {
            return this.dispatcherClient.requestStatistics();
        }
        catch (Exception exception) {
            this.logEvent(Level.FINE, exception.getMessage(), exception);
            return -1;
        }
    }

    public boolean remove(Runnable runnable) {
        return this.executor.remove(runnable);
    }

    public String getDefaultPackage() {
        return "Dsz";
    }

    public void StealFocus(Plugin plugin) {
        this.workbench.enqueAction((Enum)Workbench.WorkbenchAction.STEALFOCUS, new Object[]{plugin});
    }

    @Override
    public void applicationEnded(String string) {
    }

    public abstract Class<? extends Peer> getPeer();

    public void addPeerReceiver(PeerReceiver peerReceiver) {
        this.listeners.add(PeerReceiver.class, peerReceiver);
    }

    public void removePeerReceiver(PeerReceiver peerReceiver) {
        this.listeners.remove(PeerReceiver.class, peerReceiver);
    }

    public PeerTransferStatus sendMessageToPeer(String string) {
        return this.sendMessageToPeer(string, null);
    }

    public PeerTransferStatus sendMessageToPeer(String string, PeerTag peerTag) {
        if (this.mPeer != null) {
            return this.mPeer.sendMessage(string, peerTag);
        }
        return PeerTransferStatus.DESTINATION_NOT_FOUND;
    }

    @Override
    public void firePeerConnected(PeerTag peerTag) {
        for (PeerReceiver peerReceiver : (PeerReceiver[])this.listeners.getListeners(PeerReceiver.class)) {
            try {
                peerReceiver.newConnection(peerTag);
            }
            catch (Exception exception) {
                this.logEvent(Level.FINER, exception.getMessage(), exception);
            }
        }
    }

    @Override
    public void fireReceivedMessage(String string, PeerTag peerTag) {
        for (PeerReceiver peerReceiver : (PeerReceiver[])this.listeners.getListeners(PeerReceiver.class)) {
            try {
                peerReceiver.receivedMessage(string, peerTag);
            }
            catch (Exception exception) {
                this.logEvent(Level.FINER, exception.getMessage(), exception);
            }
        }
    }

    @Override
    public void registerPeer(Peer peer) {
        this.mPeer = peer;
    }

    @Override
    public void firePeerDisconnected(PeerTag peerTag) {
        for (PeerReceiver peerReceiver : (PeerReceiver[])this.listeners.getListeners(PeerReceiver.class)) {
            try {
                peerReceiver.closedConnection(peerTag);
            }
            catch (Exception exception) {
                this.logEvent(Level.FINER, exception.getMessage(), exception);
            }
        }
    }

    public List<HostInfo> getHosts() {
        Vector<HostInfo> vector = new Vector<HostInfo>();
        vector.addAll(this.hosts);
        return vector;
    }

    public HostInfo getHostById(String string) {
        if (string == null) {
            return this.getHostById("localhost");
        }
        for (FilloutPattern filloutPattern : fillouts) {
            string = filloutPattern.fillout(string);
        }
        Matcher matcher = this.localHostPattern.matcher(string);
        int n = 0;
        if (matcher.matches()) {
            n = 1;
        }
        for (HostInfo hostInfo : this.getHosts()) {
            if ((n == 0 || !hostInfo.isLocal()) && !string.equalsIgnoreCase(hostInfo.getId())) continue;
            return hostInfo;
        }
        return new HostInfoImpl(string, false);
    }

    public boolean hasConnected() {
        for (HostInfo hostInfo : this.getHosts()) {
            if (hostInfo.isLocal()) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected() {
        for (HostInfo hostInfo : this.getHosts()) {
            if (hostInfo.isLocal() || !hostInfo.isConnected()) continue;
            return true;
        }
        return false;
    }

    public int getDispatcherPort() {
        return -1;
    }

    public String getLocalhostAddress() {
        return this.localhostAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostInfo addHostInfo(HostInfo hostInfo) {
        if (hostInfo == null) {
            return new HostInfoImpl("", true);
        }
        List<HostInfo> list = this.hosts;
        synchronized (list) {
            for (HostInfo hostInfo2 : this.hosts) {
                if (!hostInfo2.getId().equals(hostInfo.getId())) continue;
                return hostInfo2;
            }
            this.hosts.add(hostInfo);
        }
        this.fireConnectionNewHost(hostInfo);
        return hostInfo;
    }

    public CoreController.OperationState getOperationState() {
        return CoreController.OperationState.Inactive;
    }

    public String getTitle() {
        String string = this.title;
        if (this.userTitle != null) {
            string = string + " - " + this.userTitle;
        }
        return string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public boolean isFullStop() {
        return this.fullStop;
    }

    public String translate(String string) {
        return string.toUpperCase();
    }

    public void stop() {
        BlockingInputStream.setEnded();
    }

    public List<TaskId> getTaskChildren(TaskId taskId) {
        ArrayList<TaskId> arrayList = new ArrayList<TaskId>();
        for (Task task : this.getTaskList()) {
            if (!task.getParentId().equals((Object)taskId)) continue;
            arrayList.add(task.getId());
        }
        return arrayList;
    }

    public Dimension getLabelImageSize() {
        return DSConstants.getLabelImageSize();
    }

    public Dimension getTabImageSize() {
        return DSConstants.getTabImageSize();
    }

    public void setCommandEnvironmentVariable(String string, String string2) {
        this.setCommandEnvironmentVariable(string, string2, null);
    }

    public void setCommandEnvironmentVariable(String string, String string2, HostInfo hostInfo) {
    }

    private static class FilloutPattern {
        Pattern pattern;
        String start;

        public FilloutPattern(String string, String string2) {
            this.pattern = Pattern.compile(string);
            this.start = string2;
        }

        public String fillout(String string) {
            Matcher matcher = this.pattern.matcher(string);
            if (!matcher.matches()) {
                return string;
            }
            return String.format("%s%s", this.start, matcher.group(1));
        }
    }
}

