/*
 * Decompiled with CFR 0.152.
 */
package ds.core.commanddispatcher.live;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.task.MutableTask;
import ddb.dsz.core.task.TaskId;
import ds.core.commanddispatcher.LiveCommandDispatcher;
import ds.core.commanddispatcher.live.MessageClosure;
import ds.core.commandevents.CommandEventImpl;
import ds.jaxb.ipc.Message;
import ds.jaxb.ipc.StopPromptType;
import java.util.logging.Level;

public class StopPromptClosure
extends MessageClosure {
    public StopPromptClosure(LiveCommandDispatcher liveCommandDispatcher) {
        super(liveCommandDispatcher);
    }

    protected boolean evaluateMessage(Message message) {
        if (message.getReq() == null) {
            return false;
        }
        StopPromptType stopPromptType = message.getReq().getStopPrompt();
        return stopPromptType != null;
    }

    protected void handleMessage(Message message) {
        StopPromptType stopPromptType = message.getReq().getStopPrompt();
        if (this.live.getMainSystem().isDebugMode()) {
            this.live.getMainSystem().logEvent(Level.FINEST, "Recieved stop prompt");
        }
        int n = message.getReq().getReqId();
        TaskId taskId = this.createTaskId(stopPromptType.getCmdId());
        MutableTask mutableTask = this.getTaskById(taskId);
        if (mutableTask == null) {
            this.live.getMainSystem().logEvent(Level.SEVERE, "Received prompt request for unknown command");
            this.live.handleUnknownTaskPrompt(message);
            return;
        }
        mutableTask.setInPromptMode(false);
        TaskId taskId2 = mutableTask.getParentId();
        String string = mutableTask.getCommandName();
        String string2 = stopPromptType.getValue();
        CommandEventImpl commandEventImpl = new CommandEventImpl((Object)this, CommandEvent.CommandEventType.STOP_PROMPT, string, string2, taskId, taskId2, mutableTask.getTargetId(), n);
        commandEventImpl.setCurrentOperation(true);
        commandEventImpl.setTargetAddress(mutableTask.getTargetId());
        this.live.publishEvent(commandEventImpl);
        try {
            this.live.sendPromptStopped(taskId, n);
        }
        catch (Exception exception) {
            this.live.getMainSystem().logEvent(Level.SEVERE, exception.getMessage(), exception);
        }
    }
}

